/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.crypto.sdf.SdfECSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfEcSignerWithSoftDigest;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcTlsSM2SignerSdf
extends BcTlsSigner {
    protected BcTlsSM2SignerSdf(BcTlsCryptoSdf crypto, AsymmetricKeyParameter privateKey) {
        super(crypto, privateKey);
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        try {
            BcTlsCryptoSdf cryptoSdf = (BcTlsCryptoSdf)this.crypto;
            Object signer = cryptoSdf.isUseBC() ? new SdfEcSignerWithSoftDigest(cryptoSdf.getSdfCryptoType()) : new SdfECSigner(cryptoSdf.getSdfCryptoType());
            signer.init(true, (CipherParameters)this.privateKey);
            signer.update(hash, 0, hash.length);
            byte[] sign = signer.generateSignature();
            signer.release();
            return sign;
        }
        catch (SdfSDKException | CryptoException e) {
            throw new TlsFatalAlert(80, e);
        }
    }
}

