/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcTlsSM2Verifier
extends BcTlsVerifier {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public BcTlsSM2Verifier(BcTlsCrypto crypto, ECPublicKeyParameters publicKey) {
        super(crypto, (AsymmetricKeyParameter)publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SM2Signer signer = new SM2Signer();
        signer.init(false, (CipherParameters)this.publicKey);
        signer.update(hash, 0, hash.length);
        byte[] signature = signedParams.getSignature();
        boolean verified = signer.verifySignature(signature);
        if (!verified) {
            ECPublicKeyParameters pub = (ECPublicKeyParameters)this.publicKey;
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"hash", (byte[])hash);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"signature", (byte[])signature);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"public key ", (byte[])pub.getQ().getEncoded(false));
        }
        return verified;
    }
}

