/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.cert.build.tools;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.test.GMSSLX509CertUtils;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Scanner;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Main {
    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0] == null || !"Bc".equalsIgnoreCase(args[0]) && !"YunHsm".equalsIgnoreCase(args[0]) && !"Pcie".equalsIgnoreCase(args[0])) {
            System.out.println("Please insert cert type Example : Bc, YunHsm, Pcie,");
            return;
        }
        Scanner in = new Scanner(System.in);
        System.out.println("Please insert cert save path");
        String path = in.next();
        System.out.println("Please insert rootDn");
        String rootDn = in.next();
        System.out.println("Please insert signDn");
        String signDn = in.next();
        System.out.println("Please insert encDn");
        String encDn = in.next();
        if ("Bc".equalsIgnoreCase(args[0])) {
            Main.genreateGMSSLCertByBC(rootDn, signDn, encDn, path);
            return;
        }
        System.out.println("Please insert ca Private Key Index");
        int caIndex = in.nextInt();
        System.out.println("Please insert ca Private Key Password");
        String caPrivateKeyPassword = in.next();
        System.out.println("Please insert Server Private Key Index");
        int serverIndex = in.nextInt();
        System.out.println("Please insert Server Private Key Password");
        String serverPrivateKeyPassword = in.next();
        if ("YunHsm".equalsIgnoreCase(args[0])) {
            Main.generateGMSSLCertByYunHsm(rootDn, signDn, encDn, caIndex, caPrivateKeyPassword, serverIndex, serverPrivateKeyPassword, path);
        } else {
            Main.generateGMSSLCertByPcie(rootDn, signDn, encDn, caIndex, caPrivateKeyPassword, serverIndex, serverPrivateKeyPassword, path);
        }
    }

    public static void genreateGMSSLCertByBC(String rootDn, String signDn, String encDn, String path) throws Exception {
        KeyPair caKeyPair = GMSSLX509Utils.generateSM2KeyPair();
        X509Certificate caCert = GMSSLX509CertUtils.genRootCertByBC((String)rootDn, (KeyPair)caKeyPair);
        KeyPair signKeyPair = GMSSLX509Utils.generateSM2KeyPair();
        X509Certificate signCert = GMSSLX509CertUtils.genSignCertByBC((String)signDn, (KeyPair)signKeyPair, (String)rootDn, (KeyPair)caKeyPair);
        KeyPair encKeyPair = GMSSLX509Utils.generateSM2KeyPair();
        X509Certificate encCert = GMSSLX509CertUtils.genEncCertByBC((String)encDn, (KeyPair)signKeyPair, (String)rootDn, (KeyPair)caKeyPair);
        GMSSLX509CertUtils.saveCert((X509Certificate)caCert, (X509Certificate)signCert, (X509Certificate)encCert, (PrivateKey)signKeyPair.getPrivate(), (PrivateKey)encKeyPair.getPrivate(), (String)path);
    }

    public static void generateGMSSLCertByYunHsm(String rootDn, String signDn, String encDn, int caPrivateKeyIndex, String caPrivateKeyPassword, int ServerPrivateKeyIndex, String serverPrivatePassword, String path) throws Exception {
        X509Certificate rootCertByPCIE = GMSSLX509CertUtils.genRootCertByYunHsm((String)rootDn, (int)caPrivateKeyIndex, (String)caPrivateKeyPassword);
        X509Certificate signCertByPCIE = GMSSLX509CertUtils.genSignCertByYunHsm((String)signDn, (int)ServerPrivateKeyIndex, (String)rootDn, (int)caPrivateKeyIndex, (String)caPrivateKeyPassword);
        X509Certificate encCertByPCIE = GMSSLX509CertUtils.genEncCertByYunHsm((String)encDn, (int)ServerPrivateKeyIndex, (String)rootDn, (int)caPrivateKeyIndex, (String)caPrivateKeyPassword);
        GMSSLX509CertUtils.saveCert((X509Certificate)rootCertByPCIE, (X509Certificate)signCertByPCIE, (X509Certificate)encCertByPCIE, (PrivateKey)new SdfPrivateKey(ServerPrivateKeyIndex, serverPrivatePassword.getBytes()), (PrivateKey)new SdfPrivateKey(ServerPrivateKeyIndex, serverPrivatePassword.getBytes()), (String)path);
    }

    public static void generateGMSSLCertByPcie(String rootDn, String signDn, String encDn, int caPrivateKeyIndex, String caPrivateKeyPassword, int ServerPrivateKeyIndex, String serverPrivatePassword, String path) throws Exception {
        X509Certificate rootCertByPCIE = GMSSLX509CertUtils.genRootCertByPCIE((String)rootDn, (int)caPrivateKeyIndex, (String)caPrivateKeyPassword);
        X509Certificate signCertByPCIE = GMSSLX509CertUtils.genSignCertByPCIE((String)signDn, (int)ServerPrivateKeyIndex, (String)rootDn, (int)caPrivateKeyIndex, (String)caPrivateKeyPassword);
        X509Certificate encCertByPCIE = GMSSLX509CertUtils.genEncCertByPCIE((String)encDn, (int)ServerPrivateKeyIndex, (String)rootDn, (int)caPrivateKeyIndex, (String)caPrivateKeyPassword);
        GMSSLX509CertUtils.saveCert((X509Certificate)rootCertByPCIE, (X509Certificate)signCertByPCIE, (X509Certificate)encCertByPCIE, (PrivateKey)new SdfPrivateKey(ServerPrivateKeyIndex, serverPrivatePassword.getBytes()), (PrivateKey)new SdfPrivateKey(ServerPrivateKeyIndex, serverPrivatePassword.getBytes()), (String)path);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

