package com.xdja.pki.gmssl.main.cert.build.tools;

/**
 * @ClassName Main
 * @Description TODO
 * @Date 2019/6/10 11:33
 * @Author FengZhen
 */

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.test.GMSSLX509CertUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.*;
import java.security.cert.X509Certificate;
import java.util.Scanner;

/**
 * @description: 通过PCIE卡 BC和密码机签发证书
 * @date: 9:05 2019/6/10
 */
public class Main {
    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0] == null ||
                !("Bc".equalsIgnoreCase(args[0]) || ("YunHsm").equalsIgnoreCase(args[0]) || "Pcie".equalsIgnoreCase(args[0]))) {
            System.out.println("Please insert cert type Example : Bc, YunHsm, Pcie,");
            return;
        }
        Scanner in = new Scanner(System.in);
        System.out.println("Please insert cert save path");
        String path = in.next();
        System.out.println("Please insert rootDn");
        String rootDn = in.next();
        System.out.println("Please insert signDn");
        String signDn = in.next();
        System.out.println("Please insert encDn");
        String encDn = in.next();
        if ("Bc".equalsIgnoreCase(args[0])) {
            genreateGMSSLCertByBC(rootDn, signDn, encDn, path);
            return;
        }

        System.out.println("Please insert ca Private Key Index");
        int caIndex = in.nextInt();
        System.out.println("Please insert ca Private Key Password");
        String caPrivateKeyPassword = in.next();
        System.out.println("Please insert Server Private Key Index");
        int serverIndex = in.nextInt();
        System.out.println("Please insert Server Private Key Password");
        String serverPrivateKeyPassword = in.next();

        if ("YunHsm".equalsIgnoreCase(args[0])) {
            generateGMSSLCertByYunHsm(rootDn, signDn, encDn, caIndex, caPrivateKeyPassword, serverIndex, serverPrivateKeyPassword, path);
        } else {
            generateGMSSLCertByPcie(rootDn, signDn, encDn, caIndex, caPrivateKeyPassword, serverIndex, serverPrivateKeyPassword, path);

        }
    }

    public static void genreateGMSSLCertByBC(String rootDn, String signDn, String encDn, String path) throws Exception {
        KeyPair caKeyPair = GMSSLX509Utils.generateSM2KeyPair();
        X509Certificate caCert = GMSSLX509CertUtils.genRootCertByBC(rootDn, caKeyPair);
        KeyPair signKeyPair = GMSSLX509Utils.generateSM2KeyPair();
        X509Certificate signCert = GMSSLX509CertUtils.genSignCertByBC(signDn, signKeyPair, rootDn, caKeyPair);
        KeyPair encKeyPair = GMSSLX509Utils.generateSM2KeyPair();
        X509Certificate encCert = GMSSLX509CertUtils.genEncCertByBC(encDn, signKeyPair, rootDn, caKeyPair);
        GMSSLX509CertUtils.saveCert(caCert, signCert, encCert, signKeyPair.getPrivate(), encKeyPair.getPrivate(), path);
    }
    public static void generateGMSSLCertByYunHsm(String rootDn, String signDn, String encDn,
                                               int caPrivateKeyIndex, String caPrivateKeyPassword,
                                               int ServerPrivateKeyIndex, String serverPrivatePassword, String path) throws Exception {

        X509Certificate rootCertByPCIE = GMSSLX509CertUtils.genRootCertByYunHsm(rootDn, caPrivateKeyIndex, caPrivateKeyPassword);
        X509Certificate signCertByPCIE = GMSSLX509CertUtils.genSignCertByYunHsm(signDn, ServerPrivateKeyIndex, rootDn, caPrivateKeyIndex, caPrivateKeyPassword);
        X509Certificate encCertByPCIE = GMSSLX509CertUtils.genEncCertByYunHsm(encDn, ServerPrivateKeyIndex, rootDn, caPrivateKeyIndex, caPrivateKeyPassword);
        GMSSLX509CertUtils.saveCert(rootCertByPCIE, signCertByPCIE, encCertByPCIE, new SdfPrivateKey(ServerPrivateKeyIndex, serverPrivatePassword.getBytes()),
                new SdfPrivateKey(ServerPrivateKeyIndex, serverPrivatePassword.getBytes()), path);

    }

    public static void generateGMSSLCertByPcie(String rootDn, String signDn, String encDn,
                                               int caPrivateKeyIndex, String caPrivateKeyPassword,
                                               int ServerPrivateKeyIndex, String serverPrivatePassword, String path) throws Exception {

        X509Certificate rootCertByPCIE = GMSSLX509CertUtils.genRootCertByPCIE(rootDn, caPrivateKeyIndex, caPrivateKeyPassword);
        X509Certificate signCertByPCIE = GMSSLX509CertUtils.genSignCertByPCIE(signDn, ServerPrivateKeyIndex, rootDn, caPrivateKeyIndex, caPrivateKeyPassword);
        X509Certificate encCertByPCIE = GMSSLX509CertUtils.genEncCertByPCIE(encDn, ServerPrivateKeyIndex, rootDn, caPrivateKeyIndex, caPrivateKeyPassword);
        GMSSLX509CertUtils.saveCert(rootCertByPCIE, signCertByPCIE, encCertByPCIE, new SdfPrivateKey(ServerPrivateKeyIndex, serverPrivatePassword.getBytes()),
                new SdfPrivateKey(ServerPrivateKeyIndex, serverPrivatePassword.getBytes()), path);

    }
}
