/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.cert.build.tools;

import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLP10Utils;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonP10CertGenerate {
    private static Logger logger = LoggerFactory.getLogger(AmazonP10CertGenerate.class);

    public static void main(String[] args) throws Exception {
        int index = 74;
        String subjectName = "cn=test,o=xdja,c=cn";
        String signAlgName = "SHA512WITHECDSA";
        String userName = "willard_crypto";
        String password = "Anker705.";
        GMSSLPkiCryptoInit.getAmazonHsmInstance((String)userName, (String)password);
        AmazonP10CertGenerate.generateP10(index, subjectName, signAlgName);
    }

    public static void generateP10(int index, String subjectName, String signAlgName) {
        try {
            logger.debug("#####################generateP10  {} test start ########################", (Object)subjectName);
            PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)GMSSLECKeyUtils.NISTp256, (boolean)false);
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, "");
            PKCS10CertificationRequest pkcs10CertificationRequest = GMSSLP10Utils.generateP10((String)subjectName, (PublicKey)publicKey, (PrivateKey)sdfPrivateKey, (String)signAlgName, (boolean)false);
            boolean verifyByHsm = GMSSLP10Utils.verifyP10((PKCS10CertificationRequest)pkcs10CertificationRequest);
            System.out.println(pkcs10CertificationRequest);
            GMSSLP10Utils.writeP10ToFile((String)"./", (String)(subjectName + "_" + index + ".p10"), (Object)pkcs10CertificationRequest);
            GMSSLPkiCryptoInit.getBCInstance();
            boolean verifyByBc = GMSSLP10Utils.verifyP10((PKCS10CertificationRequest)pkcs10CertificationRequest);
            System.out.println(pkcs10CertificationRequest.getSubjectPublicKeyInfo());
            System.out.println(pkcs10CertificationRequest.getSignatureAlgorithm());
            logger.debug("verifyByHsm {} ", (Object)verifyByHsm);
            logger.debug("verifyByBc {} ", (Object)verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################generateP10   test error ########################");
                System.exit(0);
            }
            logger.debug("#####################generateP10   test success ########################");
        }
        catch (Exception e) {
            logger.error("#####################generateP10   test error ########################", (Throwable)e);
            System.exit(0);
        }
    }
}

