package com.xdja.pki.gmssl.minipcie.demo;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.MiniPcieFile;
import com.xdja.SafeKey.bean.MiniPcieIndexEnum;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2020/5/29 14:19
 **/
public class MiniPcieCreateFile {
    static JNIAPI jniapi = new JNIAPI();

    public static void createFile(int fileId) {
        int ret = 0;
        int[] devNum = {0};
        long[] handle = {0};
        ret = jniapi.EnumDev(JNIAPI.CT_USBDEV, devNum);
        if (JNIAPI.XKR_OK != ret) {
            System.out.println("EnmuDev error, ret=" + ret);
            return;
        }
        ret = jniapi.OpenDev(0, handle);
        if (JNIAPI.XKR_OK != ret) {
            System.out.println("OpenDev error, ret=" + ret);
            return;
        }
        try {
            ret = jniapi.VerifyPIN(handle[0], JNIAPI.ROLE_A, "111111".getBytes(), 6);
            if (JNIAPI.XKR_OK != ret) {
                System.out.println("VerifyPIN error, ret=" + ret);
                return;
            }
            testCreateEncCertDir(handle, fileId);
            testCreateEncCertPri(handle, fileId);
            testCreateEncCertPub(handle, fileId);
            testCreateSignCertDir(handle, fileId);
            testCreateSignCertPri(handle, fileId);
            testCreateSignCertPub(handle, fileId);
        } finally {

            jniapi.CloseDev(handle[0]);
        }
    }

    public static void testCreateSignCertDir(long[] handle, int fileId) {
        MiniPcieFile file = new MiniPcieFile();
        file.type = JNIAPI.FILE_BINARY;
        file.id = MiniPcieIndexEnum.getInfoFromIndex(fileId).getSignCertIndex();
        file.read_Acl = (byte) 0xf0;
        file.write_Acl = 0x11;
        file.room = 0x0600;
        int ret = jniapi.CreateFile(handle[0], file);
        if (ret != 0) {
            if (ret == -23) {
                System.out.println("######文件已存在############");
            }
            System.out.println("!!!!!!!!!!!!!!!!!!!!createError!!!!!!!!!!!!!!!!");
        }
    }

    public static void testCreateEncCertDir(long[] handle, int fileId) {
        MiniPcieFile file = new MiniPcieFile();
        file.type = JNIAPI.FILE_BINARY;
        file.id = MiniPcieIndexEnum.getInfoFromIndex(fileId).getEncCertIndex();
        file.read_Acl = (byte) 0xf0;
        file.write_Acl = 0x11;
        file.room = 0x0600;
        int ret = jniapi.CreateFile(handle[0], file);
        if (ret != 0) {
            if (ret == -23) {
                System.out.println("######文件已存在############");
            }
            System.out.println("!!!!!!!!!!!!!!!!!!!!createError!!!!!!!!!!!!!!!!");
        }
    }

    public static void testCreateSignCertPri(long[] handle, int fileId) {
        MiniPcieFile file = new MiniPcieFile();
        file.type = JNIAPI.FILE_PRIVATE;
        file.id = MiniPcieIndexEnum.getInfoFromIndex(fileId).getSignPrivateIndex();
        file.use_Acl = (byte) 0x11;
        file.write_Acl = 0x11;
        file.room = 0x0400;
        int ret = jniapi.CreateFile(handle[0], file);
        if (ret != 0) {
            if (ret == -23) {
                System.out.println("######文件已存在############");
            }
            System.out.println("!!!!!!!!!!!!!!!!!!!!createError!!!!!!!!!!!!!!!!");
        }
    }

    public static void testCreateEncCertPri(long[] handle, int fileId) {
        MiniPcieFile file = new MiniPcieFile();
        file.type = JNIAPI.FILE_PRIVATE;
        file.id = MiniPcieIndexEnum.getInfoFromIndex(fileId).getEncPrivateIndex();
        file.use_Acl = (byte) 0x11;
        file.write_Acl = 0x11;
        file.room = 0x0400;
        int ret = jniapi.CreateFile(handle[0], file);
        if (ret != 0) {
            if (ret == -23) {
                System.out.println("######文件已存在############");
            }
            System.out.println("!!!!!!!!!!!!!!!!!!!!createError!!!!!!!!!!!!!!!!");
        }
    }

    public static void testCreateSignCertPub(long[] handle, int fileId) {
        MiniPcieFile file = new MiniPcieFile();
        file.type = JNIAPI.FILE_PUBLIC;
        file.id = MiniPcieIndexEnum.getInfoFromIndex(fileId).getSignPublicKeyIndex();
        file.read_Acl = (byte) 0xf0;
        file.use_Acl = (byte) 0xf0;
        file.write_Acl = 0x11;
        file.room = 0x0200;
        int ret = jniapi.CreateFile(handle[0], file);
        if (ret != 0) {
            if (ret == -23) {
                System.out.println("######文件已存在############");
            }
            System.out.println("!!!!!!!!!!!!!!!!!!!!createError!!!!!!!!!!!!!!!!");
        }
    }

    public static void testCreateEncCertPub(long[] handle, int fileId) {
        MiniPcieFile file = new MiniPcieFile();
        file.type = JNIAPI.FILE_PUBLIC;
        file.id = MiniPcieIndexEnum.getInfoFromIndex(fileId).getEncPublicKeyIndex();
        file.read_Acl = (byte) 0xf0;
        file.use_Acl = (byte) 0xf0;
        file.write_Acl = 0x11;
        file.room = 0x0200;
        int ret = jniapi.CreateFile(handle[0], file);
        if (ret != 0) {
            if (ret == -23) {
                System.out.println("######文件已存在############");
            }
            System.out.println("!!!!!!!!!!!!!!!!!!!!createError!!!!!!!!!!!!!!!!");
        }
    }
}
