package com.xdja.pki.gmssl.minipcie.demo.utils;

import com.xdja.SafeKey.bean.MiniPcieIndexEnum;
import com.xdja.SafeKey.utils.MiniPcieXKFUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.*;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.util.encoders.Hex;
import org.junit.Assert;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2020/5/29 14:51
 **/
public class MiniPcieUtilsMain {

    public static final String SM1_TEST = "sm1";
    public static final String SM2_ENCRYPT = "sm2Encrypt";
    public static final String SM2_SIGN = "sm2Sign";
    public static final String SM3_TEST = "sm3";
    public static final String SM4_TEST = "sm4";
    public static final String GEN_KEY_PAIR = "genKeyPair";
    public static final String READ_PUBLIC_KEY = "readPublickey";
    public static final String GEN_KEY_IN_CONTAINER = "genKeyInContainer";
    public static final String IMPORT_KEY = "importKey";
    public static final String IMPORT_CERT = "importCert";
    public static final String GENERATE_RANDOM = "random";


    public static void main(String[] args) throws Exception {
        switch (args[0]) {
            case SM1_TEST:
                testSM1();
                break;
            case SM2_ENCRYPT:
                testSm2Encrypt();
                testSm2ASN1Encrypt();
                break;
            case SM2_SIGN:
                testSM2Sign();
                break;
            case SM3_TEST:
                testSM3Digest();
                break;
            case SM4_TEST:
                testSM4NoPadding();
                testSM4PKCS7();
                //testSM4SSLV3();
                break;
            case GEN_KEY_PAIR:
                testGenerateKeyPair();
                break;
            case READ_PUBLIC_KEY:
                getPublicKeyFromHardware();
                break;
            case GEN_KEY_IN_CONTAINER:
                genKeyPair();
                break;
            case IMPORT_KEY:
                importKey();
            case IMPORT_CERT:
                testGenerateCertByMiniPcie();
                break;
            case GENERATE_RANDOM:
                GMSSLPkiCryptoInit.getMiniPcieInstance();
                byte[] bytes = GMSSLRandomUtils.generateRandom(32);
                System.out.println(Hex.toHexString(bytes));
                break;
            case "all":
                testSM1();
                testSM2Sign();
                testSM3Digest();
                testSM4NoPadding();
                testSM4PKCS7();
                testGenerateKeyPair();
                importKey();
                testGenerateCertByMiniPcie();
                GMSSLPkiCryptoInit.getMiniPcieInstance();
                byte[] byteA = GMSSLRandomUtils.generateRandom(32);
                System.out.println(Hex.toHexString(byteA));
                genKeyPair();
                testSm2Encrypt();
                testSm2ASN1Encrypt();
                testGenerateCertByMiniPcieSign();
                testGenerateCertByMiniPcieEnc();
                break;
            default:
                System.out.println("un support the method " + args[0]);
                break;
        }
    }

    private static void genKeyPair() throws Exception {
        int fileId = 1;
        MiniPcieXKFUtils.generateSm2KeyPairInContent(
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getSignPublicKeyIndex(),
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getSignPrivateIndex()
        );
        MiniPcieXKFUtils.generateSm2KeyPairInContent(
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getEncPublicKeyIndex(),
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getEncPrivateIndex()
        );
        fileId = 2;
        MiniPcieXKFUtils.generateSm2KeyPairInContent(
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getSignPublicKeyIndex(),
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getSignPrivateIndex()
        );
        MiniPcieXKFUtils.generateSm2KeyPairInContent(
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getEncPublicKeyIndex(),
                MiniPcieIndexEnum.getInfoFromIndex(fileId).getEncPrivateIndex()
        );
    }

    public static void importKey() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair(GMSSLECKeyUtils.SM2p256);
        GMSSLECKeyUtils.writeKeyPairToHardWare(1, "111111", keyPair, true);
        keyPair = GMSSLECKeyUtils.generateECKeyPair(GMSSLECKeyUtils.SM2p256);
        GMSSLECKeyUtils.writeKeyPairToHardWare(1, "111111", keyPair, false);

        keyPair = GMSSLECKeyUtils.generateECKeyPair(GMSSLECKeyUtils.SM2p256);
        GMSSLECKeyUtils.writeKeyPairToHardWare(2, "111111", keyPair, true);
        keyPair = GMSSLECKeyUtils.generateECKeyPair(GMSSLECKeyUtils.SM2p256);
        GMSSLECKeyUtils.writeKeyPairToHardWare(2, "111111", keyPair, false);
        System.out.println("##########Import KeyPair Success ###########");

    }

    public static void getPublicKeyFromHardware() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        PublicKey publicKey1 = GMSSLECKeyUtils.getPublicKeyFromHardware(1, GMSSLECKeyUtils.SM2p256, true);
        PublicKey publicKey2 = GMSSLECKeyUtils.getPublicKeyFromHardware(1, GMSSLECKeyUtils.SM2p256, false);
        PublicKey publicKey3 = GMSSLECKeyUtils.getPublicKeyFromHardware(2, GMSSLECKeyUtils.SM2p256, true);
        PublicKey publicKey4 = GMSSLECKeyUtils.getPublicKeyFromHardware(2, GMSSLECKeyUtils.SM2p256, false);
        System.out.println(publicKey1);
        System.out.println(publicKey2);
        System.out.println(publicKey3);
        System.out.println(publicKey4);
        System.out.println("##########Read Public Key Success ###########");
    }

    public static void testGenerateKeyPair() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair(GMSSLECKeyUtils.SM2p256);
        System.out.println(keyPair.getPublic());
        System.out.println(keyPair.getPrivate());
        System.out.println("##########testGenerateKeyPair Success ###########");
    }

    public static void testSM4SSLV3() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        byte[] key = Hex.decode("11aa1234567abcdef123456789abcdef");
        byte[] encrypt = GMSSLSM4ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.SSL3Padding);
        byte[] decrypt1 = GMSSLSM4ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.SSL3Padding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decrypt3 = GMSSLSM4ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.SSL3Padding);
        Assert.assertArrayEquals(decrypt1, data);
        Assert.assertArrayEquals(decrypt3, data);
        System.out.println(new String(decrypt1));
        System.out.println(new String(decrypt3));
        System.out.println("##########SM4 SSL3Padding ENCRYPT Success ###########");
    }

    public static void testSM4PKCS7() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        byte[] key = Hex.decode("11123456789abcdef123456789abcdef");
        byte[] encrypt = GMSSLSM4ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decrypt1 = GMSSLSM4ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decrypt3 = GMSSLSM4ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        Assert.assertArrayEquals(decrypt1, data);
        Assert.assertArrayEquals(decrypt3, data);
        System.out.println(new String(decrypt1));
        System.out.println(new String(decrypt3));
        System.out.println("##########SM4 PKCS7Padding ENCRYPT Success ###########");
    }

    public static void testSM4NoPadding() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] key = Hex.decode("11123456789abcdef123456789abcdef");
        byte[] encrypt = GMSSLSM4ECBEncryptUtils.encrypt(key, key, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        byte[] decrypt1 = GMSSLSM4ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decrypt2 = GMSSLSM4ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        Assert.assertArrayEquals(decrypt1, key);
        Assert.assertArrayEquals(decrypt2, key);
        System.out.println(Hex.toHexString(decrypt1));
        System.out.println(Hex.toHexString(decrypt2));
        System.out.println("##########SM4 NoPadding ENCRYPT Success ###########");
    }


    public static void testSm2ASN1Encrypt() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(1, "111111");
        PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware(1, GMSSLECKeyUtils.SM2p256, true);
        byte[] encrypt = GMSSLSM2EncryptUtils.encryptAsn1Data(publicKey, data);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encrypt1 = GMSSLSM2EncryptUtils.encryptAsn1Data(publicKey, data);
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] decrypt = GMSSLSM2EncryptUtils.decryptAsn1Cipher(sdfPrivateKey, encrypt);
        byte[] decrypt1 = GMSSLSM2EncryptUtils.decryptAsn1Cipher(sdfPrivateKey, encrypt1);
        System.out.println(Hex.toHexString(encrypt));
        System.out.println(Hex.toHexString(encrypt1));
        System.out.println(Hex.toHexString(decrypt));
        System.out.println(new String(decrypt));
        System.out.println(Hex.toHexString(decrypt1));
        Assert.assertArrayEquals(decrypt, data);
        Assert.assertArrayEquals(decrypt1, data);
        System.out.println("##########SM2 ASN1 ENCRYPT Success ###########");
    }

    private static void testSM3Digest() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "12352355345345334534534535236746545635345354345354".getBytes();
        byte[] digest = GMSSLSM3DigestUtils.digest(data);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] digest1 = GMSSLSM3DigestUtils.digest(data);
        Assert.assertArrayEquals(digest, digest1);
        System.out.println("##########SM3 Digest Success ###########");
    }


    private static void testSm2Encrypt() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(1, "111111");
        PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware(1, GMSSLECKeyUtils.SM2p256, true);
        byte[] encrypt = GMSSLSM2EncryptUtils.encrypt(publicKey, data);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encrypt1 = GMSSLSM2EncryptUtils.encrypt(publicKey, data);
        GMSSLByteArrayUtils.printHexBinary(null, "encrypt by mini pcie", encrypt);
        GMSSLByteArrayUtils.printHexBinary(null, "encrypt by bc", encrypt1);
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] decrypt = GMSSLSM2EncryptUtils.decrypt(sdfPrivateKey, encrypt);
        byte[] decrypt1 = GMSSLSM2EncryptUtils.decrypt(sdfPrivateKey, encrypt1);
        Assert.assertArrayEquals(decrypt, data);
        Assert.assertArrayEquals(decrypt1, data);
        System.out.println("##########SM2 Encrypt Success ###########");
    }


    private static void testSM2Sign() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(1, "111111");
        PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware(1, GMSSLECKeyUtils.SM2p256, false);
        byte[] sign = GMSSLECSignUtils.sign(sdfPrivateKey, data, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        boolean verify = GMSSLECSignUtils.verify(publicKey, data, sign, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        GMSSLPkiCryptoInit.getBCInstance();
        boolean verify1 = GMSSLECSignUtils.verify(publicKey, data, sign, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        Assert.assertTrue(verify);
        Assert.assertTrue(verify1);
        System.out.println("##########SM2 Sign Success ###########");
    }

    private static void testSM1() throws Exception {
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        byte[] data = "test sm2 sign ".getBytes();
        byte[] key = Hex.decode("11aa1234567abcdef123456789abcdef");
        byte[] encrypt = GMSSLSM1ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.SSL3Padding);
        byte[] decrypt1 = GMSSLSM1ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.SSL3Padding);
        Assert.assertArrayEquals(decrypt1, data);
        System.out.println("##########SM1 SSL3Padding Success ###########");
        encrypt = GMSSLSM1ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        decrypt1 = GMSSLSM1ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        Assert.assertArrayEquals(decrypt1, data);
        System.out.println("##########SM1 PKCS7Padding Success ###########");
        encrypt = GMSSLSM1ECBEncryptUtils.encrypt(key, key, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        decrypt1 = GMSSLSM1ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        Assert.assertArrayEquals(decrypt1, key);
        System.out.println("##########SM1 NoPadding Success ###########");
    }


    public static void testGenerateCertByMiniPcie() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        PublicKey subjectKey = keyPair.getPublic();
        PrivateKey issuerKey = GMSSLECKeyUtils.genSdfPrivateKey(1, "111111");
        String issuer = "CN=ca, O=xdja, C=cn";
        String subject = "CN=user0, O=xdja, C=cn";
        BigInteger serial = BigInteger.valueOf(1);
        Date notBefore = new Date();
        Date notAfter = new Date();
        List<Extension> extensions = new ArrayList<>();
        extensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(1));
        extensions.add(GMSSLExtensionUtils.genAuthorityInfoAccessExtension("ldap://11.12.11.111:389?cACertificate;binary,crossCertificatePair;binary"));
        extensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        X509Certificate certificate = GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, issuerKey, subjectKey, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), extensions, true);
        PublicKey publicKeyFromHardware = GMSSLECKeyUtils.getPublicKeyFromHardware(1, GMSSLECKeyUtils.SM2p256, false);
        boolean b = GMSSLCertUtils.verifyCert(publicKeyFromHardware, certificate);
        System.out.println(b);
        GMSSLPkiCryptoInit.getBCInstance();
        b = GMSSLCertUtils.verifyCert(publicKeyFromHardware, certificate);
        System.out.println(b);
        Assert.assertTrue(b);
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        b = GMSSLCertUtils.verifyCert(publicKeyFromHardware, certificate);
        System.out.println(b);
        Assert.assertTrue(b);
        GMSSLCertUtils.writeCertToHardWare(1, "111111", certificate, false);
        X509Certificate x509Certificate = GMSSLCertUtils.readCertFromHardWare(1, false);
        System.out.println(x509Certificate);
    }

    public static void testGenerateCertByMiniPcieSign() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        PublicKey subjectKey = keyPair.getPublic();
        PrivateKey issuerKey = GMSSLECKeyUtils.genSdfPrivateKey(2, "111111");
        String issuer = "CN=ca, O=xdja, C=cn";
        String subject = "CN=user0, O=xdja, C=cn";
        BigInteger serial = BigInteger.valueOf(1);
        Date notBefore = new Date();
        Date notAfter = new Date();
        List<Extension> extensions = new ArrayList<>();
        extensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(2));
        extensions.add(GMSSLExtensionUtils.genAuthorityInfoAccessExtension("ldap://11.12.11.111:389?cACertificate;binary,crossCertificatePair;binary"));
        extensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        X509Certificate certificate = GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, issuerKey, subjectKey, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), extensions, true);
        PublicKey publicKeyFromHardware = GMSSLECKeyUtils.getPublicKeyFromHardware(2, GMSSLECKeyUtils.SM2p256, false);
        boolean b = GMSSLCertUtils.verifyCert(publicKeyFromHardware, certificate);
        System.out.println(b);
        GMSSLPkiCryptoInit.getBCInstance();
        b = GMSSLCertUtils.verifyCert(publicKeyFromHardware, certificate);
        System.out.println(b);
        Assert.assertTrue(b);
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        b = GMSSLCertUtils.verifyCert(publicKeyFromHardware, certificate);
        System.out.println(b);
        Assert.assertTrue(b);
        GMSSLCertUtils.writeCertToHardWare(2, "111111", certificate, false);
        X509Certificate x509Certificate = GMSSLCertUtils.readCertFromHardWare(2, false);
        System.out.println(x509Certificate);
    }

    public static void testGenerateCertByMiniPcieEnc() throws Exception {
        KeyPair keyPair = GMSSLX509Utils.generateSM2KeyPair();
        PublicKey subjectKey = keyPair.getPublic();
        PrivateKey issuerKey = GMSSLECKeyUtils.genSdfPrivateKey(2, "111111");
        String issuer = "CN=ca, O=xdja, C=cn";
        String subject = "CN=user0, O=xdja, C=cn";
        BigInteger serial = BigInteger.valueOf(1);
        Date notBefore = new Date();
        Date notAfter = new Date();
        List<Extension> extensions = new ArrayList<>();
        extensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(2));
        extensions.add(GMSSLExtensionUtils.genAuthorityInfoAccessExtension("ldap://11.12.11.111:389?cACertificate;binary,crossCertificatePair;binary"));
        extensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        X509Certificate certificate = GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, issuerKey, subjectKey, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), extensions, true);
        PublicKey publicKeyFromHardware = GMSSLECKeyUtils.getPublicKeyFromHardware(2, GMSSLECKeyUtils.SM2p256, true);
        boolean b = GMSSLCertUtils.verifyCert(publicKeyFromHardware, certificate);
        System.out.println(b);
        GMSSLPkiCryptoInit.getBCInstance();
        b = GMSSLCertUtils.verifyCert(publicKeyFromHardware, certificate);
        System.out.println(b);
        Assert.assertTrue(b);
        GMSSLPkiCryptoInit.getMiniPcieInstance();
        b = GMSSLCertUtils.verifyCert(publicKeyFromHardware, certificate);
        System.out.println(b);
        Assert.assertTrue(b);
        GMSSLCertUtils.writeCertToHardWare(2, "111111", certificate, true);
        X509Certificate x509Certificate = GMSSLCertUtils.readCertFromHardWare(2, true);
        System.out.println(x509Certificate);
    }
}
