/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.pcie.demo;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.CryptoException;

public class SM2DecryptASN1 {
    public static void main(String[] args) throws SdfSDKException, CryptoException, IOException {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method, Example: all. decrypt. decryptasn1");
            return;
        }
        System.out.println("You want to test: " + args[0]);
        switch (args[0]) {
            case "all": {
                System.out.println("*************** decrypt ***************");
                SM2DecryptASN1.decrypt();
                System.out.println("*************** decryptasn1 ***************");
                SM2DecryptASN1.decryptasn1();
                break;
            }
            case "decrypt": {
                SM2DecryptASN1.decrypt();
                break;
            }
            case "decryptasn1": {
                SM2DecryptASN1.decryptasn1();
                break;
            }
            default: {
                System.out.println("\u4e0d\u652f\u6301\u7684\u547d\u4ee4\uff01");
            }
        }
    }

    private static void decrypt() throws SdfSDKException, CryptoException, IOException {
        String plainText = GMSSLByteArrayUtils.base64Encode((byte[])"test".getBytes());
        PublicKey signPublicKeyByPcie = GMSSLSM2KeyUtils.getEncryptPublicKeyByPcie((int)2);
        ECPublicKey publicKey = (ECPublicKey)signPublicKeyByPcie;
        String encryptASN1ByBC = GMSSLSM2EncryptUtils.encryptByBC((PublicKey)publicKey, (String)plainText);
        String encryptASN1ByPcie = GMSSLSM2EncryptUtils.encryptByPcie((PublicKey)signPublicKeyByPcie, (String)plainText);
        String decryptASN1ByYunhsum = GMSSLSM2EncryptUtils.decryptByPcie((int)2, (String)"xdja1234", (String)encryptASN1ByPcie);
        System.out.println(encryptASN1ByBC);
        System.out.println(encryptASN1ByPcie);
        System.out.println(decryptASN1ByYunhsum);
    }

    private static void decryptasn1() throws SdfSDKException, CryptoException, IOException {
        String plainText = GMSSLByteArrayUtils.base64Encode((byte[])"test".getBytes());
        PublicKey signPublicKeyByPcie = GMSSLSM2KeyUtils.getEncryptPublicKeyByPcie((int)2);
        ECPublicKey publicKey = (ECPublicKey)signPublicKeyByPcie;
        String encryptASN1ByBC = GMSSLSM2EncryptUtils.encryptASN1ByBC((PublicKey)publicKey, (String)plainText);
        String encryptASN1ByPcie = GMSSLSM2EncryptUtils.encryptASN1ByPcie((PublicKey)signPublicKeyByPcie, (String)plainText);
        String decryptASN1ByYunhsum = GMSSLSM2EncryptUtils.decryptASN1ByPcie((int)2, (String)"xdja1234", (String)encryptASN1ByPcie);
        System.out.println(encryptASN1ByBC);
        System.out.println(encryptASN1ByPcie);
        System.out.println(decryptASN1ByYunhsum);
    }
}

