/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.hmssl.sdf.pcie.buildcert;

import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.test.GMSSLX509CertUtils;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLPCIECertBuild {
    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert cert path");
            return;
        }
        System.out.println("You want to save these certs in : " + args[0]);
        System.out.println("Please");
        GMSSLPCIECertBuild.generateGMSSLPCIEROOTKeyStore(2, "xdja1234", args[0]);
    }

    public static void generateGMSSLPCIEROOTKeyStore(int privateKeyIndex, String privateKeyPassword, String path) throws Exception {
        String rootDn = "cn=rootca,o=pcie,o=xdja,c=cn";
        X509Certificate rootCertByPCIE = GMSSLX509CertUtils.genRootCertByPCIE((String)rootDn, (int)privateKeyIndex, (String)privateKeyPassword);
        String encDn = "cn=encByPcie,o=pcie,o=xdja,c=cn";
        X509Certificate encCertByPCIE = GMSSLX509CertUtils.genEncCertByPCIE((String)encDn, (int)2, (String)rootDn, (int)privateKeyIndex, (String)privateKeyPassword);
        String signDn = "cn=signByPcie,o=pcie,o=xdja,c=cn";
        X509Certificate signCertByPCIE = GMSSLX509CertUtils.genSignCertByPCIE((String)signDn, (int)2, (String)rootDn, (int)privateKeyIndex, (String)privateKeyPassword);
        GMSSLX509CertUtils.saveCert((X509Certificate)rootCertByPCIE, (X509Certificate)signCertByPCIE, (X509Certificate)encCertByPCIE, (PrivateKey)new SdfPrivateKey(2, privateKeyPassword.getBytes()), (PrivateKey)new SdfPrivateKey(2, privateKeyPassword.getBytes()), (String)path);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

