/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.sdf.pcie.demo;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM1ECBEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.util.encoders.Hex;

public class PCIELastTest {
    public static void main(String[] args) throws Exception {
        int index = 4;
        KeyPair signKeyPair = PCIELastTest.generateSM2KeyPairByPCIE();
        KeyPair encKeyPair = PCIELastTest.generateSM2KeyPairByPCIE();
        PCIELastTest.importSM2KeyPair(index, signKeyPair, encKeyPair);
        PCIELastTest.sm2EncryptWith1Index(4);
        PCIELastTest.exportSm2Key(index);
        PCIELastTest.sm2Sign(index, signKeyPair);
        PCIELastTest.sm2Encrypt(index, encKeyPair);
        PCIELastTest.sm1ECb();
        PCIELastTest.sm1ECbPKCS7();
        PCIELastTest.sm3Hash();
        PCIELastTest.sm4ECb();
        PCIELastTest.sm4ECbPKCS7();
    }

    public static KeyPair generateSM2KeyPairByPCIE() throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair((String)GMSSLECKeyUtils.SM2p256);
        System.out.println(keyPair.getPublic());
        System.out.println(keyPair.getPrivate());
        System.out.println("#################################");
        System.out.println("##########\u751f\u6210\u516c\u79c1\u94a5\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
        return new KeyPair(keyPair.getPublic(), keyPair.getPrivate());
    }

    public static void importSM2KeyPair(int index, KeyPair signKeyPair, KeyPair encKeyPair) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        GMSSLECKeyUtils.writeKeyPairToHardWare((int)index, (String)"xdja1234", (KeyPair)encKeyPair, (boolean)true);
        GMSSLECKeyUtils.writeKeyPairToHardWare((int)index, (String)"xdja1234", (KeyPair)signKeyPair, (boolean)false);
        System.out.println(signKeyPair.getPublic());
        System.out.println(signKeyPair.getPrivate());
        System.out.println(encKeyPair.getPublic());
        System.out.println(encKeyPair.getPrivate());
        System.out.println("#################################");
        System.out.println("##########\u5bfc\u5165\u516c\u79c1\u94a5\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void exportSm2Key(int index) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        PublicKey signPublicKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
        PublicKey encPublicKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)GMSSLECKeyUtils.SM2p256, (boolean)false);
        System.out.println(signPublicKey);
        System.out.println(encPublicKey);
        System.out.println("#################################");
        System.out.println("##########\u5bfc\u51fa\u516c\u79c1\u94a5\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void sm2Sign(int index, KeyPair signKeyPair) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] data = Hex.decode((String)"1111111111");
        byte[] signByPcie = GMSSLECSignUtils.sign((PrivateKey)GMSSLECKeyUtils.genSdfPrivateKey((int)index, (String)"xdja1234"), (byte[])data, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] signByBC = GMSSLECSignUtils.sign((PrivateKey)signKeyPair.getPrivate(), (byte[])data, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        GMSSLPkiCryptoInit.getPcieInstance();
        PublicKey signPublick = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)GMSSLECKeyUtils.SM2p256, (boolean)false);
        boolean b = GMSSLECSignUtils.verify((PublicKey)signPublick, (byte[])data, (byte[])signByPcie, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        boolean b1 = GMSSLECSignUtils.verify((PublicKey)signPublick, (byte[])data, (byte[])signByBC, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        GMSSLPkiCryptoInit.getBCInstance();
        boolean b2 = GMSSLECSignUtils.verify((PublicKey)signKeyPair.getPublic(), (byte[])data, (byte[])signByPcie, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        boolean b3 = GMSSLECSignUtils.verify((PublicKey)signKeyPair.getPublic(), (byte[])data, (byte[])signByBC, null, (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        if (b && b1 && b3 && b2) {
            System.out.println("######################################");
            System.out.println("##########SM2\u5185\u90e8\u79c1\u94a5\u7b7e\u540d\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2\u5185\u90e8\u79c1\u94a5\u7b7e\u540d\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm2EncryptWith1Index(int index) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] data = Hex.decode((String)"1111111111");
        PublicKey encPublick = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
        byte[] encryptByPcie = GMSSLSM2EncryptUtils.encrypt((PublicKey)encPublick, (byte[])data);
        System.out.println("######################################");
        System.out.println("##########PCIE\u5361\u52a0\u5bc6\u6570\u636e\u540e\u4e3a encryptByPcie#######");
        System.out.println(Hex.toHexString((byte[])encryptByPcie));
        System.out.println("######################################");
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encryptByBC = GMSSLSM2EncryptUtils.encrypt((PublicKey)encPublick, (byte[])data);
        System.out.println("######################################");
        System.out.println("##########BC\u52a0\u5bc6\u6570\u636e\u540e\u4e3a#######");
        System.out.println(Hex.toHexString((byte[])encryptByBC));
        System.out.println("######################################");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decrypt = GMSSLSM2EncryptUtils.decrypt((PrivateKey)GMSSLECKeyUtils.genSdfPrivateKey((int)index, (String)"xdja1234"), (byte[])encryptByPcie);
        byte[] decrypt1 = GMSSLSM2EncryptUtils.decrypt((PrivateKey)GMSSLECKeyUtils.genSdfPrivateKey((int)index, (String)"xdja1234"), (byte[])encryptByBC);
        if (!GMSSLByteArrayUtils.isEqual((byte[])decrypt, (byte[])data)) {
            System.out.println("PCIE\u5361\u89e3\u5bc6\u81ea\u8eab\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (!GMSSLByteArrayUtils.isEqual((byte[])decrypt1, (byte[])data)) {
            System.out.println("PCIE\u5361\u89e3\u5bc6BC\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (GMSSLByteArrayUtils.isEqual((byte[])decrypt, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decrypt1, (byte[])data)) {
            System.out.println("######################################");
            System.out.println("##########SM2\u5185\u90e8\u79c1\u94a5\u89e3\u5bc6\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2\u5185\u90e8\u79c1\u94a5\u89e3\u5bc6\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm2Encrypt(int index, KeyPair encKeyPair) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] data = Hex.decode((String)"1111111111");
        PublicKey encPublick = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)GMSSLECKeyUtils.SM2p256, (boolean)true);
        byte[] encryptByPcie = GMSSLSM2EncryptUtils.encrypt((PublicKey)encPublick, (byte[])data);
        System.out.println("^^^^^^^^^^^^^^^^^AAAAPCIE" + encPublick);
        System.out.println("^^^^^^^^^^^^^^^^^BBBBC" + encKeyPair.getPublic());
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encryptByBC = GMSSLSM2EncryptUtils.encryptByBC((PublicKey)encKeyPair.getPublic(), (byte[])data);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decrypt = GMSSLSM2EncryptUtils.decrypt((PrivateKey)GMSSLECKeyUtils.genSdfPrivateKey((int)index, (String)"xdja1234"), (byte[])encryptByPcie);
        byte[] decrypt1 = GMSSLSM2EncryptUtils.decrypt((PrivateKey)GMSSLECKeyUtils.genSdfPrivateKey((int)index, (String)"xdja1234"), (byte[])encryptByBC);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decrypt2 = GMSSLSM2EncryptUtils.decrypt((PrivateKey)encKeyPair.getPrivate(), (byte[])encryptByBC);
        byte[] decrypt3 = GMSSLSM2EncryptUtils.decrypt((PrivateKey)encKeyPair.getPrivate(), (byte[])encryptByPcie);
        if (!GMSSLByteArrayUtils.isEqual((byte[])decrypt, (byte[])data)) {
            System.out.println("PCIE\u5361\u89e3\u5bc6\u81ea\u8eab\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (!GMSSLByteArrayUtils.isEqual((byte[])decrypt1, (byte[])data)) {
            System.out.println("PCIE\u5361\u89e3\u5bc6BC\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (!GMSSLByteArrayUtils.isEqual((byte[])decrypt2, (byte[])data)) {
            System.out.println("BC\u89e3\u5bc6\u81ea\u8eab\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (!GMSSLByteArrayUtils.isEqual((byte[])decrypt3, (byte[])data)) {
            System.out.println("BC\u89e3\u5bc6PCIE\u5361\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (GMSSLByteArrayUtils.isEqual((byte[])decrypt, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decrypt1, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decrypt2, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decrypt3, (byte[])data)) {
            System.out.println("######################################");
            System.out.println("##########SM2\u5185\u90e8\u79c1\u94a5\u89e3\u5bc6\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2\u5185\u90e8\u79c1\u94a5\u89e3\u5bc6\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm1ECb() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] encryptByPcie = GMSSLSM1ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decryptData1 = GMSSLSM1ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByPcie, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        if (GMSSLByteArrayUtils.isEqual((byte[])decryptData1, (byte[])data)) {
            System.out.println("######################################");
            System.out.println("##########SM1ECB\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM1ECB\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm1ECbPKCS7() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] encryptByPcie = GMSSLSM1ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] encryptByYunHsm = GMSSLSM1ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decryptData = GMSSLSM1ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByYunHsm, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decryptData1 = GMSSLSM1ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByPcie, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decryptData2 = GMSSLSM1ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByPcie, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decryptData3 = GMSSLSM1ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByYunHsm, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        if (GMSSLByteArrayUtils.isEqual((byte[])decryptData, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decryptData1, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decryptData2, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decryptData3, (byte[])data)) {
            System.out.println("######################################");
            System.out.println("##########SM1ECBPKCS7\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM1ECBPKCS7\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm4ECb() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] encryptByPcie = GMSSLSM4ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encryptByYunHsm = GMSSLSM4ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decryptData = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByYunHsm, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        byte[] decryptData1 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByPcie, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decryptData2 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByPcie, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        byte[] decryptData3 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByYunHsm, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.NoPadding);
        if (GMSSLByteArrayUtils.isEqual((byte[])decryptData, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decryptData1, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decryptData2, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decryptData3, (byte[])data)) {
            System.out.println("######################################");
            System.out.println("##########SM4ECB\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM4ECB\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm4ECbPKCS7() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] encryptByPcie = GMSSLSM4ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encryptByYunHsm = GMSSLSM4ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decryptData = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByYunHsm, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decryptData1 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByPcie, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decryptData2 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByPcie, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decryptData3 = GMSSLSM4ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByYunHsm, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        if (GMSSLByteArrayUtils.isEqual((byte[])decryptData, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decryptData1, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decryptData2, (byte[])data) && GMSSLByteArrayUtils.isEqual((byte[])decryptData3, (byte[])data)) {
            System.out.println("######################################");
            System.out.println("##########SM4ECBPKCS7\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM4ECBPKCS7\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm3Hash() throws Exception {
        byte[] data = "test".getBytes();
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] pcie = GMSSLSM3DigestUtils.digest((byte[])data);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] bc = GMSSLSM3DigestUtils.digest((byte[])data);
        if (GMSSLByteArrayUtils.isEqual((byte[])bc, (byte[])pcie)) {
            System.out.println("######################################");
            System.out.println("##########SM3 Hash\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM3 Hash\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }
}

