package com.xdja.pki.gmssl.main.sdf.pcie.demo;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.*;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import org.bouncycastle.util.encoders.Hex;
import java.security.KeyPair;
import java.security.PublicKey;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2020/6/12 9:16
 **/
public class PCIELastTest {

    public static void main(String[] args) throws Exception {
        int index = Integer.valueOf(args[0]);
        KeyPair signKeyPair = generateSM2KeyPairByPCIE();
        KeyPair encKeyPair = generateSM2KeyPairByPCIE();
        importSM2KeyPair(index, signKeyPair, encKeyPair);
        sm2EncryptWith1Index(4);
        exportSm2Key(index);
        sm2Sign(index, signKeyPair);
        sm2Encrypt(index, encKeyPair);
        sm1ECb();
        sm1ECbPKCS7();
        sm3Hash();
        sm4ECb();
        sm4ECbPKCS7();
    }


    public static KeyPair generateSM2KeyPairByPCIE() throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair(GMSSLECKeyUtils.SM2p256);
        System.out.println(keyPair.getPublic());
        System.out.println(keyPair.getPrivate());
        System.out.println("#################################");
        System.out.println("##########生成公私钥需求完成#######");
        System.out.println("#################################");
        return new KeyPair(keyPair.getPublic(), keyPair.getPrivate());
    }

    public static void importSM2KeyPair(int index, KeyPair signKeyPair, KeyPair encKeyPair) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        GMSSLECKeyUtils.writeKeyPairToHardWare(index, "xdja1234", encKeyPair, true);
        GMSSLECKeyUtils.writeKeyPairToHardWare(index, "xdja1234", signKeyPair, false);
        System.out.println(signKeyPair.getPublic());
        System.out.println(signKeyPair.getPrivate());
        System.out.println(encKeyPair.getPublic());
        System.out.println(encKeyPair.getPrivate());
        System.out.println("#################################");
        System.out.println("##########导入公私钥需求完成#######");
        System.out.println("#################################");
    }

    public static void exportSm2Key(int index) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        PublicKey signPublicKey = GMSSLECKeyUtils.getPublicKeyFromHardware(index, GMSSLECKeyUtils.SM2p256, true);
        PublicKey encPublicKey = GMSSLECKeyUtils.getPublicKeyFromHardware(index, GMSSLECKeyUtils.SM2p256, false);
        System.out.println(signPublicKey);
        System.out.println(encPublicKey);
        System.out.println("#################################");
        System.out.println("##########导出公私钥需求完成#######");
        System.out.println("#################################");
    }

    public static void sm2Sign(int index, KeyPair signKeyPair) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] data = Hex.decode("1111111111");
        byte[] signByPcie = GMSSLECSignUtils.sign(GMSSLECKeyUtils.genSdfPrivateKey(index, "xdja1234"), data, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] signByBC = GMSSLECSignUtils.sign(signKeyPair.getPrivate(), data, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());

        GMSSLPkiCryptoInit.getPcieInstance();
        PublicKey signPublick = GMSSLECKeyUtils.getPublicKeyFromHardware(index, GMSSLECKeyUtils.SM2p256, false);
        boolean b = GMSSLECSignUtils.verify(signPublick, data, signByPcie, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        boolean b1 = GMSSLECSignUtils.verify(signPublick, data, signByBC, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        GMSSLPkiCryptoInit.getBCInstance();
        boolean b2 = GMSSLECSignUtils.verify(signKeyPair.getPublic(), data, signByPcie, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        boolean b3 = GMSSLECSignUtils.verify(signKeyPair.getPublic(), data, signByBC, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
        if (b && b1 && b3 && b2) {
            System.out.println("######################################");
            System.out.println("##########SM2内部私钥签名需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2内部私钥签名需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm2EncryptWith1Index(int index) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] data = Hex.decode("1111111111");
        PublicKey encPublick = GMSSLECKeyUtils.getPublicKeyFromHardware(index, GMSSLECKeyUtils.SM2p256, true);
        byte[] encryptByPcie = GMSSLSM2EncryptUtils.encrypt(encPublick, data);
        System.out.println("######################################");
        System.out.println("##########PCIE卡加密数据后为 encryptByPcie#######");
        System.out.println(Hex.toHexString(encryptByPcie));
        System.out.println("######################################");
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encryptByBC = GMSSLSM2EncryptUtils.encrypt(encPublick, data);
        System.out.println("######################################");
        System.out.println("##########BC加密数据后为#######");
        System.out.println(Hex.toHexString(encryptByBC));
        System.out.println("######################################");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decrypt = GMSSLSM2EncryptUtils.decrypt(GMSSLECKeyUtils.genSdfPrivateKey(index, "xdja1234"), encryptByPcie);
        byte[] decrypt1 = GMSSLSM2EncryptUtils.decrypt(GMSSLECKeyUtils.genSdfPrivateKey(index, "xdja1234"), encryptByBC);
        if (!GMSSLByteArrayUtils.isEqual(decrypt, data)) {
            System.out.println("PCIE卡解密自身加密数据失败");
        }
        if (!GMSSLByteArrayUtils.isEqual(decrypt1, data)) {
            System.out.println("PCIE卡解密BC加密数据失败");
        }
        if (GMSSLByteArrayUtils.isEqual(decrypt, data) &&
                GMSSLByteArrayUtils.isEqual(decrypt1, data)
        ) {
            System.out.println("######################################");
            System.out.println("##########SM2内部私钥解密需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2内部私钥解密需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }


    public static void sm2Encrypt(int index, KeyPair encKeyPair) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] data = Hex.decode("1111111111");
        PublicKey encPublick = GMSSLECKeyUtils.getPublicKeyFromHardware(index, GMSSLECKeyUtils.SM2p256, true);
        byte[] encryptByPcie = GMSSLSM2EncryptUtils.encrypt(encPublick, data);
        System.out.println("^^^^^^^^^^^^^^^^^AAAAPCIE" + encPublick);
        System.out.println("^^^^^^^^^^^^^^^^^BBBBC" + encKeyPair.getPublic());
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encryptByBC = GMSSLSM2EncryptUtils.encryptByBC(encKeyPair.getPublic(), data);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decrypt = GMSSLSM2EncryptUtils.decrypt(GMSSLECKeyUtils.genSdfPrivateKey(index, "xdja1234"), encryptByPcie);
        byte[] decrypt1 = GMSSLSM2EncryptUtils.decrypt(GMSSLECKeyUtils.genSdfPrivateKey(index, "xdja1234"), encryptByBC);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decrypt2 = GMSSLSM2EncryptUtils.decrypt(encKeyPair.getPrivate(), encryptByBC);
        byte[] decrypt3 = GMSSLSM2EncryptUtils.decrypt(encKeyPair.getPrivate(), encryptByPcie);
        if (!GMSSLByteArrayUtils.isEqual(decrypt, data)) {
            System.out.println("PCIE卡解密自身加密数据失败");
        }
        if (!GMSSLByteArrayUtils.isEqual(decrypt1, data)) {
            System.out.println("PCIE卡解密BC加密数据失败");
        }
        if (!GMSSLByteArrayUtils.isEqual(decrypt2, data)) {
            System.out.println("BC解密自身加密数据失败");
        }
        if (!GMSSLByteArrayUtils.isEqual(decrypt3, data)) {
            System.out.println("BC解密PCIE卡加密数据失败");
        }
        if (GMSSLByteArrayUtils.isEqual(decrypt, data) &&
                GMSSLByteArrayUtils.isEqual(decrypt1, data) &&
                GMSSLByteArrayUtils.isEqual(decrypt2, data) &&
                GMSSLByteArrayUtils.isEqual(decrypt3, data)) {
            System.out.println("######################################");
            System.out.println("##########SM2内部私钥解密需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2内部私钥解密需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm1ECb() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] encryptByPcie = GMSSLSM1ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.NoPadding);
//        GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
//        byte[] encryptByYunHsm = GMSSLSM1ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        GMSSLPkiCryptoInit.getPcieInstance();
      //  byte[] decryptData = GMSSLSM1ECBEncryptUtils.decrypt(key, encryptByYunHsm, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        byte[] decryptData1 = GMSSLSM1ECBEncryptUtils.decrypt(key, encryptByPcie, SdfSymmetricKeyParameters.PaddingType.NoPadding);
//        GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
//        byte[] decryptData2 = GMSSLSM1ECBEncryptUtils.decrypt(key, encryptByPcie, SdfSymmetricKeyParameters.PaddingType.NoPadding);
//        byte[] decryptData3 = GMSSLSM1ECBEncryptUtils.decrypt(key, encryptByYunHsm, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        if (
                GMSSLByteArrayUtils.isEqual(decryptData1, data) ){
//                GMSSLByteArrayUtils.isEqual(decryptData2, data) &&
//                GMSSLByteArrayUtils.isEqual(decryptData3, data)) {{
            System.out.println("######################################");
            System.out.println("##########SM1ECB需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM1ECB需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm1ECbPKCS7() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] encryptByPcie = GMSSLSM1ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
//        GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
        byte[] encryptByYunHsm = GMSSLSM1ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decryptData = GMSSLSM1ECBEncryptUtils.decrypt(key, encryptByYunHsm, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decryptData1 = GMSSLSM1ECBEncryptUtils.decrypt(key, encryptByPcie, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
//        GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
        byte[] decryptData2 = GMSSLSM1ECBEncryptUtils.decrypt(key, encryptByPcie, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decryptData3 = GMSSLSM1ECBEncryptUtils.decrypt(key, encryptByYunHsm, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        if (GMSSLByteArrayUtils.isEqual(decryptData, data) &&
                GMSSLByteArrayUtils.isEqual(decryptData1, data) &&
                GMSSLByteArrayUtils.isEqual(decryptData2, data) &&
                GMSSLByteArrayUtils.isEqual(decryptData3, data)) {
            System.out.println("######################################");
            System.out.println("##########SM1ECBPKCS7需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM1ECBPKCS7需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }


    public static void sm4ECb() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] encryptByPcie = GMSSLSM4ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encryptByYunHsm = GMSSLSM4ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decryptData = GMSSLSM4ECBEncryptUtils.decrypt(key, encryptByYunHsm, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        byte[] decryptData1 = GMSSLSM4ECBEncryptUtils.decrypt(key, encryptByPcie, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decryptData2 = GMSSLSM4ECBEncryptUtils.decrypt(key, encryptByPcie, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        byte[] decryptData3 = GMSSLSM4ECBEncryptUtils.decrypt(key, encryptByYunHsm, SdfSymmetricKeyParameters.PaddingType.NoPadding);
        if (GMSSLByteArrayUtils.isEqual(decryptData, data) &&
                GMSSLByteArrayUtils.isEqual(decryptData1, data) &&
                GMSSLByteArrayUtils.isEqual(decryptData2, data) &&
                GMSSLByteArrayUtils.isEqual(decryptData3, data)) {
            System.out.println("######################################");
            System.out.println("##########SM4ECB需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM4ECB需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm4ECbPKCS7() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] encryptByPcie = GMSSLSM4ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] encryptByYunHsm = GMSSLSM4ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decryptData = GMSSLSM4ECBEncryptUtils.decrypt(key, encryptByYunHsm, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decryptData1 = GMSSLSM4ECBEncryptUtils.decrypt(key, encryptByPcie, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decryptData2 = GMSSLSM4ECBEncryptUtils.decrypt(key, encryptByPcie, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        byte[] decryptData3 = GMSSLSM4ECBEncryptUtils.decrypt(key, encryptByYunHsm, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        if (GMSSLByteArrayUtils.isEqual(decryptData, data) &&
                GMSSLByteArrayUtils.isEqual(decryptData1, data) &&
                GMSSLByteArrayUtils.isEqual(decryptData2, data) &&
                GMSSLByteArrayUtils.isEqual(decryptData3, data)) {
            System.out.println("######################################");
            System.out.println("##########SM4ECBPKCS7需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM4ECBPKCS7需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm3Hash() throws Exception {
        byte[] data = "test".getBytes();
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] pcie = GMSSLSM3DigestUtils.digest(data);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] bc = GMSSLSM3DigestUtils.digest(data);
//        GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
//        byte[] yunhsm = GMSSLSM3DigestUtils.digest(data);
        if (GMSSLByteArrayUtils.isEqual(bc, pcie) ) {
            System.out.println("######################################");
            System.out.println("##########SM3 Hash需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM3 Hash需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }
}
