package com.xdja.pki.gmssl.main.sdf.pcie.demo;


import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.*;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.util.encoders.Hex;


import java.math.BigInteger;
import java.security.*;
import java.security.cert.X509Certificate;
import java.util.*;
import java.util.concurrent.atomic.AtomicLong;


/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2021/6/6 19:25
 **/
public class PCIERSATest {
    public static void main(String[] args) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        int index = Integer.parseInt(args[0]);
        KeyPair keyPair = generateRSA2048KeyPairByPCIE();

        //导入公钥

        importRSAKeyPair(index, keyPair);

        //导出公钥
        exportRSAKeyFormPcieCard(keyPair.getPublic(), index, false);
        exportRSAKeyFormPcieCard(keyPair.getPublic(), index, true);

        GMSSLSignatureAlgorithm algorithm = GMSSLSignatureAlgorithm.SHA256_WITH_RSA;
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] data = Hex.decode("12345678900123456789");
        byte[] signByPcie = GMSSLRSASignUtils.sign(GMSSLECKeyUtils.genSdfPrivateKey(index, "xdja1234"), data, algorithm.getSigAlgName());
        PublicKey signPublick = GMSSLRSAKeyUtils.getPublicKeyFromHardware(index, false);
        boolean b = GMSSLRSASignUtils.verify(signPublick, data, signByPcie, algorithm.getSigAlgName());
        System.out.println(b);


        //摘要算法
        sha1Hash();
        sha256Hash();
        //RSA 签名
        rsaSignWithAlg(index, keyPair, GMSSLSignatureAlgorithm.SHA256_WITH_RSA);
        rsaSignWithAlg(index, keyPair, GMSSLSignatureAlgorithm.SHA1_WITH_RSA);
        //AES128
        aes128(SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        aes128(SdfSymmetricKeyParameters.PaddingType.NoPadding);
        //RSA生成证书
        testGenCert(index, GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName());
        testGenCert(index, GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName());
    }


    private static void exportRSAKeyFormPcieCard(PublicKey publicKey, int index, boolean isEncrypt) throws Exception {
        String s = isEncrypt ? "签名公钥" : "加密公钥";
        PublicKey signKey = GMSSLRSAKeyUtils.getPublicKeyFromHardware(index, isEncrypt);
        System.out.println("###############导出的" + s + "为################");
        System.out.println(signKey);
        System.out.println("###############导入的" + s + "为################");
        System.out.println(publicKey);
        System.out.println("###############################");
        boolean equals = Arrays.equals(publicKey.getEncoded(), signKey.getEncoded());
        if (!equals) {
            System.out.println("导入的密钥和导出的不一致,导入的密钥索引为 " + index + " 为" + s);
            return;
        }
    }

    private static void importRSAKeyPair(int index, KeyPair keyPair) throws Exception {
        boolean sign = GMSSLRSAKeyUtils.writeKeyPairToHardWare(index, "xdja1234", keyPair);
        System.out.println(sign);

    }

    private static KeyPair generateRSA2048KeyPairByPCIE() throws Exception {
        return GMSSLRSAKeyUtils.generateRSAKeyPair(2048);
    }


    public static void sha256Hash() throws Exception {
        String data = "test";
        String pcie = Hex.toHexString(GMSSLSHA256DigestUtils.digest(data.getBytes()));
        String bc = Hex.toHexString(GMSSLSHA256DigestUtils.digestByBC(data.getBytes()));
        if (pcie.equalsIgnoreCase(bc)) {
            System.out.println("######################################");
            System.out.println("##########sha256 Hash需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!sha256 Hash需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }


    public static void sha1Hash() throws Exception {
        String data = "test";
        String pcie = Hex.toHexString(GMSSLSHA1DigestUtils.digest(data.getBytes()));
        String bc = Hex.toHexString(GMSSLSHA1DigestUtils.digestByBC(data.getBytes()));
        if (pcie.equalsIgnoreCase(bc)) {
            System.out.println("######################################");
            System.out.println("##########sha1 Hash需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!sha1 Hash需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }


    public static void rsaSignWithAlg(int index, KeyPair signKeyPair, GMSSLSignatureAlgorithm algorithm) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] data = Hex.decode("12345678900123456789");
        byte[] signByPcie = GMSSLRSASignUtils.sign(GMSSLECKeyUtils.genSdfPrivateKey(index, "xdja1234"), data, algorithm.getSigAlgName());
        GMSSLPkiCryptoInit.getBCInstance();
//        KeyPair keyPair = GMSSLRSAKeyUtils.generateKeyPairByBC(2048);
        byte[] signByBC = GMSSLRSASignUtils.sign(signKeyPair.getPrivate(), data, algorithm.getSigAlgName());
        GMSSLPkiCryptoInit.getPcieInstance();
        PublicKey signPublick = GMSSLRSAKeyUtils.getPublicKeyFromHardware(index, false);
        boolean b = GMSSLRSASignUtils.verify(signPublick, data, signByPcie, algorithm.getSigAlgName());
        boolean b1 = GMSSLRSASignUtils.verify(signPublick, data, signByBC, algorithm.getSigAlgName());
        GMSSLPkiCryptoInit.getBCInstance();
        boolean b2 = GMSSLRSASignUtils.verify(signKeyPair.getPublic(), data, signByPcie, algorithm.getSigAlgName());
        boolean b3 = GMSSLRSASignUtils.verify(signKeyPair.getPublic(), data, signByBC, algorithm.getSigAlgName());
        GMSSLPkiCryptoInit.getPcieInstance();
        if (b && b1 && b3 && b2) {
            System.out.println("######################################");
            System.out.println("##########RSA内部私钥签名需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("b" + b);
            System.out.println("b1" + b1);
            System.out.println("b2" + b2);
            System.out.println("b3" + b3);
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!RSA内部私钥签名需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
    }


    public static void aes128(SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] encryptByPcie = GMSSLAES128ECBEncryptUtils.encrypt(key, data, paddingType);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decryptData1 = GMSSLAES128ECBEncryptUtils.decrypt(key, encryptByPcie, paddingType);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decryptData2;
        if (paddingType == SdfSymmetricKeyParameters.PaddingType.SSL3Padding) {
            decryptData2 = decryptData1;
        } else {
            decryptData2 = GMSSLAES128ECBEncryptUtils.decrypt(key, encryptByPcie, paddingType);
        }
        GMSSLPkiCryptoInit.getPcieInstance();
        if (GMSSLByteArrayUtils.isEqual(decryptData1, data) &&
                GMSSLByteArrayUtils.isEqual(decryptData2, data)) {
//                GMSSLByteArrayUtils.isEqual(decryptData3, data)) {{
            System.out.println("######################################");
            System.out.println("##########AES需求完成#######" + paddingType);
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!AES需求失败!!!!!!!" + paddingType);
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
    }


    public static void testGenCert(int index, String algName) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        String rDN = "cn=root,o=xdja,c=cn";
        PublicKey publickey = GMSSLRSAKeyUtils.getPublicKeyFromHardware(index, false);
        List<Extension> rExtensions = new ArrayList<>();
        rExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        rExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension(publickey));
        rExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(null));
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, "xdja1234");
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        //生成 CA密钥、CA根证书
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(Calendar.DATE, -1);
        Date noBefore = calendar.getTime();
        calendar.add(Calendar.YEAR, 1);
        Date noAfter = calendar.getTime();
        X509Certificate rCert = GMSSLCertUtils.generateCert(
                rDN, rDN,
                BigInteger.valueOf(serialNumber.getAndIncrement()),
                noBefore, noAfter,
                sdfPrivateKey,
                publickey,
                GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(),
                rExtensions, false
        );
        System.out.println(rCert);
        boolean b1 = GMSSLCertUtils.verifyCert(publickey, rCert);
        System.out.println(b1);
        GMSSLPkiCryptoInit.getBCInstance();
        boolean b2 = GMSSLCertUtils.verifyCert(publickey, rCert);
        System.out.println(b2);
    }
}
