/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.sdf.pcie.demo;

import com.xdja.pcie.base.RSAPrivateKey;
import com.xdja.pcie.base.RSAPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDKUtils;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnection;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnectionProviderImpl;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class PCIERsaSdfTest {
    private static String SHA1 = "0001ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff00";
    private static String SHA256 = "0001ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff00";

    public static void main(String[] args) throws Exception {
        KeyPair signKeyPair;
        System.out.println("0001ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff00302d300906052b0e03021a050004202661920f2409dd6c8adeb0c44972959f232b6429afa913845d0fd95e7e768234".length());
        Security.addProvider((Provider)new BouncyCastleProvider());
        PcieConnectionProviderImpl.getInstance();
        PcieConnection connection = PcieConnectionProviderImpl.getInstance().getConnection();
        RSAPublicKey signRsaPublicKey = new RSAPublicKey();
        RSAPrivateKey signRsaPrivateKey = new RSAPrivateKey();
        RSAPublicKey encRsaPublicKey = new RSAPublicKey();
        RSAPrivateKey encRsaPrivateKey = new RSAPrivateKey();
        KeyPair encKeyPair = signKeyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)2048);
        signRsaPrivateKey = RSAPrivateKey.getInstance((BCRSAPrivateCrtKey)((BCRSAPrivateCrtKey)signKeyPair.getPrivate()));
        signRsaPublicKey = RSAPublicKey.getInstance((BCRSAPrivateCrtKey)((BCRSAPrivateCrtKey)encKeyPair.getPrivate()));
        encRsaPublicKey = RSAPublicKey.getInstance((BCRSAPrivateCrtKey)((BCRSAPrivateCrtKey)encKeyPair.getPrivate()));
        encRsaPrivateKey = RSAPrivateKey.getInstance((BCRSAPrivateCrtKey)((BCRSAPrivateCrtKey)encKeyPair.getPrivate()));
        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], Integer.valueOf(args[0]).intValue(), "xdja1234".getBytes(), 8);
        PcieSdfSDKUtils.checkRet((String)"getPrivateKeyAccessRight  ", (int)ret, (long)0L, (long)0L);
        ret = connection.getSdfApi().RSAImportSignpri(connection.getSes()[0], Integer.valueOf(args[0]).intValue(), signRsaPrivateKey, 0);
        PcieSdfSDKUtils.checkRet((String)"RSAImportSignpri  ", (int)ret, (long)0L, (long)0L);
        ret = connection.getSdfApi().RSAImportSignpub(connection.getSes()[0], Integer.valueOf(args[0]).intValue(), signRsaPublicKey);
        PcieSdfSDKUtils.checkRet((String)"RSAImportSignpub  ", (int)ret, (long)0L, (long)0L);
        ret = connection.getSdfApi().RSAImportEncpri(connection.getSes()[0], Integer.valueOf(args[0]).intValue(), encRsaPrivateKey, 0);
        PcieSdfSDKUtils.checkRet((String)"RSAImportEncpri  ", (int)ret, (long)0L, (long)0L);
        ret = connection.getSdfApi().RSAImportEncpub(connection.getSes()[0], Integer.valueOf(args[0]).intValue(), encRsaPublicKey);
        PcieSdfSDKUtils.checkRet((String)"RSAImportEncpub  ", (int)ret, (long)0L, (long)0L);
        RSAPublicKey encKey = new RSAPublicKey();
        ret = connection.getSdfApi().exportEncPublicKeyRSA(connection.getSes()[0], Integer.valueOf(args[0]).intValue(), encKey);
        PcieSdfSDKUtils.checkRet((String)"exportEncPublicKeyRSA  ", (int)ret, (long)0L, (long)0L);
        System.out.println(encKey);
        RSAPublicKey signKey = new RSAPublicKey();
        ret = connection.getSdfApi().exportSignPublicKeyRSA(connection.getSes()[0], Integer.valueOf(args[0]).intValue(), signKey);
        PcieSdfSDKUtils.checkRet((String)"exportSignPublicKeyRSA  ", (int)ret, (long)0L, (long)0L);
        System.out.println(signKey);
        byte[] data = new byte[256];
        for (int i = 0; i < 256; ++i) {
            data[i] = 1;
        }
        byte[] pucDataOutPut = new byte[256];
        int[] puiDataOutPutLength = new int[2];
        byte[] hash = GMSSLSHA1DigestUtils.digestByBC((byte[])data);
        System.out.println("Hash  " + Hex.toHexString((byte[])hash));
        byte[] hashEncode = PCIERsaSdfTest.derEncode(hash, new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, (ASN1Encodable)DERNull.INSTANCE));
        System.out.println("Hash  encode " + Hex.toHexString((byte[])hashEncode));
        byte[] hashEncodeData = GMSSLByteArrayUtils.mergeByteArray((byte[])Hex.decode((String)SHA1), (byte[])hashEncode);
        System.out.println("hashEncodeData  encode " + Hex.toHexString((byte[])hashEncodeData));
        ret = connection.getSdfApi().internalPrivateKeyOperationRSA(connection.getSes()[0], Integer.valueOf(args[0]).intValue(), hashEncodeData, hashEncodeData.length, pucDataOutPut, puiDataOutPutLength);
        PcieSdfSDKUtils.checkRet((String)"internalPrivateKeyOperationRSA error ", (int)ret, (long)0L, (long)0L);
        System.out.println("success");
        System.out.println("##################################");
        System.out.println("PCIE\u7b7e\u540d\u6570\u636e " + Hex.toHexString((byte[])pucDataOutPut));
        byte[] verifyOut = new byte[256];
        ret = connection.getSdfApi().externalPublicKeyOperationRSA(connection.getSes()[0], signRsaPublicKey, pucDataOutPut, pucDataOutPut.length, verifyOut, puiDataOutPutLength);
        PcieSdfSDKUtils.checkRet((String)"externalPublicKeyOperationRSA error ", (int)ret, (long)0L, (long)0L);
        System.out.println("externalPublicKeyOperationRSA  out " + Hex.toHexString((byte[])verifyOut));
        System.out.println(signKeyPair.getPrivate());
        System.out.println(signKeyPair.getPublic());
        try {
            byte[] bytes = GMSSLRSASignUtils.signByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PrivateKey)signKeyPair.getPrivate(), (byte[])data);
            System.out.println(Hex.toHexString((byte[])bytes));
            ret = connection.getSdfApi().externalPublicKeyOperationRSA(connection.getSes()[0], signRsaPublicKey, bytes, pucDataOutPut.length, verifyOut, puiDataOutPutLength);
            PcieSdfSDKUtils.checkRet((String)"externalPublicKeyOperationRSA bc ", (int)ret, (long)0L, (long)0L);
            System.out.println("externalPublicKeyOperationRSA bc  out " + Hex.toHexString((byte[])verifyOut));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean b = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)signKeyPair.getPublic(), (byte[])data, (byte[])pucDataOutPut);
        System.out.println(b);
    }

    private static byte[] derEncode(byte[] hash, AlgorithmIdentifier algId) throws IOException {
        DigestInfo dInfo = new DigestInfo(algId, hash);
        return dInfo.getEncoded("DER");
    }
}

