package com.xdja.pki.gmssl.main.sdf.pcie.demo;


import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.test.TestConstants;
import org.bouncycastle.crypto.CryptoException;

import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;


public class Main {
    public static void main(String[] args) throws Exception {


        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method, Example: all. decrypt. decryptasn1");
            return;
        }

        System.out.println("You want to test: " + args[0]);

        switch (args[0]) {
            case "all":
                System.out.println("*************** decrypt ***************");
                decrypt();
                System.out.println("*************** decryptasn1 ***************");
                decryptasn1();
                break;
            case "decrypt":
                //测试生成 随机数
                decrypt();
                break;
            case "decryptasn1":
                decryptasn1();
                break;
            default:
                System.out.println("不支持的命令！");
                break;
        }
    }

    private static void decrypt() throws Exception {
        String plainText = GMSSLByteArrayUtils.base64Encode("test".getBytes());

        PublicKey signPublicKeyByPcie = GMSSLSM2KeyUtils.getEncryptPublicKeyByPcie(2);
        ECPublicKey publicKey = (ECPublicKey) signPublicKeyByPcie;
        //BC加密
        String encryptASN1ByBC = GMSSLSM2EncryptUtils.encryptByBC(publicKey, plainText);

        //sdf解密
        String encryptASN1ByPcie = GMSSLSM2EncryptUtils.encryptByPcie(signPublicKeyByPcie, plainText);
        String decryptASN1ByYunhsum = GMSSLSM2EncryptUtils.decryptByPcie(TestConstants.sm2PrivateKeyIndex, TestConstants.PrivateKeyPassword, encryptASN1ByPcie);

        System.out.println(encryptASN1ByBC);
        System.out.println(encryptASN1ByPcie);
        System.out.println(decryptASN1ByYunhsum);
    }

    private static void decryptasn1() throws Exception {
        String plainText = GMSSLByteArrayUtils.base64Encode("test".getBytes());

        PublicKey signPublicKeyByPcie = GMSSLSM2KeyUtils.getEncryptPublicKeyByPcie(2);

        ECPublicKey publicKey = (ECPublicKey) signPublicKeyByPcie;
        //BC加密
        String encryptASN1ByBC = GMSSLSM2EncryptUtils.encryptASN1ByBC(publicKey, plainText);

        //sdf解密
        String encryptASN1ByPcie = GMSSLSM2EncryptUtils.encryptASN1ByPcie(signPublicKeyByPcie, plainText);
        String decryptASN1ByYunhsum = GMSSLSM2EncryptUtils.decryptASN1ByPcie(2, "xdja1234", encryptASN1ByPcie);

        System.out.println(encryptASN1ByBC);
        System.out.println(encryptASN1ByPcie);
        System.out.println(decryptASN1ByYunhsum);
    }
}