package com.xdja.pki.gmssl.main.sdf.pcie.demo;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4CBCEncryptUtils;

/**
 * @ClassName PCIECbcTest
 * @Description TODO
 * @Date 2020/5/26 15:11
 * @Author FengZhen
 */
public class PCIECbcTest {

    public static void main(String[] args) throws Exception {
        sm4Cbc();
        sm4CbcPKCS7();
    }

    public static void sm4Cbc() throws Exception {
        byte[] iv = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        String plainText = GMSSLByteArrayUtils.base64Encode(data);
        String encryptByYunHsm = GMSSLSM4CBCEncryptUtils.encryptByYumhsmWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), plainText, GMSSLByteArrayUtils.base64Encode(iv));
        String encryptByPcie = GMSSLSM4CBCEncryptUtils.encryptByPcieWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), plainText, GMSSLByteArrayUtils.base64Encode(iv));
        String decryptData = GMSSLSM4CBCEncryptUtils.decryptByPcieWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm, GMSSLByteArrayUtils.base64Encode(iv));
        String decryptData1 = GMSSLSM4CBCEncryptUtils.decryptByPcieWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie, GMSSLByteArrayUtils.base64Encode(iv));
        String decryptData2 = GMSSLSM4CBCEncryptUtils.decryptByYumhsmWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie, GMSSLByteArrayUtils.base64Encode(iv));
        String decryptData3 = GMSSLSM4CBCEncryptUtils.decryptByYumhsmWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm, GMSSLByteArrayUtils.base64Encode(iv));
        if (decryptData.equalsIgnoreCase(plainText) &&
                decryptData1.equalsIgnoreCase(plainText) &&
                decryptData2.equalsIgnoreCase(plainText) &&
                decryptData3.equalsIgnoreCase(plainText)) {
            System.out.println("######################################");
            System.out.println("##########SM4ECB需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM4ECB需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm4CbcPKCS7() throws Exception {
        byte[] iv = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa0123456789abcdeffedcba9876543210aaaaaaaaaa");
        String plainText = GMSSLByteArrayUtils.base64Encode(data);
        String encryptByYunHsm = GMSSLSM4CBCEncryptUtils.encryptByYumhsmWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), plainText, GMSSLByteArrayUtils.base64Encode(iv));
        String encryptByPcie = GMSSLSM4CBCEncryptUtils.encryptByPcieWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), plainText, GMSSLByteArrayUtils.base64Encode(iv));
        String decryptData = GMSSLSM4CBCEncryptUtils.decryptByPcieWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm, GMSSLByteArrayUtils.base64Encode(iv));
        String decryptData1 = GMSSLSM4CBCEncryptUtils.decryptByPcieWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie, GMSSLByteArrayUtils.base64Encode(iv));
        String decryptData2 = GMSSLSM4CBCEncryptUtils.decryptByYumhsmWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie, GMSSLByteArrayUtils.base64Encode(iv));
        String decryptData3 = GMSSLSM4CBCEncryptUtils.decryptByYumhsmWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm, GMSSLByteArrayUtils.base64Encode(iv));
        if (decryptData.equalsIgnoreCase(plainText) &&
                decryptData1.equalsIgnoreCase(plainText) &&
                decryptData2.equalsIgnoreCase(plainText) &&
                decryptData3.equalsIgnoreCase(plainText)) {
            System.out.println("######################################");
            System.out.println("##########SM4ECBPKCS7需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM4ECBPKCS7需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

}
