package com.xdja.pki.gmssl.main.sdf.pcie.demo;

import com.xdja.pcie.base.RSAPrivateKey;
import com.xdja.pcie.base.RSAPublicKey;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDKUtils;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnection;
import com.xdja.pki.gmssl.sdf.pcie.pool.PcieConnectionProviderImpl;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import org.bouncycastle.asn1.ASN1Encoding;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

import java.io.IOException;
import java.security.KeyPair;
import java.security.Security;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2021/6/5 14:02
 **/
public class PCIERsaSdfTest {

    private static String SHA1 = "0001ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff00";
    private static String SHA256 = "0001ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff00";


    public static void main(String[] args) throws Exception {
        System.out.println("0001ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff00302d300906052b0e03021a050004202661920f2409dd6c8adeb0c44972959f232b6429afa913845d0fd95e7e768234".length());
        Security.addProvider(new BouncyCastleProvider());
        PcieConnectionProviderImpl.getInstance();
        PcieConnection connection = PcieConnectionProviderImpl.getInstance().getConnection();
        RSAPublicKey signRsaPublicKey = new RSAPublicKey();
        RSAPrivateKey signRsaPrivateKey = new RSAPrivateKey();

        RSAPublicKey encRsaPublicKey = new RSAPublicKey();
        RSAPrivateKey encRsaPrivateKey = new RSAPrivateKey();


        KeyPair signKeyPair = GMSSLRSAKeyUtils.generateKeyPairByBC(2048);
//        KeyPair encKeyPair = GMSSLRSAKeyUtils.generateKeyPairByBC(2048);
        KeyPair encKeyPair = signKeyPair;

        signRsaPrivateKey = RSAPrivateKey.getInstance((BCRSAPrivateCrtKey) signKeyPair.getPrivate());
        signRsaPublicKey = RSAPublicKey.getInstance((BCRSAPrivateCrtKey) encKeyPair.getPrivate());
        encRsaPublicKey = RSAPublicKey.getInstance((BCRSAPrivateCrtKey) encKeyPair.getPrivate());
        encRsaPrivateKey = RSAPrivateKey.getInstance((BCRSAPrivateCrtKey) encKeyPair.getPrivate());



        int ret = connection.getSdfApi().getPrivateKeyAccessRight(connection.getSes()[0], Integer.valueOf(args[0]), "xdja1234".getBytes(), 8);
        PcieSdfSDKUtils.checkRet("getPrivateKeyAccessRight  ", ret, 0, 0);
        ret = connection.getSdfApi().RSAImportSignpri(connection.getSes()[0], Integer.valueOf(args[0]), signRsaPrivateKey, 0);
        PcieSdfSDKUtils.checkRet("RSAImportSignpri  ", ret, 0, 0);

        ret = connection.getSdfApi().RSAImportSignpub(connection.getSes()[0], Integer.valueOf(args[0]), signRsaPublicKey);
        PcieSdfSDKUtils.checkRet("RSAImportSignpub  ", ret, 0, 0);


        ret = connection.getSdfApi().RSAImportEncpri(connection.getSes()[0], Integer.valueOf(args[0]), encRsaPrivateKey, 0);
        PcieSdfSDKUtils.checkRet("RSAImportEncpri  ", ret, 0, 0);

        ret = connection.getSdfApi().RSAImportEncpub(connection.getSes()[0], Integer.valueOf(args[0]), encRsaPublicKey);
        PcieSdfSDKUtils.checkRet("RSAImportEncpub  ", ret, 0, 0);

        RSAPublicKey encKey = new RSAPublicKey();
        ret = connection.getSdfApi().exportEncPublicKeyRSA(connection.getSes()[0], Integer.valueOf(args[0]), encKey);
        PcieSdfSDKUtils.checkRet("exportEncPublicKeyRSA  ", ret, 0, 0);
        System.out.println(encKey);
        RSAPublicKey signKey = new RSAPublicKey();
        ret = connection.getSdfApi().exportSignPublicKeyRSA(connection.getSes()[0], Integer.valueOf(args[0]), signKey);
        PcieSdfSDKUtils.checkRet("exportSignPublicKeyRSA  ", ret, 0, 0);
        System.out.println(signKey);
        byte[] data = new byte[256];
        for (int i = 0; i < 256; i++) {
            data[i] = (byte) 1;
        }
        byte[] pucDataOutPut = new byte[2048 / 8];
        int[] puiDataOutPutLength = new int[2];


        byte[] hash = GMSSLSHA1DigestUtils.digestByBC(data);
        System.out.println("Hash  " + Hex.toHexString(hash));
        byte[] hashEncode = derEncode(hash, new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, DERNull.INSTANCE));
        System.out.println("Hash  encode " + Hex.toHexString(hashEncode));
        byte[] hashEncodeData = GMSSLByteArrayUtils.mergeByteArray(Hex.decode(SHA1), hashEncode);
        System.out.println("hashEncodeData  encode " + Hex.toHexString(hashEncodeData));
        ret = connection.getSdfApi().internalPrivateKeyOperationRSA(connection.getSes()[0], Integer.valueOf(args[0]), hashEncodeData, hashEncodeData.length,
                pucDataOutPut, puiDataOutPutLength);
        PcieSdfSDKUtils.checkRet("internalPrivateKeyOperationRSA error ", ret, 0, 0);

        System.out.println("success");
        System.out.println("##################################");
        System.out.println("PCIE签名数据 " + Hex.toHexString(pucDataOutPut));
        byte[] verifyOut = new byte[256];
        ret = connection.getSdfApi().externalPublicKeyOperationRSA(connection.getSes()[0], signRsaPublicKey, pucDataOutPut, pucDataOutPut.length, verifyOut, puiDataOutPutLength);
        PcieSdfSDKUtils.checkRet("externalPublicKeyOperationRSA error ", ret, 0, 0);
        System.out.println("externalPublicKeyOperationRSA  out " + Hex.toHexString(verifyOut));
//3031300d0609608648016503040201050004202661920f2409dd6c8adeb0c44972959f232b6429afa913845d0fd95e7e7682340000000000850000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004120636f6e7374616e7420706f6f6c206c6f636b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000045000000000000002e0001004949bb0a6661696c656420746f20636f6e737472756374204f4354455420535452494e472066726f6d20627974655b5d3a2000003500000000000000
        System.out.println(signKeyPair.getPrivate());
        System.out.println(signKeyPair.getPublic());
        try {
            byte[] bytes = GMSSLRSASignUtils.signByBC(GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), signKeyPair.getPrivate(), data);
            System.out.println(Hex.toHexString(bytes));
            ret = connection.getSdfApi().externalPublicKeyOperationRSA(connection.getSes()[0], signRsaPublicKey, bytes, pucDataOutPut.length, verifyOut, puiDataOutPutLength);
            PcieSdfSDKUtils.checkRet("externalPublicKeyOperationRSA bc ", ret, 0, 0);
            System.out.println("externalPublicKeyOperationRSA bc  out " + Hex.toHexString(verifyOut));

        } catch (Exception e) {
            e.printStackTrace();
        }
        boolean b = GMSSLRSASignUtils.verifyByBC(GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), signKeyPair.getPublic(), data, pucDataOutPut);
        System.out.println(b);

    }

    //
    private static byte[] derEncode(byte[] hash, AlgorithmIdentifier algId) throws IOException {
        DigestInfo dInfo = new DigestInfo(algId, hash);
        return dInfo.getEncoded(ASN1Encoding.DER);
    }

}
