package com.xdja.pki.gmssl.main.sdf.pcie.demo;

import com.xdja.hsm.api.alg.AlgId;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.utils.*;
import com.xdja.pki.gmssl.sdf.bean.SdfECCKeyPair;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDK;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

/**
 * @ClassName PCIETest
 * @Description TODO
 * @Date 2020/5/15 13:49
 * @Author FengZhen
 */
public class PCIETest {


    public static void main(String[] args) throws Exception {
        int index = 3;
        KeyPair signKeyPair = generateSM2KeyPairByPCIE();
        KeyPair encKeyPair = generateSM2KeyPairByPCIE();
        importSM2KeyPair(index, signKeyPair, encKeyPair);
        sm2EncryptWith1Index(1);
        exportSm2Key(index);
        sm2Sign(index, signKeyPair);
        sm2Encrypt(index, encKeyPair);
        sm1ECb();
        sm1ECbPKCS7();
        sm3Hash();
        sm4ECb();
        sm4ECbPKCS7();
    }


    public static KeyPair generateSM2KeyPairByPCIE() throws Exception {
        PcieSdfSDK sdfSDK = new PcieSdfSDK();
        sdfSDK.init();
        SdfECCKeyPair sdfECCKeyPair = sdfSDK.generateKeyPairEcc(AlgId.SGD_SM2);
        sdfSDK.release();
        PublicKey publicKey = GMSSLX509Utils.convertSM2PublicKey(sdfECCKeyPair.getSdfECCPublicKey().getX(), sdfECCKeyPair.getSdfECCPublicKey().getY());
        PrivateKey privateKey = GMSSLX509Utils.convertSM2PrivateKey(sdfECCKeyPair.getSdfECCPrivateKey().getK());
        System.out.println(publicKey);
        System.out.println(privateKey);
        System.out.println("#################################");
        System.out.println("##########生成公私钥需求完成#######");
        System.out.println("#################################");
        return new KeyPair(publicKey, privateKey);
    }

    public static void importSM2KeyPair(int index, KeyPair signKeyPair, KeyPair encKeyPair) throws Exception {
        PcieSdfSDK pcieSdfSDK = new PcieSdfSDK();
        pcieSdfSDK.init();
        pcieSdfSDK.importSM2PublicKey(signKeyPair.getPublic(), index, true);
        pcieSdfSDK.importSM2PrivateKey(signKeyPair.getPrivate(), index, "xdja1234".getBytes(), true);
        pcieSdfSDK.importSM2PublicKey(encKeyPair.getPublic(), index, false);
        pcieSdfSDK.importSM2PrivateKey(encKeyPair.getPrivate(), index,  "xdja1234".getBytes(),false);
        pcieSdfSDK.release();
        System.out.println("#################################");
        System.out.println("##########导入公私钥需求完成#######");
        System.out.println("#################################");
    }

    public static void exportSm2Key(int index) throws Exception {
        PublicKey signPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByPcie(index);
        PublicKey encPublicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByYunhsm(index);
        System.out.println(signPublicKey);
        System.out.println(encPublicKey);
        System.out.println("#################################");
        System.out.println("##########导出公私钥需求完成#######");
        System.out.println("#################################");
    }

    public static void sm2Sign(int index, KeyPair signKeyPair) throws Exception {
        String data = Base64.toBase64String(Hex.decode("1111111111"));
        String signData = GMSSLSM2SignUtils.signByPcie(index, "xdja1234", data);
        String signByBC = GMSSLSM2SignUtils.signByBC(signKeyPair.getPrivate(), data);
        PublicKey signPublick = GMSSLSM2KeyUtils.getSignPublicKeyByPcie(index);
        boolean b = GMSSLSM2SignUtils.verifyByPcie(signPublick, data, signData);
        boolean b1 = GMSSLSM2SignUtils.verifyByPcie(signPublick, data, signByBC);
        boolean b2 = GMSSLSM2SignUtils.verifyByBC(signPublick, data, signByBC);
        boolean b3 = GMSSLSM2SignUtils.verifyByBC(signPublick, data, signData);
        if (b && b1 && b3 && b2) {
            System.out.println("######################################");
            System.out.println("##########SM2内部私钥签名需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2内部私钥签名需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm2EncryptWith1Index(int index) throws Exception {
        String data = Base64.toBase64String(Hex.decode("1111111111"));
        PublicKey encPublick = GMSSLSM2KeyUtils.getEncryptPublicKeyByPcie(index);
        String encryptByPcie = GMSSLSM2EncryptUtils.encryptByPcie(encPublick, data);
        System.out.println("######################################");
        System.out.println("##########PCIE卡加密数据后为 encryptByPcie#######");
        System.out.println(encryptByPcie);
        System.out.println("######################################");
        String encryptByBC = GMSSLSM2EncryptUtils.encryptByBC(encPublick, data);
        System.out.println("######################################");
        System.out.println("##########BC加密数据后为#######");
        System.out.println(encryptByBC);
        System.out.println("######################################");
        String decrypt = GMSSLSM2EncryptUtils.decryptByPcie(index, "xdja1234", encryptByPcie);
        String decrypt1 = GMSSLSM2EncryptUtils.decryptByPcie(index, "xdja1234", encryptByBC);
        if (!decrypt.equalsIgnoreCase(data)) {
            System.out.println("PCIE卡解密自身加密数据失败");
        }
        if (!decrypt1.equalsIgnoreCase(data)) {
            System.out.println("PCIE卡解密BC加密数据失败");
        }
        if (decrypt.equalsIgnoreCase(data) &&
                decrypt1.equalsIgnoreCase(data)
        ) {
            System.out.println("######################################");
            System.out.println("##########SM2内部私钥解密需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2内部私钥解密需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }


    public static void sm2Encrypt(int index, KeyPair encKeyPair) throws Exception {
        String data = Base64.toBase64String(Hex.decode("1111111111"));
        PublicKey encPublick = GMSSLSM2KeyUtils.getEncryptPublicKeyByPcie(index);
        String encryptByPcie = GMSSLSM2EncryptUtils.encryptByPcie(encPublick, data);
        System.out.println("^^^^^^^^^^^^^^^^^AAAAPCIE" + encPublick);
        System.out.println("^^^^^^^^^^^^^^^^^BBBBC" + encKeyPair.getPublic());
        String encryptByBC = GMSSLSM2EncryptUtils.encryptByBC(encKeyPair.getPublic(), data);
        String decrypt = GMSSLSM2EncryptUtils.decryptByPcie(index, "xdja1234", encryptByPcie);
        String decrypt1 = GMSSLSM2EncryptUtils.decryptByPcie(index, "xdja1234", encryptByBC);
        String decrypt2 = GMSSLSM2EncryptUtils.decryptByBC(encKeyPair.getPrivate(), encryptByBC);
        String decrypt3 = GMSSLSM2EncryptUtils.decryptByBC(encKeyPair.getPrivate(), encryptByPcie);
        if (!decrypt.equalsIgnoreCase(data)) {
            System.out.println("PCIE卡解密自身加密数据失败");
        }
        if (!decrypt1.equalsIgnoreCase(data)) {
            System.out.println("PCIE卡解密BC加密数据失败");
        }
        if (!decrypt2.equalsIgnoreCase(data)) {
            System.out.println("BC解密自身加密数据失败");
        }
        if (!decrypt3.equalsIgnoreCase(data)) {
            System.out.println("BC解密PCIE卡加密数据失败");
        }
        if (decrypt.equalsIgnoreCase(data) &&
                decrypt1.equalsIgnoreCase(data) &&
                decrypt2.equalsIgnoreCase(data) &&
                decrypt3.equalsIgnoreCase(data)) {
            System.out.println("######################################");
            System.out.println("##########SM2内部私钥解密需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2内部私钥解密需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm1ECb() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        String plainText = GMSSLByteArrayUtils.base64Encode(data);
        String encryptByYunHsm = GMSSLSM1ECBEncryptUtils.encryptByYumhsmWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), plainText);
        String encryptByPcie = GMSSLSM1ECBEncryptUtils.encryptByPcieWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), plainText);
        String decryptData = GMSSLSM1ECBEncryptUtils.decryptByPcieWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm);
        String decryptData1 = GMSSLSM1ECBEncryptUtils.decryptByPcieWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie);
        String decryptData2 = GMSSLSM1ECBEncryptUtils.decryptByYumhsmWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie);
        String decryptData3 = GMSSLSM1ECBEncryptUtils.decryptByYumhsmWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm);
        if (decryptData.equalsIgnoreCase(plainText) &&
                decryptData1.equalsIgnoreCase(plainText) &&
                decryptData2.equalsIgnoreCase(plainText) &&
                decryptData3.equalsIgnoreCase(plainText)) {
            System.out.println("######################################");
            System.out.println("##########SM1ECB需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM1ECB需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm1ECbPKCS7() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210aaaaaaaaaa");
        String plainText = GMSSLByteArrayUtils.base64Encode(data);
        String encryptByYunHsm = GMSSLSM1ECBEncryptUtils.encryptByYumhsmWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), plainText);
        String encryptByPcie = GMSSLSM1ECBEncryptUtils.encryptByPcieWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), plainText);
        String decryptData = GMSSLSM1ECBEncryptUtils.decryptByPcieWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm);
        String decryptData1 = GMSSLSM1ECBEncryptUtils.decryptByPcieWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie);
        String decryptData2 = GMSSLSM1ECBEncryptUtils.decryptByYumhsmWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie);
        String decryptData3 = GMSSLSM1ECBEncryptUtils.decryptByYumhsmWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm);
        if (decryptData.equalsIgnoreCase(plainText) &&
                decryptData1.equalsIgnoreCase(plainText) &&
                decryptData2.equalsIgnoreCase(plainText) &&
                decryptData3.equalsIgnoreCase(plainText)) {
            System.out.println("######################################");
            System.out.println("##########SM1ECBPKCS7需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM1ECBPKCS7需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }


    public static void sm4ECb() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        String plainText = GMSSLByteArrayUtils.base64Encode(data);
        String encryptByYunHsm = GMSSLSM4ECBEncryptUtils.encryptByYumhsmWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), plainText);
        String encryptByPcie = GMSSLSM4ECBEncryptUtils.encryptByPcieWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), plainText);
        String decryptData = GMSSLSM4ECBEncryptUtils.decryptByPcieWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm);
        String decryptData1 = GMSSLSM4ECBEncryptUtils.decryptByPcieWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie);
        String decryptData2 = GMSSLSM4ECBEncryptUtils.decryptByYumhsmWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie);
        String decryptData3 = GMSSLSM4ECBEncryptUtils.decryptByYumhsmWithNoPadding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm);
        if (decryptData.equalsIgnoreCase(plainText) &&
                decryptData1.equalsIgnoreCase(plainText) &&
                decryptData2.equalsIgnoreCase(plainText) &&
                decryptData3.equalsIgnoreCase(plainText)) {
            System.out.println("######################################");
            System.out.println("##########SM4ECB需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM4ECB需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm4ECbPKCS7() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210aaaaaaaaaa");
        String plainText = GMSSLByteArrayUtils.base64Encode(data);
        String encryptByYunHsm = GMSSLSM4ECBEncryptUtils.encryptByYumhsmWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), plainText);
        String encryptByPcie = GMSSLSM4ECBEncryptUtils.encryptByPcieWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), plainText);
        String decryptData = GMSSLSM4ECBEncryptUtils.decryptByPcieWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm);
        String decryptData1 = GMSSLSM4ECBEncryptUtils.decryptByPcieWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie);
        String decryptData2 = GMSSLSM4ECBEncryptUtils.decryptByYumhsmWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByPcie);
        String decryptData3 = GMSSLSM4ECBEncryptUtils.decryptByYumhsmWithPKCS7Padding(GMSSLByteArrayUtils.base64Encode(key), encryptByYunHsm);
        if (decryptData.equalsIgnoreCase(plainText) &&
                decryptData1.equalsIgnoreCase(plainText) &&
                decryptData2.equalsIgnoreCase(plainText) &&
                decryptData3.equalsIgnoreCase(plainText)) {
            System.out.println("######################################");
            System.out.println("##########SM4ECBPKCS7需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM4ECBPKCS7需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm3Hash() throws Exception {
        String data = "test";
        String pcie = GMSSLSM3DigestUtils.digestByPcie(data);
        String bc = GMSSLSM3DigestUtils.digestByBC(data);
        String yunhsm = GMSSLSM3DigestUtils.digestByYunhsm(data);
        if (pcie.equalsIgnoreCase(bc) && pcie.equalsIgnoreCase(yunhsm)) {
            System.out.println("######################################");
            System.out.println("##########SM3 Hash需求完成#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM3 Hash需求失败!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }
}
