package com.xdja.pki.gmssl.main.sdf.pcie.demo;

import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import org.bouncycastle.util.encoders.Hex;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2021/6/15 14:39
 **/
public class RSAExportKey {
    public static void main(String[] args) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        //导出公钥
        int index = Integer.valueOf(args[0]);
        exportRSAKeyFormPcieCard(index, false);
        exportRSAKeyFormPcieCard(index, true);
    }

    private static void exportRSAKeyFormPcieCard(int index, boolean isEncrypt) throws Exception {
        String s = isEncrypt ? "签名公钥" : "加密公钥";
        PublicKey signKey = GMSSLRSAKeyUtils.getPublicKeyFromHardware(index, isEncrypt);
        System.out.println("###############导出的" + s + "为################");
        System.out.println(signKey);

    }
}
