/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.sdf.pcie.demo;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLAES128ECBEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA1DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA256DigestUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.util.encoders.Hex;

public class PCIERSATest {
    public static void main(String[] args) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        int index = Integer.parseInt(args[0]);
        KeyPair keyPair = PCIERSATest.generateRSA2048KeyPairByPCIE();
        PCIERSATest.importRSAKeyPair(index, keyPair);
        PCIERSATest.exportRSAKeyFormPcieCard(keyPair.getPublic(), index, false);
        PCIERSATest.exportRSAKeyFormPcieCard(keyPair.getPublic(), index, true);
        GMSSLSignatureAlgorithm algorithm = GMSSLSignatureAlgorithm.SHA256_WITH_RSA;
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] data = Hex.decode((String)"12345678900123456789");
        byte[] signByPcie = GMSSLRSASignUtils.sign((PrivateKey)GMSSLECKeyUtils.genSdfPrivateKey((int)index, (String)"xdja1234"), (byte[])data, (String)algorithm.getSigAlgName());
        PublicKey signPublick = GMSSLRSAKeyUtils.getPublicKeyFromHardware((int)index, (boolean)false);
        boolean b = GMSSLRSASignUtils.verify((PublicKey)signPublick, (byte[])data, (byte[])signByPcie, (String)algorithm.getSigAlgName());
        System.out.println(b);
        PCIERSATest.sha1Hash();
        PCIERSATest.sha256Hash();
        PCIERSATest.rsaSignWithAlg(index, keyPair, GMSSLSignatureAlgorithm.SHA256_WITH_RSA);
        PCIERSATest.rsaSignWithAlg(index, keyPair, GMSSLSignatureAlgorithm.SHA1_WITH_RSA);
        PCIERSATest.aes128(SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
        PCIERSATest.aes128(SdfSymmetricKeyParameters.PaddingType.NoPadding);
        PCIERSATest.testGenCert(index, GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName());
        PCIERSATest.testGenCert(index, GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName());
    }

    private static void exportRSAKeyFormPcieCard(PublicKey publicKey, int index, boolean isEncrypt) throws Exception {
        String s = isEncrypt ? "\u7b7e\u540d\u516c\u94a5" : "\u52a0\u5bc6\u516c\u94a5";
        PublicKey signKey = GMSSLRSAKeyUtils.getPublicKeyFromHardware((int)index, (boolean)isEncrypt);
        System.out.println("###############\u5bfc\u51fa\u7684" + s + "\u4e3a################");
        System.out.println(signKey);
        System.out.println("###############\u5bfc\u5165\u7684" + s + "\u4e3a################");
        System.out.println(publicKey);
        System.out.println("###############################");
        boolean equals = Arrays.equals(publicKey.getEncoded(), signKey.getEncoded());
        if (!equals) {
            System.out.println("\u5bfc\u5165\u7684\u5bc6\u94a5\u548c\u5bfc\u51fa\u7684\u4e0d\u4e00\u81f4,\u5bfc\u5165\u7684\u5bc6\u94a5\u7d22\u5f15\u4e3a " + index + " \u4e3a" + s);
            return;
        }
    }

    private static void importRSAKeyPair(int index, KeyPair keyPair) throws Exception {
        boolean sign = GMSSLRSAKeyUtils.writeKeyPairToHardWare((int)index, (String)"xdja1234", (KeyPair)keyPair);
        System.out.println(sign);
    }

    private static KeyPair generateRSA2048KeyPairByPCIE() throws Exception {
        return GMSSLRSAKeyUtils.generateRSAKeyPair((int)2048);
    }

    public static void sha256Hash() throws Exception {
        String bc;
        String data = "test";
        String pcie = Hex.toHexString((byte[])GMSSLSHA256DigestUtils.digest((byte[])data.getBytes()));
        if (pcie.equalsIgnoreCase(bc = Hex.toHexString((byte[])GMSSLSHA256DigestUtils.digestByBC((byte[])data.getBytes())))) {
            System.out.println("######################################");
            System.out.println("##########sha256 Hash\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!sha256 Hash\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sha1Hash() throws Exception {
        String bc;
        String data = "test";
        String pcie = Hex.toHexString((byte[])GMSSLSHA1DigestUtils.digest((byte[])data.getBytes()));
        if (pcie.equalsIgnoreCase(bc = Hex.toHexString((byte[])GMSSLSHA1DigestUtils.digestByBC((byte[])data.getBytes())))) {
            System.out.println("######################################");
            System.out.println("##########sha1 Hash\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!sha1 Hash\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void rsaSignWithAlg(int index, KeyPair signKeyPair, GMSSLSignatureAlgorithm algorithm) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] data = Hex.decode((String)"12345678900123456789");
        byte[] signByPcie = GMSSLRSASignUtils.sign((PrivateKey)GMSSLECKeyUtils.genSdfPrivateKey((int)index, (String)"xdja1234"), (byte[])data, (String)algorithm.getSigAlgName());
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] signByBC = GMSSLRSASignUtils.sign((PrivateKey)signKeyPair.getPrivate(), (byte[])data, (String)algorithm.getSigAlgName());
        GMSSLPkiCryptoInit.getPcieInstance();
        PublicKey signPublick = GMSSLRSAKeyUtils.getPublicKeyFromHardware((int)index, (boolean)false);
        boolean b = GMSSLRSASignUtils.verify((PublicKey)signPublick, (byte[])data, (byte[])signByPcie, (String)algorithm.getSigAlgName());
        boolean b1 = GMSSLRSASignUtils.verify((PublicKey)signPublick, (byte[])data, (byte[])signByBC, (String)algorithm.getSigAlgName());
        GMSSLPkiCryptoInit.getBCInstance();
        boolean b2 = GMSSLRSASignUtils.verify((PublicKey)signKeyPair.getPublic(), (byte[])data, (byte[])signByPcie, (String)algorithm.getSigAlgName());
        boolean b3 = GMSSLRSASignUtils.verify((PublicKey)signKeyPair.getPublic(), (byte[])data, (byte[])signByBC, (String)algorithm.getSigAlgName());
        GMSSLPkiCryptoInit.getPcieInstance();
        if (!(b && b1 && b3 && b2)) {
            System.out.println("b" + b);
            System.out.println("b1" + b1);
            System.out.println("b2" + b2);
            System.out.println("b3" + b3);
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!RSA\u5185\u90e8\u79c1\u94a5\u7b7e\u540d\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        System.out.println("######################################");
        System.out.println("##########RSA\u5185\u90e8\u79c1\u94a5\u7b7e\u540d\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("######################################");
    }

    public static void aes128(SdfSymmetricKeyParameters.PaddingType paddingType) throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] encryptByPcie = GMSSLAES128ECBEncryptUtils.encrypt((byte[])key, (byte[])data, (SdfSymmetricKeyParameters.PaddingType)paddingType);
        GMSSLPkiCryptoInit.getPcieInstance();
        byte[] decryptData1 = GMSSLAES128ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByPcie, (SdfSymmetricKeyParameters.PaddingType)paddingType);
        GMSSLPkiCryptoInit.getBCInstance();
        byte[] decryptData2 = paddingType == SdfSymmetricKeyParameters.PaddingType.SSL3Padding ? decryptData1 : GMSSLAES128ECBEncryptUtils.decrypt((byte[])key, (byte[])encryptByPcie, (SdfSymmetricKeyParameters.PaddingType)paddingType);
        GMSSLPkiCryptoInit.getPcieInstance();
        if (!GMSSLByteArrayUtils.isEqual((byte[])decryptData1, (byte[])data) || !GMSSLByteArrayUtils.isEqual((byte[])decryptData2, (byte[])data)) {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!AES\u9700\u6c42\u5931\u8d25!!!!!!!" + paddingType);
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        System.out.println("######################################");
        System.out.println("##########AES\u9700\u6c42\u5b8c\u6210#######" + paddingType);
        System.out.println("######################################");
    }

    public static void testGenCert(int index, String algName) throws Exception {
        GMSSLPkiCryptoInit.getPcieInstance();
        String rDN = "cn=root,o=xdja,c=cn";
        PublicKey publickey = GMSSLRSAKeyUtils.getPublicKeyFromHardware((int)index, (boolean)false);
        ArrayList<Extension> rExtensions = new ArrayList<Extension>();
        rExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        rExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)publickey));
        rExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(null));
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, "xdja1234");
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -1);
        Date noBefore = calendar.getTime();
        calendar.add(1, 1);
        Date noAfter = calendar.getTime();
        X509Certificate rCert = GMSSLCertUtils.generateCert((String)rDN, (String)rDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)sdfPrivateKey, (PublicKey)publickey, (String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), rExtensions, (boolean)false);
        System.out.println(rCert);
        boolean b1 = GMSSLCertUtils.verifyCert((PublicKey)publickey, (X509Certificate)rCert);
        System.out.println(b1);
        GMSSLPkiCryptoInit.getBCInstance();
        boolean b2 = GMSSLCertUtils.verifyCert((PublicKey)publickey, (X509Certificate)rCert);
        System.out.println(b2);
    }
}

