/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.sdf.pcie.demo;

import com.xdja.hsm.api.alg.AlgId;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM1ECBEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfECCKeyPair;
import com.xdja.pki.gmssl.sdf.pcie.PcieSdfSDK;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class PCIETest {
    public static void main(String[] args) throws Exception {
        int index = 3;
        KeyPair signKeyPair = PCIETest.generateSM2KeyPairByPCIE();
        KeyPair encKeyPair = PCIETest.generateSM2KeyPairByPCIE();
        PCIETest.importSM2KeyPair(index, signKeyPair, encKeyPair);
        PCIETest.sm2EncryptWith1Index(1);
        PCIETest.exportSm2Key(index);
        PCIETest.sm2Sign(index, signKeyPair);
        PCIETest.sm2Encrypt(index, encKeyPair);
        PCIETest.sm1ECb();
        PCIETest.sm1ECbPKCS7();
        PCIETest.sm3Hash();
        PCIETest.sm4ECb();
        PCIETest.sm4ECbPKCS7();
    }

    public static KeyPair generateSM2KeyPairByPCIE() throws Exception {
        PcieSdfSDK sdfSDK = new PcieSdfSDK();
        sdfSDK.init();
        SdfECCKeyPair sdfECCKeyPair = sdfSDK.generateKeyPairEcc(AlgId.SGD_SM2);
        sdfSDK.release();
        PublicKey publicKey = GMSSLX509Utils.convertSM2PublicKey((byte[])sdfECCKeyPair.getSdfECCPublicKey().getX(), (byte[])sdfECCKeyPair.getSdfECCPublicKey().getY());
        PrivateKey privateKey = GMSSLX509Utils.convertSM2PrivateKey((byte[])sdfECCKeyPair.getSdfECCPrivateKey().getK());
        System.out.println(publicKey);
        System.out.println(privateKey);
        System.out.println("#################################");
        System.out.println("##########\u751f\u6210\u516c\u79c1\u94a5\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
        return new KeyPair(publicKey, privateKey);
    }

    public static void importSM2KeyPair(int index, KeyPair signKeyPair, KeyPair encKeyPair) throws Exception {
        PcieSdfSDK pcieSdfSDK = new PcieSdfSDK();
        pcieSdfSDK.init();
        pcieSdfSDK.importSM2PublicKey(signKeyPair.getPublic(), index, true);
        pcieSdfSDK.importSM2PrivateKey(signKeyPair.getPrivate(), index, "xdja1234".getBytes(), true);
        pcieSdfSDK.importSM2PublicKey(encKeyPair.getPublic(), index, false);
        pcieSdfSDK.importSM2PrivateKey(encKeyPair.getPrivate(), index, "xdja1234".getBytes(), false);
        pcieSdfSDK.release();
        System.out.println("#################################");
        System.out.println("##########\u5bfc\u5165\u516c\u79c1\u94a5\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void exportSm2Key(int index) throws Exception {
        PublicKey signPublicKey = GMSSLSM2KeyUtils.getSignPublicKeyByPcie((int)index);
        PublicKey encPublicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByYunhsm((int)index);
        System.out.println(signPublicKey);
        System.out.println(encPublicKey);
        System.out.println("#################################");
        System.out.println("##########\u5bfc\u51fa\u516c\u79c1\u94a5\u9700\u6c42\u5b8c\u6210#######");
        System.out.println("#################################");
    }

    public static void sm2Sign(int index, KeyPair signKeyPair) throws Exception {
        String data = Base64.toBase64String((byte[])Hex.decode((String)"1111111111"));
        String signData = GMSSLSM2SignUtils.signByPcie((int)index, (String)"xdja1234", (String)data);
        String signByBC = GMSSLSM2SignUtils.signByBC((PrivateKey)signKeyPair.getPrivate(), (String)data);
        PublicKey signPublick = GMSSLSM2KeyUtils.getSignPublicKeyByPcie((int)index);
        boolean b = GMSSLSM2SignUtils.verifyByPcie((PublicKey)signPublick, (String)data, (String)signData);
        boolean b1 = GMSSLSM2SignUtils.verifyByPcie((PublicKey)signPublick, (String)data, (String)signByBC);
        boolean b2 = GMSSLSM2SignUtils.verifyByBC((PublicKey)signPublick, (String)data, (String)signByBC);
        boolean b3 = GMSSLSM2SignUtils.verifyByBC((PublicKey)signPublick, (String)data, (String)signData);
        if (b && b1 && b3 && b2) {
            System.out.println("######################################");
            System.out.println("##########SM2\u5185\u90e8\u79c1\u94a5\u7b7e\u540d\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2\u5185\u90e8\u79c1\u94a5\u7b7e\u540d\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm2EncryptWith1Index(int index) throws Exception {
        String data = Base64.toBase64String((byte[])Hex.decode((String)"1111111111"));
        PublicKey encPublick = GMSSLSM2KeyUtils.getEncryptPublicKeyByPcie((int)index);
        String encryptByPcie = GMSSLSM2EncryptUtils.encryptByPcie((PublicKey)encPublick, (String)data);
        System.out.println("######################################");
        System.out.println("##########PCIE\u5361\u52a0\u5bc6\u6570\u636e\u540e\u4e3a encryptByPcie#######");
        System.out.println(encryptByPcie);
        System.out.println("######################################");
        String encryptByBC = GMSSLSM2EncryptUtils.encryptByBC((PublicKey)encPublick, (String)data);
        System.out.println("######################################");
        System.out.println("##########BC\u52a0\u5bc6\u6570\u636e\u540e\u4e3a#######");
        System.out.println(encryptByBC);
        System.out.println("######################################");
        String decrypt = GMSSLSM2EncryptUtils.decryptByPcie((int)index, (String)"xdja1234", (String)encryptByPcie);
        String decrypt1 = GMSSLSM2EncryptUtils.decryptByPcie((int)index, (String)"xdja1234", (String)encryptByBC);
        if (!decrypt.equalsIgnoreCase(data)) {
            System.out.println("PCIE\u5361\u89e3\u5bc6\u81ea\u8eab\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (!decrypt1.equalsIgnoreCase(data)) {
            System.out.println("PCIE\u5361\u89e3\u5bc6BC\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (decrypt.equalsIgnoreCase(data) && decrypt1.equalsIgnoreCase(data)) {
            System.out.println("######################################");
            System.out.println("##########SM2\u5185\u90e8\u79c1\u94a5\u89e3\u5bc6\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2\u5185\u90e8\u79c1\u94a5\u89e3\u5bc6\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm2Encrypt(int index, KeyPair encKeyPair) throws Exception {
        String data = Base64.toBase64String((byte[])Hex.decode((String)"1111111111"));
        PublicKey encPublick = GMSSLSM2KeyUtils.getEncryptPublicKeyByPcie((int)index);
        String encryptByPcie = GMSSLSM2EncryptUtils.encryptByPcie((PublicKey)encPublick, (String)data);
        System.out.println("^^^^^^^^^^^^^^^^^AAAAPCIE" + encPublick);
        System.out.println("^^^^^^^^^^^^^^^^^BBBBC" + encKeyPair.getPublic());
        String encryptByBC = GMSSLSM2EncryptUtils.encryptByBC((PublicKey)encKeyPair.getPublic(), (String)data);
        String decrypt = GMSSLSM2EncryptUtils.decryptByPcie((int)index, (String)"xdja1234", (String)encryptByPcie);
        String decrypt1 = GMSSLSM2EncryptUtils.decryptByPcie((int)index, (String)"xdja1234", (String)encryptByBC);
        String decrypt2 = GMSSLSM2EncryptUtils.decryptByBC((PrivateKey)encKeyPair.getPrivate(), (String)encryptByBC);
        String decrypt3 = GMSSLSM2EncryptUtils.decryptByBC((PrivateKey)encKeyPair.getPrivate(), (String)encryptByPcie);
        if (!decrypt.equalsIgnoreCase(data)) {
            System.out.println("PCIE\u5361\u89e3\u5bc6\u81ea\u8eab\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (!decrypt1.equalsIgnoreCase(data)) {
            System.out.println("PCIE\u5361\u89e3\u5bc6BC\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (!decrypt2.equalsIgnoreCase(data)) {
            System.out.println("BC\u89e3\u5bc6\u81ea\u8eab\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (!decrypt3.equalsIgnoreCase(data)) {
            System.out.println("BC\u89e3\u5bc6PCIE\u5361\u52a0\u5bc6\u6570\u636e\u5931\u8d25");
        }
        if (decrypt.equalsIgnoreCase(data) && decrypt1.equalsIgnoreCase(data) && decrypt2.equalsIgnoreCase(data) && decrypt3.equalsIgnoreCase(data)) {
            System.out.println("######################################");
            System.out.println("##########SM2\u5185\u90e8\u79c1\u94a5\u89e3\u5bc6\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM2\u5185\u90e8\u79c1\u94a5\u89e3\u5bc6\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm1ECb() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        String plainText = GMSSLByteArrayUtils.base64Encode((byte[])data);
        String encryptByYunHsm = GMSSLSM1ECBEncryptUtils.encryptByYumhsmWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)plainText);
        String encryptByPcie = GMSSLSM1ECBEncryptUtils.encryptByPcieWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)plainText);
        String decryptData = GMSSLSM1ECBEncryptUtils.decryptByPcieWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByYunHsm);
        String decryptData1 = GMSSLSM1ECBEncryptUtils.decryptByPcieWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByPcie);
        String decryptData2 = GMSSLSM1ECBEncryptUtils.decryptByYumhsmWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByPcie);
        String decryptData3 = GMSSLSM1ECBEncryptUtils.decryptByYumhsmWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByYunHsm);
        if (decryptData.equalsIgnoreCase(plainText) && decryptData1.equalsIgnoreCase(plainText) && decryptData2.equalsIgnoreCase(plainText) && decryptData3.equalsIgnoreCase(plainText)) {
            System.out.println("######################################");
            System.out.println("##########SM1ECB\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM1ECB\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm1ECbPKCS7() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210aaaaaaaaaa");
        String plainText = GMSSLByteArrayUtils.base64Encode((byte[])data);
        String encryptByYunHsm = GMSSLSM1ECBEncryptUtils.encryptByYumhsmWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)plainText);
        String encryptByPcie = GMSSLSM1ECBEncryptUtils.encryptByPcieWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)plainText);
        String decryptData = GMSSLSM1ECBEncryptUtils.decryptByPcieWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByYunHsm);
        String decryptData1 = GMSSLSM1ECBEncryptUtils.decryptByPcieWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByPcie);
        String decryptData2 = GMSSLSM1ECBEncryptUtils.decryptByYumhsmWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByPcie);
        String decryptData3 = GMSSLSM1ECBEncryptUtils.decryptByYumhsmWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByYunHsm);
        if (decryptData.equalsIgnoreCase(plainText) && decryptData1.equalsIgnoreCase(plainText) && decryptData2.equalsIgnoreCase(plainText) && decryptData3.equalsIgnoreCase(plainText)) {
            System.out.println("######################################");
            System.out.println("##########SM1ECBPKCS7\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM1ECBPKCS7\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm4ECb() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        String plainText = GMSSLByteArrayUtils.base64Encode((byte[])data);
        String encryptByYunHsm = GMSSLSM4ECBEncryptUtils.encryptByYumhsmWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)plainText);
        String encryptByPcie = GMSSLSM4ECBEncryptUtils.encryptByPcieWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)plainText);
        String decryptData = GMSSLSM4ECBEncryptUtils.decryptByPcieWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByYunHsm);
        String decryptData1 = GMSSLSM4ECBEncryptUtils.decryptByPcieWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByPcie);
        String decryptData2 = GMSSLSM4ECBEncryptUtils.decryptByYumhsmWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByPcie);
        String decryptData3 = GMSSLSM4ECBEncryptUtils.decryptByYumhsmWithNoPadding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByYunHsm);
        if (decryptData.equalsIgnoreCase(plainText) && decryptData1.equalsIgnoreCase(plainText) && decryptData2.equalsIgnoreCase(plainText) && decryptData3.equalsIgnoreCase(plainText)) {
            System.out.println("######################################");
            System.out.println("##########SM4ECB\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM4ECB\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm4ECbPKCS7() throws Exception {
        byte[] key = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210");
        byte[] data = GMSSLByteArrayUtils.hexDecode((String)"0123456789abcdeffedcba9876543210aaaaaaaaaa");
        String plainText = GMSSLByteArrayUtils.base64Encode((byte[])data);
        String encryptByYunHsm = GMSSLSM4ECBEncryptUtils.encryptByYumhsmWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)plainText);
        String encryptByPcie = GMSSLSM4ECBEncryptUtils.encryptByPcieWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)plainText);
        String decryptData = GMSSLSM4ECBEncryptUtils.decryptByPcieWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByYunHsm);
        String decryptData1 = GMSSLSM4ECBEncryptUtils.decryptByPcieWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByPcie);
        String decryptData2 = GMSSLSM4ECBEncryptUtils.decryptByYumhsmWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByPcie);
        String decryptData3 = GMSSLSM4ECBEncryptUtils.decryptByYumhsmWithPKCS7Padding((String)GMSSLByteArrayUtils.base64Encode((byte[])key), (String)encryptByYunHsm);
        if (decryptData.equalsIgnoreCase(plainText) && decryptData1.equalsIgnoreCase(plainText) && decryptData2.equalsIgnoreCase(plainText) && decryptData3.equalsIgnoreCase(plainText)) {
            System.out.println("######################################");
            System.out.println("##########SM4ECBPKCS7\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM4ECBPKCS7\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public static void sm3Hash() throws Exception {
        String data = "test";
        String pcie = GMSSLSM3DigestUtils.digestByPcie((String)data);
        String bc = GMSSLSM3DigestUtils.digestByBC((String)data);
        String yunhsm = GMSSLSM3DigestUtils.digestByYunhsm((String)data);
        if (pcie.equalsIgnoreCase(bc) && pcie.equalsIgnoreCase(yunhsm)) {
            System.out.println("######################################");
            System.out.println("##########SM3 Hash\u9700\u6c42\u5b8c\u6210#######");
            System.out.println("######################################");
        } else {
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("!!!!!!!!!!SM3 Hash\u9700\u6c42\u5931\u8d25!!!!!!!");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }
}

