/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.tomcat.tools.main;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.tomcat.tools.main.ResolveCertUtils;
import com.xdja.pki.gmssl.tomcat.utils.GMSSLTomcatUtils;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Scanner;

public class GMSSLTomcatMain {
    public static void main(String[] args) {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method Example: startup , shutdown, restart, closePort openHttpPort,openHttpsPort");
            System.out.println("if you use startup please add tomcat path");
            System.out.println("if you use shutdown please add tomcat path");
            System.out.println("if you use restart please add tomcat path");
            String os = System.getProperty("os.name");
            System.out.println("System Property is " + os);
            return;
        }
        boolean flag = false;
        if (args[0].equalsIgnoreCase("startup")) {
            flag = true;
            if (args.length != 2) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar startup /usr/local/tomcat");
                return;
            }
            GMSSLTomcatMain.startupTomcat(args[1]);
        }
        if (args[0].equalsIgnoreCase("shutdown")) {
            flag = true;
            if (args.length != 2) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar shutdown /usr/local/tomcat");
                return;
            }
            GMSSLTomcatMain.shutdownTomcat(args[1]);
        }
        if (args[0].equalsIgnoreCase("restart")) {
            flag = true;
            if (args.length != 2 && args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar restartTomcat /usr/local/tomcat");
                return;
            }
            if (args.length == 2) {
                GMSSLTomcatMain.restartTomcat(args[1]);
            } else {
                GMSSLTomcatMain.restartTomcat(args[1], args[2]);
            }
        }
        if (args[0].equalsIgnoreCase("closePort")) {
            flag = true;
            if (args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar closePort /usr/local/tomcat 8888");
                return;
            }
            try {
                GMSSLTomcatMain.closeTomcatPort(args[1], Integer.valueOf(args[2]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (args[0].equalsIgnoreCase("openHttpPort")) {
            flag = true;
            if (args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar openHttpPort /usr/local/tomcat 8888");
                return;
            }
            try {
                GMSSLTomcatMain.openHttpPort(args[1], Integer.valueOf(args[2]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (args[0].equalsIgnoreCase("openHttpsPort")) {
            if (args.length == 1) {
                flag = true;
                GMSSLTomcatMain.openHttpsPort();
            }
            if (args.length == 2) {
                try {
                    flag = true;
                    GMSSLTomcatMain.openHttpsPort(args[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!flag) {
            System.out.println("invalid method , please insert right method");
        }
    }

    private static void startupTomcat(String path) {
        GMSSLTomcatUtils.startupTomcat((String)path);
    }

    private static void shutdownTomcat(String path) {
        GMSSLTomcatUtils.shutdownTomcat((String)path);
    }

    private static void restartTomcat(String path) {
        GMSSLTomcatUtils.restartTomcat((String)path);
    }

    private static void restartTomcat(String path, String shPath) {
        GMSSLTomcatUtils.restartTomcat((String)path, (String)shPath);
    }

    private static void openHttpPort(String path, int port) throws Exception {
        GMSSLTomcatUtils.openHttpPort((String)path, (int)port);
    }

    private static void closeTomcatPort(String path, int port) throws Exception {
        GMSSLTomcatUtils.closeTomcatPort((String)path, (int)port);
    }

    private static void openHttpsPort() {
        String type;
        Scanner in = new Scanner(System.in);
        do {
            System.out.println("Please insert right crypto type Example Bc , YunHsm , Pcie");
        } while (!(type = in.next()).equalsIgnoreCase("Bc") && !type.equalsIgnoreCase("YunHsm") && !type.equalsIgnoreCase("Pcie"));
        System.out.println("you chose the crypto is " + type);
        X509Certificate caCert = null;
        X509Certificate caServerSignCert = null;
        X509Certificate caServerEncCert = null;
        try {
            System.out.println("Please insert RootCert.p7b  path");
            String next = in.next();
            caCert = GMSSLX509Utils.readCertificateFromCer((String)next);
            System.out.println("Please insert SignCert.p7b path");
            next = in.next();
            caServerSignCert = GMSSLX509Utils.readCertificateFromCer((String)next);
            System.out.println("Please insert EncCert.pem path");
            next = in.next();
            System.out.println("Please insert EncCert.pem keyIndex");
            int keyIndex = in.nextInt();
            caServerEncCert = GMSSLX509Utils.readCertificateFromCer((String)next);
            System.out.println("Please insert tomcatPath path");
            String tomcatPath = in.next();
            System.out.println("Please insert https port");
            int port = in.nextInt();
            if (type.equalsIgnoreCase("Bc")) {
                System.out.println("Please insert caServerSignPriKey path");
                next = in.next();
                PrivateKey caServerSignPriKey = GMSSLX509Utils.readPrivateKeyFromPem((String)next);
                System.out.println("Please insert caServerEncPriKey path");
                next = in.next();
                PrivateKey caServerEncPriKey = GMSSLX509Utils.readPrivateKeyFromPem((String)next);
                GMSSLTomcatUtils.openHttpsPortByBC((X509Certificate)caCert, (X509Certificate)caServerSignCert, (X509Certificate)caServerEncCert, (PrivateKey)caServerSignPriKey, (PrivateKey)caServerEncPriKey, (String)tomcatPath, (int)port);
            } else {
                System.out.println("Please insert ca Server PrivateKey Index");
                int index = in.nextInt();
                System.out.println("Please insert ca Server PrivateKey Password");
                String password = in.next();
                if (type.equalsIgnoreCase("YunHsm")) {
                    GMSSLTomcatUtils.openHttpsPortByYunHsm((X509Certificate)caCert, (X509Certificate)caServerSignCert, (X509Certificate)caServerEncCert, (int)index, (String)password, (String)tomcatPath, (int)port);
                } else {
                    GMSSLTomcatUtils.openHttpsPortByPCIE((X509Certificate)caCert, (X509Certificate)caServerSignCert, (X509Certificate)caServerEncCert, (int)index, (String)password, (String)tomcatPath, (int)port);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void openHttpsPort(String confPath) throws Exception {
        ResolveCertUtils.addHttpsPort(confPath);
    }
}

