package com.xdja.pki.gmssl.main.tomcat.tools;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;

import java.security.PrivateKey;

/**
 * @ClassName KeyStorePropertiesEntry
 * @Description TODO
 * @Date 2019/9/24 10:24
 * @Author FengZhen
 */
public class KeyStorePropertiesEntry {
    //写出路径
    private String writePath;
    //服务器签名证书P7b地址
    private String signCertPath;
    //服务器加密证书地址
    private String encCertPath;

    private String encPriKeyPath;

    private String signPriKeyPath;

    public PrivateKey getEncPrivateKey() throws Exception {
        return GMSSLX509Utils.readPrivateKeyFromPem(encPriKeyPath);
    }

    public PrivateKey getSignPrivateKey() throws Exception {
        return GMSSLX509Utils.readPrivateKeyFromPem(signPriKeyPath);
    }


    public String getWritePath() {
        return writePath;
    }

    public void setWritePath(String writePath) {
        this.writePath = writePath;
    }

    public String getSignCertPath() {
        return signCertPath;
    }

    public void setSignCertPath(String signCertPath) {
        this.signCertPath = signCertPath;
    }

    public String getEncCertPath() {
        return encCertPath;
    }

    public void setEncCertPath(String encCertPath) {
        this.encCertPath = encCertPath;
    }

    public String getEncPriKeyPath() {
        return encPriKeyPath;
    }

    public void setEncPriKeyPath(String encPriKeyPath) {
        this.encPriKeyPath = encPriKeyPath;
    }

    public String getSignPriKeyPath() {
        return signPriKeyPath;
    }

    public void setSignPriKeyPath(String signPriKeyPath) {
        this.signPriKeyPath = signPriKeyPath;
    }
}
