package com.xdja.pki.gmssl.main.tomcat.tools;

import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.tomcat.utils.GMSSLTomcatUtils;

import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Scanner;

/**
 * @description: tomcat初始化模块测试函数，
 * @date: 9:08 2019/6/10
 */
public class Main {
    public static void main(String[] args) {
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method Example: startup ,getSignCert, shutdown, restart, closePort openHttpPort,openHttpsPort,getTrustCert,generateP10,getPrivateKeyStore");
            System.out.println("if you use startup please add tomcat path");
            System.out.println("if you use shutdown please add tomcat path");
            System.out.println("if you use restart please add tomcat path");
            System.out.println("if you use getTrustCert please add trustcertP7b path and write path");
            System.out.println("if you use generateP10 please add keySize p10Dn signAlgName and write path");
            System.out.println("if you use getPrivateKeyStore please write keystore.conf path");
            System.out.println("if you use getSignCert  please write Sign.p7b path and write path");
            String os = System.getProperty("os.name");
            System.out.println("System Property is " + os);
            return;
        }
        boolean flag = false;
        if (args[0].equalsIgnoreCase("startup")) {
            flag = true;
            if (args.length != 2) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar startup /usr/local/tomcat");
                return;
            }
            startupTomcat(args[1]);
        }
        if (args[0].equalsIgnoreCase("generateSm2P10")) {
            if (args.length == 3) {
                flag = true;
                try {
                    ResolveCertUtils.generateSm2P10((args[1]), args[2]);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar generateSm2P10  cn=server,o=xdja,c=cn  /root/tools/ ");
            }
        }
        if (args[0].equalsIgnoreCase("getSignCert")) {
            flag = true;
            if (args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar getSignCert /usr/local/Sign.p7b /usr/local");
                return;
            }
            try {
                ResolveCertUtils.getSignCert(args[1],args[2]);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (args[0].equalsIgnoreCase("shutdown")) {
            flag = true;
            if (args.length != 2) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar shutdown /usr/local/tomcat");
                return;
            }
            shutdownTomcat(args[1]);
        }
        if (args[0].equalsIgnoreCase("restart")) {
            flag = true;
            if (args.length != 2 && args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar restartTomcat /usr/local/tomcat");
                return;
            }
            if (args.length == 2) {
                restartTomcat(args[1]);
            } else {
                restartTomcat(args[1], args[2]);
            }
        }
        if (args[0].equalsIgnoreCase("closePort")) {
            flag = true;
            if (args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar closePort /usr/local/tomcat 8888");
                return;
            }
            try {
                closeTomcatPort(args[1], Integer.valueOf(args[2]));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (args[0].equalsIgnoreCase("openHttpPort")) {
            flag = true;
            if (args.length != 3) {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar openHttpPort /usr/local/tomcat 8888");
                return;
            }
            try {
                openHttpPort(args[1], Integer.valueOf(args[2]));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (args[0].equalsIgnoreCase("openHttpsPort")) {
            if (args.length == 1) {
                flag = true;
                openHttpsPort();
            }
            if (args.length == 2) {
                try {
                    flag = true;
                    openHttpsPort(args[1]);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (args[0].equalsIgnoreCase("getPrivateKeyStore")) {
            if (args.length == 2) {
                flag = true;
                try {
                    ResolveCertUtils.getPriKeyStore(args[1]);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar generateP10 2048  cn=server,o=xdja,c=cn sha256withrsa  /root/tools/ ");
            }
        }
        if (args[0].equalsIgnoreCase("generateP10")) {
            if (args.length == 5) {
                flag = true;
                try {
                    ResolveCertUtils.generateP10(Integer.valueOf(args[1]), args[2], args[3], args[4]);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Please insert right param");
                System.out.println("Example java -jar *.jar generateP10 2048  cn=server,o=xdja,c=cn sha256withrsa  /root/tools/ ");
            }
        }
        if (args[0].equalsIgnoreCase("getTrustCert")) {
            flag = true;
            //args[1] trustCertPath
            String trustSignCert = GMSSLFileUtils.fileToString(new File(args[1]), "utf-8");
            try {
                List<X509Certificate> certs = ResolveCertUtils.getCertsByCertChain(trustSignCert);
                System.out.println("解析证书成功");
                //args[2] write path
                ResolveCertUtils.writeKeyJson(args[2], "ca.pem", "caCerts", certs);
                System.out.println("写出文件到" + args[2] + "成功");
                System.out.println("请将该文件相关替换到配置文件中");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!flag) {
            System.out.println("invalid method , please insert right method");
        }
    }

    private static void startupTomcat(String path) {
        GMSSLTomcatUtils.startupTomcat(path);
    }

    private static void shutdownTomcat(String path) {
        GMSSLTomcatUtils.shutdownTomcat(path);
    }

    private static void restartTomcat(String path) {
        GMSSLTomcatUtils.restartTomcat(path);
    }

    private static void restartTomcat(String path, String shPath) {
        GMSSLTomcatUtils.restartTomcat(path, shPath);
    }

    private static void openHttpPort(String path, int port) throws Exception {
        GMSSLTomcatUtils.openHttpPort(path, port);
    }

    private static void closeTomcatPort(String path, int port) throws Exception {
        GMSSLTomcatUtils.closeTomcatPort(path, port);
    }

    private static void openHttpsPort() {
        Scanner in = new Scanner(System.in);

        String type;
        do {
            System.out.println("Please insert right crypto type Example Bc , YunHsm , Pcie");
            type = in.next();
        } while (!(type.equalsIgnoreCase("Bc") ||
                type.equalsIgnoreCase("YunHsm") ||
                type.equalsIgnoreCase("Pcie")));
        System.out.println("you chose the crypto is " + type);
        X509Certificate caCert = null;
        X509Certificate caServerSignCert = null;
        X509Certificate caServerEncCert = null;
        String tomcatPath;
        int port;
        try {
            System.out.println("Please insert RootCert.p7b  path");
            String next = in.next();
            caCert = GMSSLX509Utils.readCertificateFromCer(next);

            System.out.println("Please insert SignCert.p7b path");
            next = in.next();
            caServerSignCert = GMSSLX509Utils.readCertificateFromCer(next);
            //    GMSSLYunHsmUtils.getYunHsmInfo()
            System.out.println("Please insert EncCert.pem path");
            next = in.next();
            System.out.println("Please insert EncCert.pem keyIndex");
            int keyIndex = in.nextInt();
            //    getEncCert
            caServerEncCert = GMSSLX509Utils.readCertificateFromCer(next);

            System.out.println("Please insert tomcatPath path");
            tomcatPath = in.next();


            System.out.println("Please insert https port");
            port = in.nextInt();


            if (type.equalsIgnoreCase("Bc")) {
                System.out.println("Please insert caServerSignPriKey path");
                next = in.next();
                PrivateKey caServerSignPriKey = GMSSLX509Utils.readPrivateKeyFromPem(next);
                System.out.println("Please insert caServerEncPriKey path");
                next = in.next();
                PrivateKey caServerEncPriKey = GMSSLX509Utils.readPrivateKeyFromPem(next);
                GMSSLTomcatUtils.openHttpsPortByBC(caCert, caServerSignCert, caServerEncCert, caServerSignPriKey, caServerEncPriKey, tomcatPath, port);
            } else {
                System.out.println("Please insert ca Server PrivateKey Index");
                int index = in.nextInt();
                System.out.println("Please insert ca Server PrivateKey Password");
                String password = in.next();
                if (type.equalsIgnoreCase("YunHsm")) {
                    GMSSLTomcatUtils.openHttpsPortByYunHsm(caCert, caServerSignCert, caServerEncCert, index, password, tomcatPath, port);
                } else {
                    GMSSLTomcatUtils.openHttpsPortByPCIE(caCert, caServerSignCert, caServerEncCert, index, password, tomcatPath, port);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void openHttpsPort(String confPath) throws Exception {
        ResolveCertUtils.addHttpsPort(confPath);
    }
}
