package com.xdja.pki.gmssl.main.tomcat.tools;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;

import java.security.PrivateKey;

/**
 * @ClassName TomcatPropertiesEntry
 * @Description TODO
 * @Date 2019/7/24 11:02
 * @Author FengZhen
 */
public class TomcatPropertiesEntry {
    //Tomcat路径
    private String tomcatPath;
    //根证书P7b地址
    private String rootCertPath;
    //服务器签名证书P7b地址
    private String signCertPath;
    //服务器加密证书地址
    private String encCertPath;
    //服务器证书密钥索引
    private int encKeyIndex;
    //服务器证书密钥访问控制码
    private String encPriKey;
    //需要开启的https端口
    private int httpsPort;
    //需要开启的加密类型
    private String cryptoType;
    //密钥类型  RSA ? EC
    private String keyType;

    private String encPriKeyPath;

    private String signPriKeyPath;

    public PrivateKey getEncPrivateKey() throws Exception {
        return GMSSLX509Utils.readPrivateKeyFromPem(encPriKeyPath);
    }

    public PrivateKey getSignPrivateKey() throws Exception {
        return GMSSLX509Utils.readPrivateKeyFromPem(signPriKeyPath);
    }

    public String getSignPriKeyPath() {
        return signPriKeyPath;
    }

    public void setSignPriKeyPath(String signPriKeyPath) {
        this.signPriKeyPath = signPriKeyPath;
    }

    public String getEncPriKeyPath() {
        return encPriKeyPath;
    }

    public void setEncPriKeyPath(String encPriKeyPath) {
        this.encPriKeyPath = encPriKeyPath;
    }

    public String getKeyType() {
        return keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getTomcatPath() {
        return tomcatPath;
    }

    public void setTomcatPath(String tomcatPath) {
        this.tomcatPath = tomcatPath;
    }

    public String getRootCertPath() {
        return rootCertPath;
    }

    public void setRootCertPath(String rootCertPath) {
        this.rootCertPath = rootCertPath;
    }

    public String getSignCertPath() {
        return signCertPath;
    }

    public void setSignCertPath(String signCertPath) {
        this.signCertPath = signCertPath;
    }

    public String getEncCertPath() {
        return encCertPath;
    }

    public void setEncCertPath(String encCertPath) {
        this.encCertPath = encCertPath;
    }

    public int getEncKeyIndex() {
        return encKeyIndex;
    }

    public void setEncKeyIndex(int encKeyIndex) {
        this.encKeyIndex = encKeyIndex;
    }

    public String getEncPriKey() {
        return encPriKey;
    }

    public void setEncPriKey(String encPriKey) {
        this.encPriKey = encPriKey;
    }

    public int getHttpsPort() {
        return httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getCryptoType() {
        return cryptoType;
    }

    public void setCryptoType(String cryptoType) {
        this.cryptoType = cryptoType;
    }

    @Override
    public String toString() {
        return "TomcatPropertiesEntry{" +
                "tomcatPath='" + tomcatPath + '\'' +
                ", rootCertPath='" + rootCertPath + '\'' +
                ", signCertPath='" + signCertPath + '\'' +
                ", encCertPath='" + encCertPath + '\'' +
                ", encKeyIndex=" + encKeyIndex +
                ", encPriKey='" + encPriKey + '\'' +
                ", httpsPort=" + httpsPort +
                ", cryptoType='" + cryptoType + '\'' +
                ", keyType='" + keyType + '\'' +
                ", encPriKeyPath='" + encPriKeyPath + '\'' +
                ", signPriKeyPath='" + signPriKeyPath + '\'' +
                '}';
    }
}
