package com.xdja.pki.gmssl.main.sdf.yunhsm.tools;


import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLYunHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmInfoEntry;

public class Main {

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0] == null ||
                !((args[0].equalsIgnoreCase("reset") || args[0].equalsIgnoreCase("init")
                        || args[0].equalsIgnoreCase("testconnect") || args[0].equalsIgnoreCase("getinfo")))) {
            System.out.println("Please insert method, Example: reset. init. testconnect. getinfo");
            System.out.println("                    if use 'reset' you must add yunhsm path , Example: reset /usr/local/yunhsmsdk");
            System.out.println("                    if use 'getinfo' you can add yunhsm path , Example: getinfo /usr/local/yunhsmsdk");
            System.out.println("                    if use 'testconnect' you can add ip and port , Example: testconnect 11.12.85.57  389");
            System.out.println("                    if use 'init'  you should add yunhsm path,ip,port,signPfxPassword,encPfxPassword,signPfxPath,encPfxPath,trustP7bPath");
            System.out.println("                       Example :java -jar yunhsminit.jar init /usr/local/yunhsmsdk 11.12.85.134 5777 bxxmqxiu 3505g3j7 /root/conf/sign_bxxmqxiu.pfx /root/conf/enc_3505g3j7.pfx /root/conf/trust_chain.p7b");
            System.out.println("                    * @param yunhsmPath      密码机安装路径(可以不输入)\n" +
                    "                    * @param ip              密码机服务ip地址\n" +
                    "                    * @param port            密码机服务端口\n" +
                    "                    * @param signPfxPassword 签名证书保护口令\n" +
                    "                    * @param encPfxPassword  加密证书保护口令\n" +
                    "                    * @param signPfxPath     签名证书地址    （pfx格式证书）\n" +
                    "                    * @param encPfxPath      加密证书地址    （pfx格式证书）\n" +
                    "                    * @param trustP7bPath    密码机CA证书链  （p7b格式证书链）");
            return;
        }
        if (args[0].equalsIgnoreCase("reset")) {
            if (args.length == 2) {
                System.out.println("input yunhsm path");
                GMSSLYunHsmUtils.resetYunHsm(args[1]);
            } else if (args.length == 1) {
                System.out.println("without yunhsm path");
                GMSSLYunHsmUtils.resetYunHsm();
            } else {
                System.out.println(" Please add right param");
            }
        }
        if (args[0].equalsIgnoreCase("getinfo")) {
            YunHsmInfoEntry yunHsmInfo;
            if (args.length == 2) {
                System.out.println("input yunhsm path");
                yunHsmInfo = GMSSLYunHsmUtils.getYunHsmInfo(args[1]);
            } else if (args.length == 1) {
                System.out.println("without yunhsm path");
                yunHsmInfo = GMSSLYunHsmUtils.getYunHsmInfo();
            } else {
                System.out.println(" Please add right param");
                return;
            }
            System.out.println(yunHsmInfo.toString());
        }
        if (args[0].equalsIgnoreCase("init")) {
            if (args.length == 9) {
                System.out.println("input yunhsm path");
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLYunHsmUtils.initYunHsmConfigAndTestConnect(args[1], args[2], Integer.valueOf(args[3]), args[4], args[5], args[6], args[7], args[8]);
                System.out.println(yunHsmExceptionEnum.value);
            } else if (args.length == 8) {
                System.out.println("without yunhsm path");
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLYunHsmUtils.initYunHsmConfigAndTestConnect(args[1], Integer.valueOf(args[2]), args[3], args[4], args[5], args[6], args[7]);
                System.out.println(yunHsmExceptionEnum.value);
            } else {
                System.out.println(" Please add right param");
            }
        }
        if (args[0].equalsIgnoreCase("testconnect")) {
            if (args.length == 3) {
                System.out.println("input yunhsm path");
                GMSSLYunHsmUtils.testConnect(args[1], Integer.valueOf(args[2]));
            } else if (args.length == 8) {
                System.out.println("without yunhsm path");
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLYunHsmUtils.testConnect(args[1], Integer.valueOf(args[2]), args[3], args[4], args[5], args[6], args[7]);
                System.out.println(yunHsmExceptionEnum.value);
            }else if  (args.length == 9) {
                System.out.println("input yunhsm path");
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLYunHsmUtils.testConnect(args[1], args[2], Integer.valueOf(args[3]), args[4], args[5], args[6], args[7], args[8]);
                System.out.println(yunHsmExceptionEnum.value);
            }
            else {
                System.out.println(" Please add right param");
            }

        }
    }
}

/************************************************************************************
 * java -jar yunhsminit.jar init /usr/local/yunhsmsdk 11.12.85.134 5777 bxxmqxiu 3505g3j7 /root/conf/sign_bxxmqxiu.pfx /root/conf/enc_3505g3j7.pfx /root/conf/trust_chain.p7b
 ************************************************************************************/