package com.xdja.pki.gmssl.main.yunhsm;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.List;

/**
 * @author sxy
 * @description
 * @date 2019年09月05日 9:25
 **/
public class Main {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public static void main(String[] args) throws Exception {
        Main main = new Main();

        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method Example: genCipherKey, genKeyWithP12");
            System.out.println("genCipherKey $base64SM1Key $index $signPrivateKeyFile $encPrivateKeyFile");
            System.out.println("genKeyWithP12 $base64SM1Key $index $signPrivateKeyP12FilePWD $encPrivateKeyP12File $encPrivateKeyP12FilePWD");
            String os = System.getProperty("os.name");
            System.out.println("System Property is " + os);
            return;
        }
        String base64SM1Key = args[1];
        byte[] sm1Key = GMSSLByteArrayUtils.base64Decode(base64SM1Key);
        String index = args[2];
        switch (args[0]) {
            case "genCipherKey":
                System.out.println("*************** sign ***************");
                byte[] signPrivateKey = main.getKey(args[3]);
                System.out.println("*************** enc ***************");
                byte[] encPrivateKey = main.getKey(args[4]);
                main.generateHSMKey(sm1Key, index, signPrivateKey, encPrivateKey);
                break;
            case "genKeyWithP12":
                System.out.println("*************** sign ***************");
                byte[] signPrivateKeyP12 = main.getKeyWithP12(args[3], args[4].toCharArray());
                System.out.println("*************** enc ***************");
                byte[] encPrivateKeyP12 = main.getKeyWithP12(args[5], args[6].toCharArray());
                main.generateHSMKey(sm1Key, index, signPrivateKeyP12, encPrivateKeyP12);
                break;
            default:
                System.out.println("unSupport ");
        }
    }

    private byte[] getKey(String path) throws IOException {
        byte[] signBytes = readFile(path);
        String signString = new String(signBytes);
        String key = signString.substring(signString.indexOf("S: ") + 3);
        logger.debug("read key s {}", key);
        return GMSSLByteArrayUtils.hexDecode(key);
    }

    private byte[] getKeyWithP12(String path, char[] pw) throws Exception {
        ECPrivateKey privateKey = (ECPrivateKey) GMSSLX509Utils.readPrivateKeyFromP12(path, pw);
        System.out.println(privateKey);

        ECPublicKey publicKey = (ECPublicKey) GMSSLX509Utils.readPublicKeyFromP12(path, pw);
        System.out.println(publicKey);

        byte[] data = "test".getBytes();
        byte[] sign = GMSSLSM2SignUtils.signByBC(privateKey, data);
        boolean b = GMSSLSM2SignUtils.verifyByBC(publicKey, data, sign);
        System.out.println("**** verify sign *** " + b);

        List<X509Certificate> list = GMSSLX509Utils.readCertificatesFromP12(path, pw);
        for (X509Certificate cert: list) {
            System.out.println(cert);
            GMSSLX509Utils.writeCertificateToPem(".", path, cert);
        }
        byte[] x = GMSSLByteArrayUtils.transformByteArrayTo32InHead(publicKey.getW().getAffineX().toByteArray());
        GMSSLByteArrayUtils.printHexBinary(logger, "x", x);
        byte[] y = GMSSLByteArrayUtils.transformByteArrayTo32InHead(publicKey.getW().getAffineY().toByteArray());
        GMSSLByteArrayUtils.printHexBinary(logger, "y", y);
        byte[] s = privateKey.getS().toByteArray();
        GMSSLByteArrayUtils.printHexBinary(logger, "s", s);
        return GMSSLByteArrayUtils.transformByteArrayTo32InHead(s);
    }

    private static byte[] readFile(String path) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(path);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy(fileInputStream, bos);
        return bos.toByteArray();
    }

    private void generateHSMKey(byte[] key, String index, byte[] signPrivateKey, byte[] encPrivateKey) throws Exception {
        System.out.println("*************** generate hsm key sign ***************");
        KeyPair signKeyPair = GMSSLX509Utils.convertSM2KeyPair(signPrivateKey);
        byte[] signCipherKey = generateCipherKey(signKeyPair, key);
        //+iuJjFVfAuDnleCkjw2Iu0HoaaEOelXfNqh45gpfRNQKp3cFvBmnT08o3nPoqo7Yptvgnvugl9FQSr1HC7GiXueLzmwKHmSPmDwftTZHNccsropJ0ttn32AmLLgDBZ0e
        GMSSLByteArrayUtils.printBase64Binary(logger, "signCipherKey", signCipherKey);
        //1acc3827de733efa4e85a91709e4bc61dfcae9c65900213b3da97059b7b4d63b
        byte[] signHash = generateSM3Hash(signCipherKey);
        GMSSLByteArrayUtils.printHexBinary(logger, "signHash", signHash);

        System.out.println("*************** generate hsm key enc ***************");
        KeyPair encKeyPair = GMSSLX509Utils.convertSM2KeyPair(encPrivateKey);
        byte[] encCipherKey = generateCipherKey(encKeyPair, key);
        //cxZfGG2gJKUo6338DhLk4lDESperNeOjHdVoLhCSOTBF9S3GWppfev5kfCfBp62/frsogk3KJNpgS9TFE4W9N+ARldkd2PS9gimqSDuq8xLSjITQ5FNAABIZIcCDE9o3
        GMSSLByteArrayUtils.printBase64Binary(logger, "encCipherKey", encCipherKey);
        //9261d6d92cbe1aac670334b173dd2f7a7433bcb2942461322046733fa8b62e2e
        byte[] encHash = generateSM3Hash(encCipherKey);
        GMSSLByteArrayUtils.printHexBinary(logger, "encHash", encHash);

        String sql = "update t_userkey set c_sign_key_ciphertext=\"$$SIGN_KEY_CIPHER$$\",  c_sign_key_hash=\"$$SIGN_KEY_HASH$$\", c_enc_key_ciphertext=\"$$ENC_KEY_CIPHER$$\", c_enc_key_hash=\"$$ENC_KEY_HASH$$\" where n_index=$$INDEX$$;";
        sql = sql.replace("$$SIGN_KEY_CIPHER$$", GMSSLByteArrayUtils.base64Encode(signCipherKey));
        sql = sql.replace("$$SIGN_KEY_HASH$$", GMSSLByteArrayUtils.hexEncode(signHash));
        sql = sql.replace("$$ENC_KEY_CIPHER$$", GMSSLByteArrayUtils.base64Encode(encCipherKey));
        sql = sql.replace("$$ENC_KEY_HASH$$", GMSSLByteArrayUtils.hexEncode(encHash));
        sql = sql.replace("$$INDEX$$", index);
        System.out.println(sql);
    }

    private byte[] generateSM3Hash(byte[] data) throws SdfSDKException {
        YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
        sdfSDK.init();
        sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3);
        sdfSDK.hashUpdate(data);
        byte[] out = sdfSDK.hashFinal(32);
        sdfSDK.release();
        return out;
    }

    public byte[] generateCipherKey(KeyPair keyPair, byte[] key) throws SdfSDKException {
        YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
        sdfSDK.init();

        ECPublicKey publicKey = (ECPublicKey) keyPair.getPublic();
        ECPrivateKey privateKey = (ECPrivateKey) keyPair.getPrivate();
        byte[] x = GMSSLByteArrayUtils.transformByteArrayTo32InHead(publicKey.getW().getAffineX().toByteArray());
        GMSSLByteArrayUtils.printHexBinary(logger, "x", x);
        byte[] y = GMSSLByteArrayUtils.transformByteArrayTo32InHead(publicKey.getW().getAffineY().toByteArray());
        GMSSLByteArrayUtils.printHexBinary(logger, "y", y);
        byte[] s = GMSSLByteArrayUtils.transformByteArrayTo32InHead(privateKey.getS().toByteArray());
        GMSSLByteArrayUtils.printHexBinary(logger, "s", s);

        long[] handle = sdfSDK.importKey(key);
        byte[] iv = GMSSLByteArrayUtils.hexDecode("00000000000000000000000000000000");

        byte[] c = sdfSDK.encrypt(handle, SdfAlgIdSymmetric.SGD_SM1_ECB, iv, s);
//        GMSSLByteArrayUtils.printBase64Binary(logger, "encrypt c", c);
        sdfSDK.destroyKey(handle);
        sdfSDK.release();

        byte[] cipherKey = new byte[96];
        System.arraycopy(x, 0, cipherKey, 0, 32);
        System.arraycopy(y, 0, cipherKey, 32, 32);
        System.arraycopy(c, 0, cipherKey, 64, 32);
//        GMSSLByteArrayUtils.printBase64Binary(logger, "cipher key c", cipherKey);

        return cipherKey;
    }
}
