/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.yunhsm;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdHash;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        if (args.length == 0 || args[0] == null) {
            System.out.println("Please insert method Example: genCipherKey, genKeyWithP12");
            System.out.println("genCipherKey $base64SM1Key $index $signPrivateKeyFile $encPrivateKeyFile");
            System.out.println("genKeyWithP12 $base64SM1Key $index $signPrivateKeyP12FilePWD $encPrivateKeyP12File $encPrivateKeyP12FilePWD");
            String os = System.getProperty("os.name");
            System.out.println("System Property is " + os);
            return;
        }
        String base64SM1Key = args[1];
        byte[] sm1Key = GMSSLByteArrayUtils.base64Decode((String)base64SM1Key);
        String index = args[2];
        switch (args[0]) {
            case "genCipherKey": {
                System.out.println("*************** sign ***************");
                byte[] signPrivateKey = main.getKey(args[3]);
                System.out.println("*************** enc ***************");
                byte[] encPrivateKey = main.getKey(args[4]);
                main.generateHSMKey(sm1Key, index, signPrivateKey, encPrivateKey);
                break;
            }
            case "genKeyWithP12": {
                System.out.println("*************** sign ***************");
                byte[] signPrivateKeyP12 = main.getKeyWithP12(args[3], args[4].toCharArray());
                System.out.println("*************** enc ***************");
                byte[] encPrivateKeyP12 = main.getKeyWithP12(args[5], args[6].toCharArray());
                main.generateHSMKey(sm1Key, index, signPrivateKeyP12, encPrivateKeyP12);
                break;
            }
            default: {
                System.out.println("unSupport ");
            }
        }
    }

    private byte[] getKey(String path) throws IOException {
        byte[] signBytes = Main.readFile(path);
        String signString = new String(signBytes);
        String key = signString.substring(signString.indexOf("S: ") + 3);
        this.logger.debug("read key s {}", (Object)key);
        return GMSSLByteArrayUtils.hexDecode((String)key);
    }

    private byte[] getKeyWithP12(String path, char[] pw) throws Exception {
        ECPrivateKey privateKey = (ECPrivateKey)GMSSLX509Utils.readPrivateKeyFromP12((String)path, (char[])pw);
        System.out.println(privateKey);
        ECPublicKey publicKey = (ECPublicKey)GMSSLX509Utils.readPublicKeyFromP12((String)path, (char[])pw);
        System.out.println(publicKey);
        byte[] data = "test".getBytes();
        byte[] sign = GMSSLSM2SignUtils.signByBC((PrivateKey)privateKey, (byte[])data);
        boolean b = GMSSLSM2SignUtils.verifyByBC((PublicKey)publicKey, (byte[])data, (byte[])sign);
        System.out.println("**** verify sign *** " + b);
        List list = GMSSLX509Utils.readCertificatesFromP12((String)path, (char[])pw);
        for (X509Certificate cert : list) {
            System.out.println(cert);
            GMSSLX509Utils.writeCertificateToPem((String)".", (String)path, (X509Certificate)cert);
        }
        byte[] x = GMSSLByteArrayUtils.transformByteArrayTo32InHead((byte[])publicKey.getW().getAffineX().toByteArray());
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"x", (byte[])x);
        byte[] y = GMSSLByteArrayUtils.transformByteArrayTo32InHead((byte[])publicKey.getW().getAffineY().toByteArray());
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"y", (byte[])y);
        byte[] s = privateKey.getS().toByteArray();
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"s", (byte[])s);
        return GMSSLByteArrayUtils.transformByteArrayTo32InHead((byte[])s);
    }

    private static byte[] readFile(String path) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(path);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)fileInputStream, (OutputStream)bos);
        return bos.toByteArray();
    }

    private void generateHSMKey(byte[] key, String index, byte[] signPrivateKey, byte[] encPrivateKey) throws Exception {
        System.out.println("*************** generate hsm key sign ***************");
        KeyPair signKeyPair = GMSSLX509Utils.convertSM2KeyPair((byte[])signPrivateKey);
        byte[] signCipherKey = this.generateCipherKey(signKeyPair, key);
        GMSSLByteArrayUtils.printBase64Binary((Logger)this.logger, (String)"signCipherKey", (byte[])signCipherKey);
        byte[] signHash = this.generateSM3Hash(signCipherKey);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"signHash", (byte[])signHash);
        System.out.println("*************** generate hsm key enc ***************");
        KeyPair encKeyPair = GMSSLX509Utils.convertSM2KeyPair((byte[])encPrivateKey);
        byte[] encCipherKey = this.generateCipherKey(encKeyPair, key);
        GMSSLByteArrayUtils.printBase64Binary((Logger)this.logger, (String)"encCipherKey", (byte[])encCipherKey);
        byte[] encHash = this.generateSM3Hash(encCipherKey);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"encHash", (byte[])encHash);
        String sql = "update t_userkey set c_sign_key_ciphertext=\"$$SIGN_KEY_CIPHER$$\",  c_sign_key_hash=\"$$SIGN_KEY_HASH$$\", c_enc_key_ciphertext=\"$$ENC_KEY_CIPHER$$\", c_enc_key_hash=\"$$ENC_KEY_HASH$$\" where n_index=$$INDEX$$;";
        sql = sql.replace("$$SIGN_KEY_CIPHER$$", GMSSLByteArrayUtils.base64Encode((byte[])signCipherKey));
        sql = sql.replace("$$SIGN_KEY_HASH$$", GMSSLByteArrayUtils.hexEncode((byte[])signHash));
        sql = sql.replace("$$ENC_KEY_CIPHER$$", GMSSLByteArrayUtils.base64Encode((byte[])encCipherKey));
        sql = sql.replace("$$ENC_KEY_HASH$$", GMSSLByteArrayUtils.hexEncode((byte[])encHash));
        sql = sql.replace("$$INDEX$$", index);
        System.out.println(sql);
    }

    private byte[] generateSM3Hash(byte[] data) throws SdfSDKException {
        YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
        sdfSDK.init();
        sdfSDK.hashInit(SdfAlgIdHash.SGD_SM3);
        sdfSDK.hashUpdate(data);
        byte[] out = sdfSDK.hashFinal(32);
        sdfSDK.release();
        return out;
    }

    public byte[] generateCipherKey(KeyPair keyPair, byte[] key) throws SdfSDKException {
        YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
        sdfSDK.init();
        ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey privateKey = (ECPrivateKey)keyPair.getPrivate();
        byte[] x = GMSSLByteArrayUtils.transformByteArrayTo32InHead((byte[])publicKey.getW().getAffineX().toByteArray());
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"x", (byte[])x);
        byte[] y = GMSSLByteArrayUtils.transformByteArrayTo32InHead((byte[])publicKey.getW().getAffineY().toByteArray());
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"y", (byte[])y);
        byte[] s = GMSSLByteArrayUtils.transformByteArrayTo32InHead((byte[])privateKey.getS().toByteArray());
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"s", (byte[])s);
        long[] handle = sdfSDK.importKey(key);
        byte[] iv = GMSSLByteArrayUtils.hexDecode((String)"00000000000000000000000000000000");
        byte[] c = sdfSDK.encrypt(handle, SdfAlgIdSymmetric.SGD_SM1_ECB, iv, s);
        sdfSDK.destroyKey(handle);
        sdfSDK.release();
        byte[] cipherKey = new byte[96];
        System.arraycopy(x, 0, cipherKey, 0, 32);
        System.arraycopy(y, 0, cipherKey, 32, 32);
        System.arraycopy(c, 0, cipherKey, 64, 32);
        return cipherKey;
    }
}

