package com.xdja.pki.gmssl.main.yunhsm;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.*;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmType;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.pki.gmssl.x509.utils.bean.HsmInfoEntry;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2021/6/16 9:34
 **/
public class AliYunHsmDemo {
    private static Logger logger = LoggerFactory.getLogger(AliYunHsmDemo.class);
    private static int SM2_KEY_INDEX = 1;
    private static int RSA_KEY_INDEX = 1;
    //    private static int RSA_KEY_INDEX = 21;
    private static String PASSWORD = "a1234567";
    //  private static String PASSWORD = "xdja1234";
//    private static int SM1_INDEX = 11;
//    private static int SM4_INDEX = 12;
//    private static int AES_INDEX = 13;
    private static int SM1_INDEX = 1;
    private static int SM4_INDEX = 1;
    private static int AES_INDEX = 1;

    public static void main(String[] args) {
        //     System.out.println(PASSWORD.getBytes().length);
        //       GMSSLX509Utils.printEnvProperties();
       GMSSLPkiCryptoInit.getHsmInstance();
//        int valueOf = Integer.valueOf(args[0]);
//        if (valueOf == 1) {
//            GMSSLHsmUtils.initYunHsmConfigAndTestConnect("11.12.108.171",9999);
//        }
//        if (valueOf == 2) {
//            GMSSLHsmUtils.testConnect();
//        }
//        if (valueOf == 3) {
//            GMSSLHsmUtils.testConnect("11.12.108.171",9999);
//        }
//        if (valueOf == 4){
//            String confPath = GMSSLHsmUtils.getConfPath(true);
//            System.out.println(confPath);
//        }
//        if (valueOf == 5){
            HsmInfoEntry jntaDeviceInfo = GMSSLHsmUtils.getConfigInfo();
            System.out.println(jntaDeviceInfo);
//        }


//        //随机数
//        testGenerateRandom();
//        //SM1
//        testSM1ECB();
//        testSM1ECBPkcs7();
//        testSM1CBC();
//        testSM1CBCPkcs7();
//        //SM4
//        testSM4Ecb();
//        testSM4EcbPkcs7();
//        testSM4Cbc();
//        testSM4CbcPkcs7();
//        //AES
//        testAes128();
//        testAes128Pkcs7();
        //SM2
//        testSm2Generate();
//        testSM2Sign();
//        testSM2Encyrpt();
//        testSm2Export();
        /**
         testSm2Generate();
         //SM3
         testSM3Hash();
         //SHA1
         testSha1Hash();
         //SHA256
         testSha256Hash();
         //RSA
         testRsaGenerate2048();
         //     testRsaExport();
         // rsaSignWithAlg(RSA_KEY_INDEX, GMSSLSignatureAlgorithm.SHA256_WITH_RSA);
         // rsaSignWithAlg(RSA_KEY_INDEX, GMSSLSignatureAlgorithm.SHA1_WITH_RSA);
         //kek
         testSM1Kek();
         testSM4Kek();
         //        testAes128Kek();**/
    }

    public static void testGenerateRandom() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test generate random <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = GMSSLRandomUtils.generateRandom(16);
            logger.info("random {}", data);
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test generate random success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test generate random error", e);
            System.exit(0);
        }
    }


    public static void testSM1Kek() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 kek <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLKeKUtils.generateKek(SM1_INDEX, SdfAlgIdSymmetric.SGD_SM1_ECB);
            GMSSLByteArrayUtils.printHexBinary(null, "key", key);
            byte[] encrypt = GMSSLSM1ECBEncryptUtils.encryptWithKek(key, SM1_INDEX, SdfAlgIdSymmetric.SGD_SM1_ECB, key, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, "encrypt", encrypt);
            byte[] decrypt = GMSSLSM1ECBEncryptUtils.decryptWithKek(key, SM1_INDEX, SdfAlgIdSymmetric.SGD_SM1_ECB, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, "decrypt", decrypt);
            logger.info("key {}", Hex.toHexString(key));
            logger.info("encrypt {}", Hex.toHexString(encrypt));
            logger.info("decrypt {}", Hex.toHexString(decrypt));
            boolean b = Arrays.equals(key, decrypt);
            logger.info("assert {}", b);
            if (!b) {
                logger.error("test SM1 kek error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1  kek success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test SM1 kek error", e);
            System.exit(0);
        }
    }

    public static void testSM4Kek() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 kek <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLKeKUtils.generateKek(SM4_INDEX, SdfAlgIdSymmetric.SGD_SM4_ECB);
            GMSSLByteArrayUtils.printHexBinary(null, "key", key);
            byte[] encrypt = GMSSLSM4ECBEncryptUtils.encryptWithKek(key, SM4_INDEX, SdfAlgIdSymmetric.SGD_SM1_ECB, key, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, "encrypt", encrypt);
            byte[] decrypt = GMSSLSM4ECBEncryptUtils.decryptWithKek(key, SM4_INDEX, SdfAlgIdSymmetric.SGD_SM1_ECB, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, "decrypt", decrypt);
            logger.info("key {}", Hex.toHexString(key));
            logger.info("encrypt {}", Hex.toHexString(encrypt));
            logger.info("decrypt {}", Hex.toHexString(decrypt));
            boolean b = Arrays.equals(key, decrypt);
            logger.info("assert {}", b);
            if (!b) {
                logger.error("test SM4 kek error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4  kek success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test SM4 kek error", e);
            System.exit(0);
        }
    }

    public static void testAes128Kek() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test aes128 kek <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLKeKUtils.generateKek(AES_INDEX, SdfAlgIdSymmetric.SGD_AES_ECB);
            GMSSLByteArrayUtils.printHexBinary(null, "key", key);
            byte[] encrypt = GMSSLAES128ECBEncryptUtils.encryptWithKek(key, AES_INDEX, SdfAlgIdSymmetric.SGD_SM1_ECB, key, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, "encrypt", encrypt);
            byte[] decrypt = GMSSLAES128ECBEncryptUtils.decryptWithKek(key, AES_INDEX, SdfAlgIdSymmetric.SGD_SM1_ECB, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(null, "decrypt", decrypt);
            logger.info("key {}", Hex.toHexString(key));
            logger.info("encrypt {}", Hex.toHexString(encrypt));
            logger.info("decrypt {}", Hex.toHexString(decrypt));
            boolean b = Arrays.equals(key, decrypt);
            logger.info("assert {}", b);
            if (!b) {
                logger.error("test aes128 kek error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test aes128  kek success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test aes128 kek error", e);
            System.exit(0);
        }
    }


    public static void testSM1ECB() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 ecb <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = Hex.decode("11123456789abcdef123456789abcdef");
            byte[] encrypt = GMSSLSM1ECBEncryptUtils.encrypt(key, key, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            byte[] decrypt1 = GMSSLSM1ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            boolean equals = Arrays.equals(key, decrypt1);
            logger.info("decrypt {}", decrypt1);
            logger.info("encrypt {}", encrypt);
            logger.info("key {}", key);
            logger.info("assert {}", encrypt);
            if (!equals) {
                logger.error("testSM1  error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1  ecb success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("testSM1  error", e);
            System.exit(0);
        }
    }


    public static void testSM1ECBPkcs7() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 ecb pkcs7 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = Hex.decode("11123456789abcdef123456789abcdef");
            byte[] encrypt = GMSSLSM1ECBEncryptUtils.encrypt(key, key, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            byte[] decrypt1 = GMSSLSM1ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            boolean equals = Arrays.equals(key, decrypt1);
            logger.info("decrypt {}", decrypt1);
            logger.info("encrypt {}", encrypt);
            logger.info("key {}", key);
            logger.info("assert {}", encrypt);
            if (!equals) {
                logger.error("testSM1  error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 ecb pkcs7 success<<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("testSM1  error", e);
            System.exit(0);
        }
    }


    public static void testSM1CBC() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 cbc <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = Hex.decode("11123456789abcdef123456789abcdef");
            byte[] encrypt = GMSSLSM1CBCEncryptUtils.encrypt(key, key, key, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            byte[] decrypt1 = GMSSLSM1CBCEncryptUtils.decrypt(key, encrypt, key, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            boolean equals = Arrays.equals(key, decrypt1);
            logger.info("decrypt {}", decrypt1);
            logger.info("encrypt {}", encrypt);
            logger.info("key {}", key);
            logger.info("assert {}", encrypt);
            if (!equals) {
                logger.error("testSM1  error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1  cbc success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("testSM1  error", e);
            System.exit(0);
        }
    }


    public static void testSM1CBCPkcs7() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1 cbc pkcs7 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = Hex.decode("11123456789abcdef123456789abcdef");
            byte[] encrypt = GMSSLSM1CBCEncryptUtils.encrypt(key, key, key, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            byte[] decrypt1 = GMSSLSM1CBCEncryptUtils.decrypt(key, encrypt, key, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            boolean equals = Arrays.equals(key, decrypt1);
            logger.info("decrypt {}", decrypt1);
            logger.info("encrypt {}", encrypt);
            logger.info("key {}", key);
            logger.info("assert {}", encrypt);
            if (!equals) {
                logger.error("testSM1  error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm1  cbc pkcs7 success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("testSM1  error", e);
            System.exit(0);
        }
    }


    public static void testSM2Sign() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test SM2Sign <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = "test sm2 sign ".getBytes();
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(SM2_KEY_INDEX, PASSWORD);
            PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware(SM2_KEY_INDEX, GMSSLECKeyUtils.SM2p256, false);
            byte[] sign = GMSSLECSignUtils.sign(sdfPrivateKey, data, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
            boolean verify = GMSSLECSignUtils.verify(publicKey, data, sign, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
            GMSSLPkiCryptoInit.getBCInstance();
            boolean verify1 = GMSSLECSignUtils.verify(publicKey, data, sign, null, GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName());
            logger.info("密码机签名 {} ,", Hex.toHexString(sign));
            logger.info("密码机验签结果 {} ,", verify);
            logger.info("BC验签结果 {} ,", verify1);
            if (!verify || !verify1) {
                logger.error("test SM2Sign error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test SM2Sign  success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test SM2Sign", e);
            System.exit(0);
        }
    }


    public static void testSM2Encyrpt() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm2 encyrpt <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = "test sm2 encrypt ".getBytes();
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(SM2_KEY_INDEX, PASSWORD);
            PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware(SM2_KEY_INDEX, GMSSLECKeyUtils.SM2p256, true);
            byte[] encrypt = GMSSLSM2EncryptUtils.encrypt(publicKey, data);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] encrypt1 = GMSSLSM2EncryptUtils.encrypt(publicKey, data);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] decrypt = GMSSLSM2EncryptUtils.decrypt(sdfPrivateKey, encrypt);
            byte[] decrypt1 = GMSSLSM2EncryptUtils.decrypt(sdfPrivateKey, encrypt1);
            logger.info("加密数据原文 {}", Hex.toHexString(data));
            logger.info("密码机加密后数据 {}", Hex.toHexString(encrypt));
            logger.info("BC加密后数据 {}", Hex.toHexString(encrypt1));
            logger.info("密码机解密后数据 {}", Hex.toHexString(decrypt));
            logger.info("密码机解密BC加密后数据 {}", Hex.toHexString(decrypt1));
            boolean b1 = Arrays.equals(data, decrypt);
            boolean b2 = Arrays.equals(data, decrypt1);
            if (!b1 || !b2) {
                logger.error("test SM2Encyrpt error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm2 encyrpt success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test sm2 encyrpt error", e);
            System.exit(0);
        }
    }


    public static void testSM3Hash() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm3 digest  <<<<<<<<<<<<<<<<<<<<<<");
            String data = GMSSLByteArrayUtils.base64Encode("12352355345345334534534535236746545635345354345354".getBytes());
            String base64Hash = "iwbxq6mUNdJxi7VrDRU1j3iaZich6fXaK41Qc8RVl00=";
            String digestByBC = GMSSLSM3DigestUtils.digestByBC(data);
            String digestByYun = GMSSLSM3DigestUtils.digestByYunhsm(data);
            logger.info("BC经过SM3摘要后的数据为{}", digestByBC);
            logger.info("密码机经过SM3摘要后的数据为{}", digestByYun);
            logger.info("SM3摘要后的数据为{}", base64Hash);
            if (!digestByBC.equalsIgnoreCase(base64Hash) || !digestByBC.equalsIgnoreCase(digestByYun)) {
                logger.error("test SM3 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm3 digest success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test sm3 digest  error", e);
            System.exit(0);
        }
    }

    public static void testSha1Hash() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sha1 digest  <<<<<<<<<<<<<<<<<<<<<<");
            String data = GMSSLByteArrayUtils.base64Encode("12352355345345334534534535236746545635345354345354".getBytes());
            String digestByBC = GMSSLSHA1DigestUtils.digestByBC(data);
            String digestByYun = GMSSLSHA1DigestUtils.digestByYunHsm(data);
            logger.info("BC经过SHA1摘要后的数据为{}", digestByBC);
            logger.info("密码机经过SHA1摘要后的数据为{}", digestByYun);
            boolean b = digestByBC.equalsIgnoreCase(digestByYun);
            logger.info("assert {}", b);
            if (!b) {
                logger.error("test SHA1 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sha1 digest success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test sm3 digest  error", e);
            System.exit(0);
        }
    }

    public static void testSha256Hash() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test SHA256 digest  <<<<<<<<<<<<<<<<<<<<<<");
            String data = GMSSLByteArrayUtils.base64Encode("12352355345345334534534535236746545635345354345354".getBytes());
            String digestByBC = GMSSLSHA256DigestUtils.digestByBC(data);
            String digestByYun = GMSSLSHA256DigestUtils.digestByYunHsm(data);
            logger.info("BC经过SHA256摘要后的数据为{}", digestByBC);
            logger.info("密码机经过SHA256摘要后的数据为{}", digestByYun);
            boolean b = digestByBC.equalsIgnoreCase(digestByYun);
            logger.info("assert {}", b);
            if (!b) {
                logger.error("test SHA256 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test SHA256 digest success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test SHA256 digest  error", e);
            System.exit(0);
        }
    }


    public static void testSM4Ecb() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 ecb <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
            byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
            byte[] iv = GMSSLByteArrayUtils.hexDecode("681edf34d206965e86b3e94f536e4212");
            byte[] encrypt = GMSSLSM4ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            byte[] decrypt = GMSSLSM4ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] decryptByBc = GMSSLSM4ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            boolean b1 = Arrays.equals(decrypt, decryptByBc);
            boolean b2 = Arrays.equals(data, decryptByBc);
            logger.info("encrypt by hsm {}", Hex.toHexString(encrypt));
            logger.info("decrypt by hsm {}", Hex.toHexString(decrypt));
            logger.info("decrypt by bc {}", Hex.toHexString(decryptByBc));
            logger.info("assert decrypt  decryptByBc{}", b1);
            logger.info("assert data  decryptByBc", b2);
            if (!b1 || !b2) {
                logger.error("test sm4 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 ecb success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test sm4 ecb error", e);
            System.exit(0);
        }
    }

    public static void testSM4EcbPkcs7() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 pkcs7 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
            byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
            byte[] iv = GMSSLByteArrayUtils.hexDecode("681edf34d206965e86b3e94f536e4212");
            byte[] encrypt = GMSSLSM4ECBEncryptUtils.encrypt(key, data, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            byte[] decrypt = GMSSLSM4ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] decryptByBc = GMSSLSM4ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            boolean b1 = Arrays.equals(decrypt, decryptByBc);
            boolean b2 = Arrays.equals(data, decryptByBc);
            logger.info("encrypt by hsm {}", Hex.toHexString(encrypt));
            logger.info("decrypt by hsm {}", Hex.toHexString(decrypt));
            logger.info("decrypt by bc {}", Hex.toHexString(decryptByBc));
            logger.info("assert decrypt  decryptByBc{}", b1);
            logger.info("assert data  decryptByBc", b2);
            if (!b1 || !b2) {
                logger.error("test sm4 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 pkcs7 success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test sm4 pkcs7  error", e);
            System.exit(0);
        }
    }


    public static void testSM4Cbc() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 cbc  <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
            byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
            byte[] iv = GMSSLByteArrayUtils.hexDecode("681edf34d206965e86b3e94f536e4212");
            byte[] encrypt = GMSSLSM4CBCEncryptUtils.encrypt(key, data, iv, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            byte[] decrypt = GMSSLSM4CBCEncryptUtils.decrypt(key, encrypt, iv, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] decryptByBc = GMSSLSM4CBCEncryptUtils.decrypt(key, encrypt, iv, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            boolean b1 = Arrays.equals(decrypt, decryptByBc);
            boolean b2 = Arrays.equals(data, decryptByBc);
            logger.info("encrypt by hsm {}", Hex.toHexString(encrypt));
            logger.info("decrypt by hsm {}", Hex.toHexString(decrypt));
            logger.info("decrypt by bc {}", Hex.toHexString(decryptByBc));
            logger.info("assert decrypt  decryptByBc{}", b1);
            logger.info("assert data  decryptByBc", b2);
            if (!b1 || !b2) {
                logger.error("test sm4 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 cbc success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test sm4 cbc error", e);
            System.exit(0);
        }
    }

    public static void testSM4CbcPkcs7() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 cbc pkcs7 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
            byte[] data = GMSSLByteArrayUtils.hexDecode("0123456789abcdeffedcba9876543210");
            byte[] iv = GMSSLByteArrayUtils.hexDecode("681edf34d206965e86b3e94f536e4212");
            byte[] encrypt = GMSSLSM4CBCEncryptUtils.encrypt(key, data, iv, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            byte[] decrypt = GMSSLSM4CBCEncryptUtils.decrypt(key, encrypt, iv, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] decryptByBc = GMSSLSM4CBCEncryptUtils.decrypt(key, encrypt, iv, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            boolean b1 = Arrays.equals(decrypt, decryptByBc);
            boolean b2 = Arrays.equals(data, decryptByBc);
            logger.info("encrypt by hsm {}", Hex.toHexString(encrypt));
            logger.info("decrypt by hsm {}", Hex.toHexString(decrypt));
            logger.info("decrypt by bc {}", Hex.toHexString(decryptByBc));
            logger.info("assert decrypt  decryptByBc{}", b1);
            logger.info("assert data  decryptByBc", b2);
            if (!b1 || !b2) {
                logger.error("test sm4 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test sm4 cbc pkcs7 cbcsuccess <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test sm4 cbc pkcs7 error", e);
            System.exit(0);
        }
    }


    public static void testAes128() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test Aes128  <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLRandomUtils.generateRandom(16);
            GMSSLByteArrayUtils.printHexBinary(logger, "key", key);
            byte[] encrypt = GMSSLAES128ECBEncryptUtils.encrypt(key, key, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            GMSSLByteArrayUtils.printHexBinary(logger, "encrypt", encrypt);
            byte[] decryptByHsm = GMSSLAES128ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            GMSSLByteArrayUtils.printHexBinary(logger, "decryptByHsm", decryptByHsm);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] decryptByBC = GMSSLAES128ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.NoPadding);
            GMSSLByteArrayUtils.printHexBinary(logger, "decryptByBC", decryptByBC);
            boolean b = Arrays.equals(key, decryptByBC);
            boolean b1 = Arrays.equals(key, decryptByHsm);
            logger.info("assert key decryptByBC {}", b);
            logger.info("assert key decryptByHsm {}", b1);
            if (!b || !b1) {
                logger.error("test aes128 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test Aes128 success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test Aes128  error", e);
            System.exit(0);
        }
    }

    public static void testAes128Pkcs7() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test Aes128 pkcs7 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] key = GMSSLRandomUtils.generateRandom(16);
            GMSSLByteArrayUtils.printHexBinary(logger, "key", key);
            byte[] encrypt = GMSSLAES128ECBEncryptUtils.encrypt(key, key, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(logger, "encrypt", encrypt);
            byte[] decryptByHsm = GMSSLAES128ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(logger, "decryptByHsm", decryptByHsm);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] decryptByBC = GMSSLAES128ECBEncryptUtils.decrypt(key, encrypt, SdfSymmetricKeyParameters.PaddingType.PKCS7Padding);
            GMSSLByteArrayUtils.printHexBinary(logger, "decryptByBC", decryptByBC);
            boolean b = Arrays.equals(key, decryptByBC);
            boolean b1 = Arrays.equals(key, decryptByHsm);
            logger.info("assert key decryptByBC {}", b);
            logger.info("assert key decryptByHsm {}", b1);
            if (!b || !b1) {
                logger.error("test aes128 error");
                System.exit(0);
            }
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test Aes128 pkcs7 success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("test Aes128 pkcs7 error", e);
            System.exit(0);
        }
    }


    public static void testRsaGenerate2048() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test rsaGenerate2048 <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            KeyPair keyPair = GMSSLRSAKeyUtils.generateKeyPairByYunHsm(2048);
            logger.info("keypair private {}", keyPair.getPrivate());
            logger.info("keypair public {}", keyPair.getPublic());
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test rsaGenerate2048 success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("rsaGenerate2048 error", e);
        }
    }


    public static void rsaSignWithAlg(int index, GMSSLSignatureAlgorithm algorithm) {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test rsa sign {} <<<<<<<<<<<<<<<<<<<<<<", algorithm);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = Hex.decode("12345678900123456789");
            byte[] signByHsm = GMSSLRSASignUtils.sign(GMSSLECKeyUtils.genSdfPrivateKey(index, PASSWORD), data, algorithm.getSigAlgName());
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            PublicKey signPublic = GMSSLRSAKeyUtils.getPublicKeyFromHardware(index, false);
            boolean b = GMSSLRSASignUtils.verify(signPublic, data, signByHsm, algorithm.getSigAlgName());
            GMSSLPkiCryptoInit.getBCInstance();
            boolean b1 = GMSSLRSASignUtils.verify(signPublic, data, signByHsm, algorithm.getSigAlgName());
            logger.info("RSA Sign By Hsm {}", Hex.toHexString(signByHsm));
            logger.info("RSA verify By Hsm {}", b);
            logger.info("RSA verify By BC {}", b1);
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test rsa sign {} success <<<<<<<<<<<<<<<<<<<<<<", algorithm);
            if (!b || !b1) {
                logger.error("RSA sign {} error", algorithm);
            }
        } catch (Exception e) {
            logger.error("RSA sign with alg error", e);
        }
    }


    public static void testSm2Generate() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test generate sm2 keypair <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair(GMSSLECKeyUtils.SM2p256);
            logger.info("keypair private {}", keyPair.getPrivate());
            logger.info("keypair public {}", keyPair.getPublic());
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test generate sm2 keypair success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("generate sm2 key pair error", e);
        }
    }

    public static void testSm2Export() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test export sm2 key  <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            PublicKey encryptKey = GMSSLECKeyUtils.getPublicKeyFromHardware(SM2_KEY_INDEX, GMSSLECKeyUtils.SM2p256, true);
            PublicKey signKey = GMSSLECKeyUtils.getPublicKeyFromHardware(SM2_KEY_INDEX, GMSSLECKeyUtils.SM2p256, false);
            logger.info("encryptKey public {}", encryptKey);
            logger.info("signKey public {}", signKey);
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test export sm2 key  success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("export sm2 key  error", e);
        }
    }

    public static void testRsaExport() {
        try {
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test export rsa key  <<<<<<<<<<<<<<<<<<<<<<");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            PublicKey encryptKey = GMSSLRSAKeyUtils.getPublicKeyFromHardware(RSA_KEY_INDEX, true);
            PublicKey signKey = GMSSLRSAKeyUtils.getPublicKeyFromHardware(RSA_KEY_INDEX, false);
            logger.info("encryptKey public {}", encryptKey);
            logger.info("signKey public {}", signKey);
            logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>test export rsa key  success <<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("export rsa key  error", e);
        }
    }

}
