/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.main.yunhsm;

import com.xdja.hsm.api.bean.EccCipherEx;
import com.xdja.hsm.api.bean.EccPublicKeyEx;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECIESEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA384DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSHA512DigestUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdAsymmetric;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnection;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnectionProviderImpl;
import com.xdja.pki.gmssl.x509.utils.GMSSLCRLUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLP10Utils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NistTest {
    private static Logger logger = LoggerFactory.getLogger(NistTest.class);
    private static int nist384Index = 7;
    private static int nist256Index = 6;
    private static int nist521Index = 8;
    private static int BITS_384 = 384;
    private static int BITS_521 = 521;
    private static String password = "xdja1234";

    public static void main(String[] args) {
        Integer i = Integer.valueOf(args[0]);
        switch (i) {
            case 1: {
                NistTest.digest384();
                break;
            }
            case 2: {
                NistTest.digest512();
                break;
            }
            case 3: {
                NistTest.exportKey(nist384Index, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 4: {
                NistTest.exportKey(nist521Index, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 5: {
                NistTest.generateKeyPair(GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 6: {
                NistTest.generateKeyPair(GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 7: {
                NistTest.testAll();
                break;
            }
            case 8: {
                NistTest.signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 9: {
                NistTest.signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 10: {
                NistTest.signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 11: {
                NistTest.signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 12: {
                NistTest.signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 13: {
                NistTest.signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 14: {
                NistTest.veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 15: {
                NistTest.veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 16: {
                NistTest.veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 17: {
                NistTest.veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 18: {
                NistTest.veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 19: {
                NistTest.veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 20: {
                NistTest.encryptByHsm(nist521Index, BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 21: {
                NistTest.encryptByHsm(nist384Index, BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 22: {
                NistTest.decryptByHsm(nist521Index, BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 23: {
                NistTest.decryptByHsm(nist521Index, BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 24: {
                NistTest.generateCert(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 25: {
                NistTest.generateCert(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 26: {
                NistTest.generateCRL(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 27: {
                NistTest.generateCRL(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 28: {
                NistTest.generateP10(nist521Index, GMSSLECKeyUtils.NISTp521, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521);
                break;
            }
            case 29: {
                NistTest.generateP10(nist384Index, GMSSLECKeyUtils.NISTp384, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384);
                break;
            }
            case 80: {
                NistTest.signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 81: {
                NistTest.signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 82: {
                NistTest.veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 83: {
                NistTest.veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 84: {
                NistTest.generateCert(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 85: {
                NistTest.generateCert(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 86: {
                NistTest.generateCRL(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            }
            case 87: {
                NistTest.generateCRL(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            }
            case 88: {
                NistTest.generateP10(nist521Index, GMSSLECKeyUtils.NISTp521, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521);
                break;
            }
            case 89: {
                NistTest.generateP10(nist384Index, GMSSLECKeyUtils.NISTp384, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384);
                break;
            }
            case 90: {
                NistTest.signByHsm(nist256Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), 256, GMSSLECKeyUtils.NISTp256);
                break;
            }
            case 91: {
                NistTest.signByHsm(nist256Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), 256, GMSSLECKeyUtils.NISTp256);
                break;
            }
            case 92: {
                NistTest.veryByHsm(nist256Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), 256, GMSSLECKeyUtils.NISTp256);
                break;
            }
            case 93: {
                NistTest.veryByHsm(nist256Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), 256, GMSSLECKeyUtils.NISTp256);
                break;
            }
        }
    }

    private static void testAll() {
        NistTest.digest384();
        NistTest.digest512();
        NistTest.exportKey(nist384Index, GMSSLECKeyUtils.NISTp384);
        NistTest.exportKey(nist521Index, GMSSLECKeyUtils.NISTp521);
        NistTest.generateKeyPair(GMSSLECKeyUtils.NISTp384);
        NistTest.generateKeyPair(GMSSLECKeyUtils.NISTp521);
        NistTest.signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.generateCert(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.generateCert(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.generateCRL(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.generateCRL(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.generateP10(nist521Index, GMSSLECKeyUtils.NISTp521, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521);
        NistTest.generateP10(nist384Index, GMSSLECKeyUtils.NISTp384, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384);
        NistTest.signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.generateCert(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.generateCert(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.generateCRL(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
        NistTest.generateCRL(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
        NistTest.generateP10(nist521Index, GMSSLECKeyUtils.NISTp521, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521);
        NistTest.generateP10(nist384Index, GMSSLECKeyUtils.NISTp384, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384);
    }

    public static void testEncrypt(SdfAlgIdAsymmetric sdfAlgIdAsymmetric, String curveName, int bits, int index) throws Exception {
        GMSSLPkiCryptoInit.getBCInstance();
        KeyPair keyPair521 = GMSSLECKeyUtils.generateECKeyPair((String)curveName);
        byte[] data = Hex.decode((String)"12345678123456781234567812345678");
        byte[] encrypt = GMSSLECIESEncryptUtils.encrypt((PublicKey)keyPair521.getPublic(), (byte[])data);
        byte[] decrypt = GMSSLECIESEncryptUtils.decrypt((PrivateKey)keyPair521.getPrivate(), (byte[])encrypt);
        GMSSLByteArrayUtils.printHexBinary(null, (String)"data", (byte[])data);
        GMSSLByteArrayUtils.printHexBinary(null, (String)"encrypt", (byte[])encrypt);
        GMSSLByteArrayUtils.printHexBinary(null, (String)"decrypt", (byte[])decrypt);
        GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
        EccCipherEx pucEncData = new EccCipherEx();
        EccPublicKeyEx pucPublicKey = new EccPublicKeyEx();
        BCECPublicKey aPublic = (BCECPublicKey)keyPair521.getPublic();
        pucPublicKey.setBits(bits);
        pucPublicKey.setX(GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])aPublic.getW().getAffineX().toByteArray(), (int)128));
        pucPublicKey.setY(GMSSLByteArrayUtils.fillByteArrayWithZeroInHead((byte[])aPublic.getW().getAffineY().toByteArray(), (int)128));
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().externalEncryptEccEx(connection.getSes()[0], sdfAlgIdAsymmetric.getId(), pucPublicKey, data, data.length, pucEncData);
        System.out.println(ret);
        GMSSLByteArrayUtils.printHexBinary(null, (String)"x", (byte[])pucEncData.getX());
        GMSSLByteArrayUtils.printHexBinary(null, (String)"y", (byte[])pucEncData.getY());
        GMSSLByteArrayUtils.printHexBinary(null, (String)"m", (byte[])pucEncData.getM());
        GMSSLByteArrayUtils.printHexBinary(null, (String)"c", (byte[])pucEncData.getC());
        System.out.println(ret);
        byte[] pucData = new byte[data.length];
        int[] puiDataLength = new int[]{data.length};
        HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        ret = connection.getSdfApi().internalDecryptEccEx(connection.getSes()[0], index, sdfAlgIdAsymmetric.getId(), pucEncData, pucData, puiDataLength);
    }

    private static void digest384() {
        try {
            logger.debug("#####################digest 384  test start ########################");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = Hex.decode((String)"1234");
            byte[] digestByYunHsm = GMSSLSHA384DigestUtils.digest((byte[])data);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] digestByBc = GMSSLSHA384DigestUtils.digest((byte[])data);
            GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"digestByYunHsm", (byte[])digestByYunHsm);
            GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"digestByBc", (byte[])digestByBc);
            if (Arrays.areEqual((byte[])digestByBc, (byte[])digestByYunHsm)) {
                logger.debug("#####################digest 384  test success ########################");
            } else {
                logger.error("#####################digest 384  test error ########################");
                System.exit(0);
            }
        }
        catch (Exception e) {
            logger.error("#####################digest 384  test error ########################", (Throwable)e);
            System.exit(0);
        }
    }

    private static void digest512() {
        try {
            logger.debug("#####################digest 512  test start ########################");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = Hex.decode((String)"1234");
            byte[] digestByYunHsm = GMSSLSHA512DigestUtils.digest((byte[])data);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] digestByBc = GMSSLSHA512DigestUtils.digest((byte[])data);
            GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"digestByYunHsm", (byte[])digestByYunHsm);
            GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"digestByBc", (byte[])digestByBc);
            if (Arrays.areEqual((byte[])digestByBc, (byte[])digestByYunHsm)) {
                logger.debug("#####################digest 512  test success ########################");
            } else {
                logger.error("#####################digest 512  test error ########################");
                System.exit(0);
            }
        }
        catch (Exception e) {
            logger.error("#####################digest 512  test error ########################", (Throwable)e);
            System.exit(0);
        }
    }

    private static void exportKey(int index, String stdName) {
        try {
            logger.debug("#####################export key  {} test start ########################", (Object)stdName);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            PublicKey encKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)stdName, (boolean)true);
            logger.debug("EC {} encrypt key is {} ", (Object)stdName, (Object)encKey);
            PublicKey signKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)stdName, (boolean)false);
            logger.debug("EC {} sign key is {} ", (Object)stdName, (Object)signKey);
            logger.debug("#####################export key  {} test success ########################", (Object)stdName);
        }
        catch (Exception e) {
            logger.error("#####################export key  {} test  error ########################", (Object)stdName, (Object)e);
            System.exit(0);
        }
    }

    private static void generateKeyPair(String stdName) {
        try {
            logger.debug("#####################generateKeyPair  {} test start ########################", (Object)stdName);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair((String)stdName);
            logger.debug("EC {}  keypair public is {} ", (Object)stdName, (Object)keyPair.getPublic());
            logger.debug("EC {} keypair private is {} ", (Object)stdName, (Object)keyPair.getPrivate());
            logger.debug("#####################generateKeyPair  {} test success ########################", (Object)stdName);
        }
        catch (Exception e) {
            logger.error("#####################generateKeyPair  {} test  error ########################", (Object)stdName, (Object)e);
            System.exit(0);
        }
    }

    private static void signByHsm(int index, String signAlgName, int bits, String stdName) {
        try {
            logger.debug("#####################sign  curve {} ,signAlgName {} test start ########################", (Object)stdName, (Object)signAlgName);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, password);
            byte[] data = Hex.decode((String)"1234");
            byte[] sign = GMSSLECSignUtils.sign((PrivateKey)sdfPrivateKey, (byte[])data, null, (String)signAlgName, (int)bits);
            PublicKey signKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)stdName, (boolean)false);
            boolean verifyByHsm = GMSSLECSignUtils.verify((PublicKey)signKey, (byte[])data, (byte[])sign, null, (String)signAlgName, (int)bits);
            GMSSLPkiCryptoInit.getBCInstance();
            boolean verifyByBc = GMSSLECSignUtils.verify((PublicKey)signKey, (byte[])data, (byte[])sign, null, (String)signAlgName, (int)bits);
            logger.debug("verifyByHsm {}   ", (Object)verifyByHsm);
            logger.debug("verifyByBc {}   ", (Object)verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################sign  curve {} ,signAlgName {} test error ########################", (Object)stdName, (Object)signAlgName);
                System.exit(0);
            }
            logger.debug("#####################sign  curve {} ,signAlgName {} test success ########################", (Object)stdName, (Object)signAlgName);
        }
        catch (Exception e) {
            logger.error("#####################sign  curve {} ,signAlgName {} test error ########################", new Object[]{stdName, signAlgName, e});
            System.exit(0);
        }
    }

    private static void veryByHsm(int index, String signAlgName, int bits, String stdName) {
        try {
            GMSSLPkiCryptoInit.getBCInstance();
            logger.debug("#####################verify curve {} ,signAlgName {} test start ########################", (Object)stdName, (Object)signAlgName);
            KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair((String)stdName);
            byte[] data = Hex.decode((String)"1234");
            byte[] sign = GMSSLECSignUtils.sign((PrivateKey)keyPair.getPrivate(), (byte[])data, null, (String)signAlgName, (int)bits);
            boolean verifyByBc = GMSSLECSignUtils.verify((PublicKey)keyPair.getPublic(), (byte[])data, (byte[])sign, null, (String)signAlgName, (int)bits);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            boolean verifyByHsm = GMSSLECSignUtils.verify((PublicKey)keyPair.getPublic(), (byte[])data, (byte[])sign, null, (String)signAlgName, (int)bits);
            logger.debug("verifyByHsm {}   ", (Object)verifyByHsm);
            logger.debug("verifyByBc {}   ", (Object)verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################verify curve {} ,signAlgName {} test error ########################", (Object)stdName, (Object)signAlgName);
                System.exit(0);
            }
            logger.debug("#####################verify curve {} ,signAlgName {} test success ########################", (Object)stdName, (Object)signAlgName);
        }
        catch (Exception e) {
            logger.error("#####################verify curve {} ,signAlgName {} test error ########################", new Object[]{stdName, signAlgName, e});
            System.exit(0);
        }
    }

    private static void decryptByHsm(int index, int bits, String stdName) {
        try {
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            logger.debug("#####################decryptByHsm curve {} test start ########################", (Object)stdName);
            PublicKey encKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)stdName, (boolean)true);
            byte[] data = Hex.decode((String)"1234");
            byte[] encryptByHsm = GMSSLECIESEncryptUtils.encrypt((PublicKey)encKey, (byte[])data, (int)bits);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] encryptByBc = GMSSLECIESEncryptUtils.encrypt((PublicKey)encKey, (byte[])data, (int)bits);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] decryptBcByHsm = GMSSLECIESEncryptUtils.decrypt((PrivateKey)new SdfPrivateKey(index, password), (byte[])encryptByBc, (int)bits);
            byte[] decryptHsmByHsm = GMSSLECIESEncryptUtils.decrypt((PrivateKey)new SdfPrivateKey(index, password), (byte[])encryptByHsm, (int)bits);
            if (!(Arrays.areEqual((byte[])decryptBcByHsm, (byte[])decryptHsmByHsm) && Arrays.areEqual((byte[])decryptBcByHsm, (byte[])data) && Arrays.areEqual((byte[])decryptHsmByHsm, (byte[])data))) {
                logger.error("#####################decryptByHsm curve {}  test error ########################", (Object)stdName);
                System.exit(0);
            }
            logger.debug("#####################decryptByHsm curve {}  test success ########################", (Object)stdName);
        }
        catch (Exception e) {
            logger.error("#####################decryptByHsm curve {}  test error ########################", (Object)stdName, (Object)e);
            System.exit(0);
        }
    }

    private static void encryptByHsm(int index, int bits, String stdName) {
        try {
            GMSSLPkiCryptoInit.getBCInstance();
            KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair((String)stdName);
            logger.debug("#####################encryptByHsm curve {} test start ########################", (Object)stdName);
            PublicKey encKey = keyPair.getPublic();
            byte[] data = Hex.decode((String)"1234");
            byte[] encryptByHsm = GMSSLECIESEncryptUtils.encrypt((PublicKey)encKey, (byte[])data, (int)bits);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] encryptByBc = GMSSLECIESEncryptUtils.encrypt((PublicKey)encKey, (byte[])data, (int)bits);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] decryptBcByBC = GMSSLECIESEncryptUtils.decrypt((PrivateKey)keyPair.getPrivate(), (byte[])encryptByBc, (int)bits);
            byte[] decryptHsmByBC = GMSSLECIESEncryptUtils.decrypt((PrivateKey)keyPair.getPrivate(), (byte[])encryptByHsm, (int)bits);
            if (!(Arrays.areEqual((byte[])decryptBcByBC, (byte[])decryptHsmByBC) && Arrays.areEqual((byte[])decryptBcByBC, (byte[])data) && Arrays.areEqual((byte[])decryptHsmByBC, (byte[])data))) {
                logger.error("#####################encryptByHsm curve {}  test error ########################", (Object)stdName);
                System.exit(0);
            }
            logger.debug("#####################encryptByHsm curve {}  test success ########################", (Object)stdName);
        }
        catch (Exception e) {
            logger.error("#####################encryptByHsm curve {}  test error ########################", (Object)stdName, (Object)e);
            System.exit(0);
        }
    }

    private static void generateCert(int index, String signAlgName, int bits, String stdName) {
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        try {
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            logger.debug("#####################generateCert  {} test start ########################", (Object)stdName);
            Date now = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(5, -1);
            Date noBefore = calendar.getTime();
            calendar.add(1, 1);
            Date noAfter = calendar.getTime();
            String rDN = "cn=root,o=xdja,c=cn";
            PublicKey publickey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)stdName, (boolean)false);
            ArrayList<Extension> rExtensions = new ArrayList<Extension>();
            rExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
            rExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)publickey));
            rExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(null));
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, password);
            X509Certificate rCert = GMSSLCertUtils.generateCert((String)rDN, (String)rDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)sdfPrivateKey, (PublicKey)publickey, (String)signAlgName, rExtensions, (boolean)false, (int)bits);
            System.out.println(rCert);
            boolean verifyByHsm = GMSSLCertUtils.verifyCert((PublicKey)publickey, (X509Certificate)rCert, (int)bits);
            GMSSLPkiCryptoInit.getBCInstance();
            boolean verifyByBc = GMSSLCertUtils.verifyCert((PublicKey)publickey, (X509Certificate)rCert, (int)bits);
            logger.debug("verifyByHsm {} ", (Object)verifyByHsm);
            logger.debug("verifyByBc {} ", (Object)verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################generateCert  {} test error ########################", (Object)stdName);
                System.exit(0);
            }
            logger.debug("#####################generateCert  {} test success ########################", (Object)stdName);
        }
        catch (Exception e) {
            logger.error("#####################generateCert  {} test error ########################", (Object)stdName, (Object)e);
            System.exit(0);
        }
    }

    private static void generateCRL(int index, String signAlgName, int bits, String stdName) {
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        try {
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            logger.debug("#####################generateCRL  {} test start ########################", (Object)stdName);
            Date now = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(5, -1);
            Date noBefore = calendar.getTime();
            calendar.add(1, 1);
            Date noAfter = calendar.getTime();
            String rDN = "cn=root,o=xdja,c=cn";
            PublicKey publickey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)stdName, (boolean)false);
            ArrayList<Extension> rExtensions = new ArrayList<Extension>();
            rExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
            rExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)publickey));
            rExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(null));
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, password);
            X509Certificate rCert = GMSSLCertUtils.generateCert((String)rDN, (String)rDN, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)sdfPrivateKey, (PublicKey)publickey, (String)signAlgName, rExtensions, (boolean)false, (int)bits);
            System.out.println(rCert);
            X509CRL x509CRL = GMSSLCRLUtils.generateCRL((X509Certificate)rCert, (PrivateKey)sdfPrivateKey, (String)signAlgName, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)now, (Date)noAfter, null, null, (boolean)false, (int)bits);
            System.out.println(x509CRL);
            boolean verifyByHsm = GMSSLCRLUtils.verifyCRL((PublicKey)publickey, (X509CRL)x509CRL, (int)bits);
            GMSSLPkiCryptoInit.getBCInstance();
            boolean verifyByBc = GMSSLCRLUtils.verifyCRL((PublicKey)publickey, (X509CRL)x509CRL, (int)bits);
            logger.debug("verifyByHsm {} ", (Object)verifyByHsm);
            logger.debug("verifyByBc {} ", (Object)verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################generateCRL  {} test error ########################", (Object)stdName);
                System.exit(0);
            }
            logger.debug("#####################generateCRL  {} test success ########################", (Object)stdName);
        }
        catch (Exception e) {
            logger.error("#####################generateCRL  {} test error ########################", (Object)stdName, (Object)e);
            System.exit(0);
        }
    }

    public static void generateP10(int index, String stdName, String signAlgName, int bits) {
        try {
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            logger.debug("#####################generateP10  {} test start ########################", (Object)stdName);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware((int)index, (String)stdName, (boolean)false);
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, password);
            PKCS10CertificationRequest pkcs10CertificationRequest = GMSSLP10Utils.generateP10((String)"cn=xdja1,o=xdja,c=cn", (PublicKey)publicKey, (PrivateKey)sdfPrivateKey, (String)signAlgName, (boolean)false, (int)bits);
            boolean verifyByHsm = GMSSLP10Utils.verifyP10((PKCS10CertificationRequest)pkcs10CertificationRequest, (int)bits);
            System.out.println(pkcs10CertificationRequest);
            GMSSLP10Utils.writeP10ToFile((String)("/home/xdja/" + bits), (String)"test", (Object)pkcs10CertificationRequest);
            GMSSLPkiCryptoInit.getBCInstance();
            boolean verifyByBc = GMSSLP10Utils.verifyP10((PKCS10CertificationRequest)pkcs10CertificationRequest, (int)bits);
            logger.debug("verifyByHsm {} ", (Object)verifyByHsm);
            logger.debug("verifyByBc {} ", (Object)verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################generateP10  {} test error ########################", (Object)stdName);
                System.exit(0);
            }
            logger.debug("#####################generateP10  {} test success ########################", (Object)stdName);
        }
        catch (Exception e) {
            logger.error("#####################generateP10  {} test error ########################", (Object)stdName, (Object)e);
            System.exit(0);
        }
    }
}

