package com.xdja.pki.gmssl.main.yunhsm;

import com.xdja.hsm.api.SdfApi;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfApiCode;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDKUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnectionProviderImpl;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLHsmUtils;

import java.io.File;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2021/6/28 11:18
 **/
public class KeyAccessTest {

    public static void main(String[] args) throws Exception {
        int value = Integer.valueOf(args[0]);
        if (value == 1) {
            testThread();
        }
        if (value == 2) {
            testNewTest(true);
        }

        if (value == 3) {
            testNewTest(false);
        }
        if (value == 4) {
            testUtils();
        }
        if (value == 5) {
            testUtilsError();
        }
    }

    public static void testThread() {
        GMSSLPkiCryptoInit.getHsmInstance();
        for (int i = 0; i < 2; i++) {
            Thread thread = new Thread(new Runnable() {
                @Override
                public void run() {
                    for (int i = 0; i < 200; i++) {
                        boolean a1234567 = GMSSLECKeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.YUNHSM, 1, "a1234567");
                        System.out.println(a1234567);
                    }
                }
            });
            thread.start();
        }
    }


    public static void testNewTest(boolean isRelease) throws Exception {
        GMSSLPkiCryptoInit.getHsmInstance();
        for (int i = 0; i < 10; i++) {
            SdfApi sdfApi = new SdfApi();
            long[] dev = {0}, ses = {0};
            String confPath = GMSSLHsmUtils.getConfPath(false) + File.separator + "etc" + File.separator + "xdsdfjni.json";
            System.out.println(confPath);
            int ret = sdfApi.openDeviceWithPath(confPath, dev);
            YunhsmSdfSDKUtils.checkRet("openDeviceWithPath", ret, dev[0], 0);
            ret = sdfApi.initialize(dev[0], confPath.getBytes());
            YunhsmSdfSDKUtils.checkRet("initialize", ret, dev[0], 0);
            ret = sdfApi.openSession(dev[0], ses);
            YunhsmSdfSDKUtils.checkRet("openSession", ret, dev[0], 0);
            int accessRight = sdfApi.getPrivateKeyAccessRight(ses[0], 1, "a1234568".getBytes(), 8);
            YunhsmSdfSDKUtils.checkRet("getPrivateKeyAccessRight", accessRight, dev[0], 0);
            if (isRelease) {
                ret = sdfApi.closeSession(ses[0]);
                YunhsmSdfSDKUtils.checkRet("closeSession", ret, dev[0], 0);
                ret = sdfApi.closeDevice(dev[0]);
                YunhsmSdfSDKUtils.checkRet("closeDevice", ret, dev[0], 0);
            }
            System.out.println("#######################" + accessRight);
        }
    }

    public static void testUtils() throws Exception {
        GMSSLPkiCryptoInit.getHsmInstance();
        for (int i = 0; i < 100; i++) {
            boolean check = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm(1, "a1234567");
            System.out.println(check);
        }
    }

    public static void testUtilsError() throws Exception {
        GMSSLPkiCryptoInit.getHsmInstance();
        for (int i = 0; i < 100; i++) {
            boolean check = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm(1, "a1254567");
            System.out.println(check);
        }
    }
}
