package com.xdja.pki.gmssl.main.yunhsm;

import com.xdja.hsm.api.SdfApi;
import com.xdja.hsm.api.bean.EccCipherEx;
import com.xdja.hsm.api.bean.EccPublicKeyEx;
import com.xdja.hsm.api.bean.EccSignatureEx;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.*;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdAsymmetric;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnection;
import com.xdja.pki.gmssl.sdf.yunhsm.pool.HsmConnectionProviderImpl;
import com.xdja.pki.gmssl.x509.utils.GMSSLCRLUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLP10Utils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @description: TODO
 * @author: feng zhen
 * @date: 2021/7/2 9:53
 **/
public class NistTest {
    private static Logger logger = LoggerFactory.getLogger(NistTest.class);
    private static int nist384Index = 7;
    private static int nist256Index = 6;
    private static int nist521Index = 8;
    private static int BITS_384 = 384;
    private static int BITS_521 = 521;
    private static String password = "xdja1234";

    public static void main(String[] args) {

        Integer i = Integer.valueOf(args[0]);
        switch (i) {
            case 1:
                digest384();
                break;
            case 2:
                digest512();
                break;
            case 3:
                exportKey(nist384Index, GMSSLECKeyUtils.NISTp384);
                break;
            case 4:
                exportKey(nist521Index, GMSSLECKeyUtils.NISTp521);
                break;
            case 5:
                generateKeyPair(GMSSLECKeyUtils.NISTp384);
                break;
            case 6:
                generateKeyPair(GMSSLECKeyUtils.NISTp521);
                break;
            case 7:
                testAll();
                break;
            case 8:
                signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 9:
                signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 10:
                signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            case 11:
                signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            case 12:
                signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            case 13:
                signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;


            case 14:
                veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 15:
                veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 16:
                veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            case 17:
                veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            case 18:
                veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            case 19:
                veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;


            case 20:
                encryptByHsm(nist521Index, BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 21:
                encryptByHsm(nist384Index, BITS_384, GMSSLECKeyUtils.NISTp384);
                break;

            case 22:
                decryptByHsm(nist521Index, BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 23:
                decryptByHsm(nist521Index, BITS_521, GMSSLECKeyUtils.NISTp521);
                break;


            case 24:
                generateCert(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 25:
                generateCert(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;

            case 26:
                generateCRL(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 27:
                generateCRL(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;

            case 28:
                generateP10(nist521Index, GMSSLECKeyUtils.NISTp521, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521);
                break;
            case 29:
                generateP10(nist384Index, GMSSLECKeyUtils.NISTp384, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384);
                break;


            case 80:
                signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 81:
                signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            case 82:
                veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 83:
                veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;
            case 84:
                generateCert(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 85:
                generateCert(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;

            case 86:
                generateCRL(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);
                break;
            case 87:
                generateCRL(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);
                break;

            case 88:
                generateP10(nist521Index, GMSSLECKeyUtils.NISTp521, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521);
                break;
            case 89:
                generateP10(nist384Index, GMSSLECKeyUtils.NISTp384, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384);
                break;
            case 90:
                signByHsm(nist256Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), 256, GMSSLECKeyUtils.NISTp256);
                break;
            case 91:
                signByHsm(nist256Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), 256, GMSSLECKeyUtils.NISTp256);
                break;
            case 92:
                veryByHsm(nist256Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), 256, GMSSLECKeyUtils.NISTp256);
                break;
            case 93:
                veryByHsm(nist256Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), 256, GMSSLECKeyUtils.NISTp256);
                break;
            default:
                break;
        }

    }

    private static void testAll() {

        digest384();

        digest512();

        exportKey(nist384Index, GMSSLECKeyUtils.NISTp384);

        exportKey(nist521Index, GMSSLECKeyUtils.NISTp521);

        generateKeyPair(GMSSLECKeyUtils.NISTp384);

        generateKeyPair(GMSSLECKeyUtils.NISTp521);


        signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);

        signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);

        signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);

        signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);

        signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);

        signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);


        veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);

        veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);

        veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);

        veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);

        veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);

        veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);


//        encryptByHsm(nist521Index, BITS_521, GMSSLECKeyUtils.NISTp521);
//
//        encryptByHsm(nist384Index, BITS_384, GMSSLECKeyUtils.NISTp384);
//
//
//        decryptByHsm(nist521Index, BITS_521, GMSSLECKeyUtils.NISTp521);
//
//        decryptByHsm(nist521Index, BITS_521, GMSSLECKeyUtils.NISTp521);


        generateCert(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);

        generateCert(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);


        generateCRL(nist521Index, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);

        generateCRL(nist384Index, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);


        generateP10(nist521Index, GMSSLECKeyUtils.NISTp521, GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), BITS_521);

        generateP10(nist384Index, GMSSLECKeyUtils.NISTp384, GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), BITS_384);


        signByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);

        signByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);

        veryByHsm(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);

        veryByHsm(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);

        generateCert(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);

        generateCert(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);


        generateCRL(nist521Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521, GMSSLECKeyUtils.NISTp521);

        generateCRL(nist384Index, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384, GMSSLECKeyUtils.NISTp384);


        generateP10(nist521Index, GMSSLECKeyUtils.NISTp521, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_521);

        generateP10(nist384Index, GMSSLECKeyUtils.NISTp384, GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), BITS_384);

    }


    public static void testEncrypt(SdfAlgIdAsymmetric sdfAlgIdAsymmetric, String curveName, int bits, int index) throws Exception {
        GMSSLPkiCryptoInit.getBCInstance();
        KeyPair keyPair521 = GMSSLECKeyUtils.generateECKeyPair(curveName);
        byte[] data = Hex.decode("12345678123456781234567812345678");
        byte[] encrypt = GMSSLECIESEncryptUtils.encrypt(keyPair521.getPublic(), data);
        byte[] decrypt = GMSSLECIESEncryptUtils.decrypt(keyPair521.getPrivate(), encrypt);
        GMSSLByteArrayUtils.printHexBinary(null, "data", data);
        GMSSLByteArrayUtils.printHexBinary(null, "encrypt", encrypt);
        GMSSLByteArrayUtils.printHexBinary(null, "decrypt", decrypt);
        GMSSLPkiCryptoInit.getXdjaYunHsmInstance();

        EccCipherEx pucEncData = new EccCipherEx();
        EccPublicKeyEx pucPublicKey = new EccPublicKeyEx();

        BCECPublicKey aPublic = (BCECPublicKey) keyPair521.getPublic();
        pucPublicKey.setBits(bits);
        pucPublicKey.setX(GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(aPublic.getW().getAffineX().toByteArray(), EccPublicKeyEx.ECC_MAX_LEN));
        pucPublicKey.setY(GMSSLByteArrayUtils.fillByteArrayWithZeroInHead(aPublic.getW().getAffineY().toByteArray(), EccPublicKeyEx.ECC_MAX_LEN));
        HsmConnection connection = HsmConnectionProviderImpl.getInstance().getConnection();
        int ret = connection.getSdfApi().externalEncryptEccEx(connection.getSes()[0], sdfAlgIdAsymmetric.getId(), pucPublicKey, data, data.length, pucEncData);
        System.out.println(ret);
        GMSSLByteArrayUtils.printHexBinary(null, "x", pucEncData.getX());
        GMSSLByteArrayUtils.printHexBinary(null, "y", pucEncData.getY());
        GMSSLByteArrayUtils.printHexBinary(null, "m", pucEncData.getM());
        GMSSLByteArrayUtils.printHexBinary(null, "c", pucEncData.getC());
        System.out.println(ret);
        byte[] pucData = new byte[data.length];
        int[] puiDataLength = {data.length};
        HsmConnectionProviderImpl.getInstance().releaseConnection(connection);
        connection = HsmConnectionProviderImpl.getInstance().getConnection();
        ret = connection.getSdfApi().internalDecryptEccEx(connection.getSes()[0], index, sdfAlgIdAsymmetric.getId(), pucEncData, pucData, puiDataLength);
    }

    private static void digest384() {
        try {
            logger.debug("#####################digest 384  test start ########################");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = Hex.decode("1234");
            byte[] digestByYunHsm = GMSSLSHA384DigestUtils.digest(data);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] digestByBc = GMSSLSHA384DigestUtils.digest(data);
            GMSSLByteArrayUtils.printHexBinary(logger, "digestByYunHsm", digestByYunHsm);
            GMSSLByteArrayUtils.printHexBinary(logger, "digestByBc", digestByBc);
            if (Arrays.areEqual(digestByBc, digestByYunHsm)) {
                logger.debug("#####################digest 384  test success ########################");
            } else {
                logger.error("#####################digest 384  test error ########################");
                System.exit(0);
            }
        } catch (Exception e) {
            logger.error("#####################digest 384  test error ########################", e);
            System.exit(0);
        }
    }
//16777245

    private static void digest512() {
        try {
            logger.debug("#####################digest 512  test start ########################");
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] data = Hex.decode("1234");
            byte[] digestByYunHsm = GMSSLSHA512DigestUtils.digest(data);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] digestByBc = GMSSLSHA512DigestUtils.digest(data);
            GMSSLByteArrayUtils.printHexBinary(logger, "digestByYunHsm", digestByYunHsm);
            GMSSLByteArrayUtils.printHexBinary(logger, "digestByBc", digestByBc);
            if (Arrays.areEqual(digestByBc, digestByYunHsm)) {
                logger.debug("#####################digest 512  test success ########################");
            } else {
                logger.error("#####################digest 512  test error ########################");
                System.exit(0);
            }
        } catch (Exception e) {
            logger.error("#####################digest 512  test error ########################", e);
            System.exit(0);
        }
    }


    private static void exportKey(int index, String stdName) {
        try {
            logger.debug("#####################export key  {} test start ########################", stdName);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            PublicKey encKey = GMSSLECKeyUtils.getPublicKeyFromHardware(index, stdName, true);
            logger.debug("EC {} encrypt key is {} ", stdName, encKey);
            PublicKey signKey = GMSSLECKeyUtils.getPublicKeyFromHardware(index, stdName, false);
            logger.debug("EC {} sign key is {} ", stdName, signKey);
            logger.debug("#####################export key  {} test success ########################", stdName);

        } catch (Exception e) {
            logger.error("#####################export key  {} test  error ########################", stdName, e);
            System.exit(0);
        }
    }


    private static void generateKeyPair(String stdName) {
        try {
            logger.debug("#####################generateKeyPair  {} test start ########################", stdName);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair(stdName);
            logger.debug("EC {}  keypair public is {} ", stdName, keyPair.getPublic());
            logger.debug("EC {} keypair private is {} ", stdName, keyPair.getPrivate());
            logger.debug("#####################generateKeyPair  {} test success ########################", stdName);
        } catch (Exception e) {
            logger.error("#####################generateKeyPair  {} test  error ########################", stdName, e);
            System.exit(0);
        }
    }


    private static void signByHsm(int index, String signAlgName, int bits, String stdName) {
        try {
            logger.debug("#####################sign  curve {} ,signAlgName {} test start ########################", stdName, signAlgName);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, password);
            byte[] data = Hex.decode("1234");
            byte[] sign = GMSSLECSignUtils.sign(sdfPrivateKey, data, null, signAlgName, bits);
            PublicKey signKey = GMSSLECKeyUtils.getPublicKeyFromHardware(index, stdName, false);
            boolean verifyByHsm = GMSSLECSignUtils.verify(signKey, data, sign, null, signAlgName, bits);
            GMSSLPkiCryptoInit.getBCInstance();
            boolean verifyByBc = GMSSLECSignUtils.verify(signKey, data, sign, null, signAlgName, bits);
            logger.debug("verifyByHsm {}   ", verifyByHsm);
            logger.debug("verifyByBc {}   ", verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################sign  curve {} ,signAlgName {} test error ########################", stdName, signAlgName);
                System.exit(0);
            }
            logger.debug("#####################sign  curve {} ,signAlgName {} test success ########################", stdName, signAlgName);
        } catch (Exception e) {
            logger.error("#####################sign  curve {} ,signAlgName {} test error ########################", stdName, signAlgName, e);
            System.exit(0);
        }
    }


    private static void veryByHsm(int index, String signAlgName, int bits, String stdName) {
        try {
            GMSSLPkiCryptoInit.getBCInstance();
            logger.debug("#####################verify curve {} ,signAlgName {} test start ########################", stdName, signAlgName);
            KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair(stdName);
            byte[] data = Hex.decode("1234");
            byte[] sign = GMSSLECSignUtils.sign(keyPair.getPrivate(), data, null, signAlgName, bits);

            boolean verifyByBc = GMSSLECSignUtils.verify(keyPair.getPublic(), data, sign, null, signAlgName, bits);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            boolean verifyByHsm = GMSSLECSignUtils.verify(keyPair.getPublic(), data, sign, null, signAlgName, bits);
            logger.debug("verifyByHsm {}   ", verifyByHsm);
            logger.debug("verifyByBc {}   ", verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################verify curve {} ,signAlgName {} test error ########################", stdName, signAlgName);
                System.exit(0);
            }
            logger.debug("#####################verify curve {} ,signAlgName {} test success ########################", stdName, signAlgName);
        } catch (Exception e) {
            logger.error("#####################verify curve {} ,signAlgName {} test error ########################", stdName, signAlgName, e);
            System.exit(0);
        }
    }

    private static void decryptByHsm(int index, int bits, String stdName) {
        try {
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            logger.debug("#####################decryptByHsm curve {} test start ########################", stdName);
            PublicKey encKey = GMSSLECKeyUtils.getPublicKeyFromHardware(index, stdName, true);
            byte[] data = Hex.decode("1234");
            byte[] encryptByHsm = GMSSLECIESEncryptUtils.encrypt(encKey, data, bits);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] encryptByBc = GMSSLECIESEncryptUtils.encrypt(encKey, data, bits);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] decryptBcByHsm = GMSSLECIESEncryptUtils.decrypt(new SdfPrivateKey(index, password), encryptByBc, bits);
            byte[] decryptHsmByHsm = GMSSLECIESEncryptUtils.decrypt(new SdfPrivateKey(index, password), encryptByHsm, bits);
            if (!Arrays.areEqual(decryptBcByHsm, decryptHsmByHsm) ||
                    !Arrays.areEqual(decryptBcByHsm, data) ||
                    !Arrays.areEqual(decryptHsmByHsm, data)) {
                logger.error("#####################decryptByHsm curve {}  test error ########################", stdName);
                System.exit(0);
            }
            logger.debug("#####################decryptByHsm curve {}  test success ########################", stdName);
        } catch (Exception e) {
            logger.error("#####################decryptByHsm curve {}  test error ########################", stdName, e);
            System.exit(0);
        }
    }


    private static void encryptByHsm(int index, int bits, String stdName) {
        try {
            GMSSLPkiCryptoInit.getBCInstance();
            KeyPair keyPair = GMSSLECKeyUtils.generateECKeyPair(stdName);
            logger.debug("#####################encryptByHsm curve {} test start ########################", stdName);
            PublicKey encKey = keyPair.getPublic();
            byte[] data = Hex.decode("1234");
            byte[] encryptByHsm = GMSSLECIESEncryptUtils.encrypt(encKey, data, bits);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            byte[] encryptByBc = GMSSLECIESEncryptUtils.encrypt(encKey, data, bits);
            GMSSLPkiCryptoInit.getBCInstance();
            byte[] decryptBcByBC = GMSSLECIESEncryptUtils.decrypt(keyPair.getPrivate(), encryptByBc, bits);
            byte[] decryptHsmByBC = GMSSLECIESEncryptUtils.decrypt(keyPair.getPrivate(), encryptByHsm, bits);
            if (!Arrays.areEqual(decryptBcByBC, decryptHsmByBC) ||
                    !Arrays.areEqual(decryptBcByBC, data) ||
                    !Arrays.areEqual(decryptHsmByBC, data)) {
                logger.error("#####################encryptByHsm curve {}  test error ########################", stdName);
                System.exit(0);
            }
            logger.debug("#####################encryptByHsm curve {}  test success ########################", stdName);
        } catch (Exception e) {
            logger.error("#####################encryptByHsm curve {}  test error ########################", stdName, e);
            System.exit(0);
        }
    }

    /**
     * 生成证书
     *
     * @param index       密钥索引
     * @param stdName     曲线名称
     * @param bits        密钥长度
     * @param signAlgName 签名算法
     */
    private static void generateCert(int index, String signAlgName, int bits, String stdName) {
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        //生成 CA密钥、CA根证书
        try {
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            logger.debug("#####################generateCert  {} test start ########################", stdName);
            Date now = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(Calendar.DATE, -1);
            Date noBefore = calendar.getTime();
            calendar.add(Calendar.YEAR, 1);
            Date noAfter = calendar.getTime();
            String rDN = "cn=root,o=xdja,c=cn";
            PublicKey publickey = GMSSLECKeyUtils.getPublicKeyFromHardware(index, stdName, false);
            List<Extension> rExtensions = new ArrayList<>();
            rExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
            rExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension(publickey));
            rExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(null));
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, password);
            X509Certificate rCert = GMSSLCertUtils.generateCert(
                    rDN, rDN,
                    BigInteger.valueOf(serialNumber.getAndIncrement()),
                    noBefore, noAfter,
                    sdfPrivateKey,
                    publickey,
                    signAlgName,
                    rExtensions, false, bits
            );
            System.out.println(rCert);
            //verify
            boolean verifyByHsm = GMSSLCertUtils.verifyCert(publickey, rCert, bits);
            GMSSLPkiCryptoInit.getBCInstance();
            boolean verifyByBc = GMSSLCertUtils.verifyCert(publickey, rCert, bits);
            logger.debug("verifyByHsm {} ", verifyByHsm);
            logger.debug("verifyByBc {} ", verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################generateCert  {} test error ########################", stdName);
                System.exit(0);
            }
            logger.debug("#####################generateCert  {} test success ########################", stdName);
        } catch (Exception e) {
            logger.error("#####################generateCert  {} test error ########################", stdName, e);
            System.exit(0);
        }
    }


    /**
     * 生成证书
     *
     * @param index       密钥索引
     * @param stdName     曲线名称
     * @param bits        密钥长度
     * @param signAlgName 签名算法
     */
    private static void generateCRL(int index, String signAlgName, int bits, String stdName) {
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        //生成 CA密钥、CA根证书
        try {
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            logger.debug("#####################generateCRL  {} test start ########################", stdName);
            Date now = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(Calendar.DATE, -1);
            Date noBefore = calendar.getTime();
            calendar.add(Calendar.YEAR, 1);
            Date noAfter = calendar.getTime();
            String rDN = "cn=root,o=xdja,c=cn";
            PublicKey publickey = GMSSLECKeyUtils.getPublicKeyFromHardware(index, stdName, false);
            List<Extension> rExtensions = new ArrayList<>();
            rExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
            rExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension(publickey));
            rExtensions.add(GMSSLExtensionUtils.genBasicConstraintsExtension(null));
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, password);
            X509Certificate rCert = GMSSLCertUtils.generateCert(
                    rDN, rDN,
                    BigInteger.valueOf(serialNumber.getAndIncrement()),
                    noBefore, noAfter,
                    sdfPrivateKey,
                    publickey,
                    signAlgName,
                    rExtensions, false, bits
            );
            System.out.println(rCert);
            X509CRL x509CRL = GMSSLCRLUtils.generateCRL(
                    rCert, sdfPrivateKey, signAlgName,
                    BigInteger.valueOf(serialNumber.getAndIncrement()),
                    now, noAfter, null,
                    null, false, bits
            );
            System.out.println(x509CRL);
            //verify
            boolean verifyByHsm = GMSSLCRLUtils.verifyCRL(publickey, x509CRL, bits);
            GMSSLPkiCryptoInit.getBCInstance();
            boolean verifyByBc = GMSSLCRLUtils.verifyCRL(publickey, x509CRL, bits);
            logger.debug("verifyByHsm {} ", verifyByHsm);
            logger.debug("verifyByBc {} ", verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################generateCRL  {} test error ########################", stdName);
                System.exit(0);
            }
            logger.debug("#####################generateCRL  {} test success ########################", stdName);
        } catch (Exception e) {
            logger.error("#####################generateCRL  {} test error ########################", stdName, e);
            System.exit(0);
        }
    }

    public static void generateP10(int index, String stdName, String signAlgName, int bits) {
        try {
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            logger.debug("#####################generateP10  {} test start ########################", stdName);
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            PublicKey publicKey = GMSSLECKeyUtils.getPublicKeyFromHardware(index, stdName, false);
            SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(index, password);
            PKCS10CertificationRequest pkcs10CertificationRequest = GMSSLP10Utils.generateP10(
                    "cn=xdja1,o=xdja,c=cn",
                    publicKey,
                    sdfPrivateKey,
                    signAlgName, false, bits
            );
            boolean verifyByHsm = GMSSLP10Utils.verifyP10(pkcs10CertificationRequest, bits);
            System.out.println(pkcs10CertificationRequest);
            GMSSLP10Utils.writeP10ToFile("/home/xdja/" + bits, "test", pkcs10CertificationRequest);
            GMSSLPkiCryptoInit.getBCInstance();
            boolean verifyByBc = GMSSLP10Utils.verifyP10(pkcs10CertificationRequest, bits);
            logger.debug("verifyByHsm {} ", verifyByHsm);
            logger.debug("verifyByBc {} ", verifyByBc);
            if (!verifyByHsm || !verifyByBc) {
                logger.error("#####################generateP10  {} test error ########################", stdName);
                System.exit(0);
            }
            logger.debug("#####################generateP10  {} test success ########################", stdName);
        } catch (Exception e) {
            logger.error("#####################generateP10  {} test error ########################", stdName, e);
            System.exit(0);
        }
    }
}
