package com.xdja.pki.gmssl.operator.utils;

import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public enum GMSSLSdfContentSignatureAlgorithm {
    SM3_WITH_SM2("SM3withSM2");

    private String id;

    public String getId() {
        return id;
    }

    GMSSLSdfContentSignatureAlgorithm(String id) {
        this.id = id;
    }

    public AlgorithmIdentifier convertAlgorithmIdentifier() {
        return new DefaultSignatureAlgorithmIdentifierFinder().find(this.getId());
    }

    public static GMSSLSdfContentSignatureAlgorithm convertContentSignatureAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getAlgorithm() == GMObjectIdentifiers.sm2sign_with_sm3) {
            return SM3_WITH_SM2;
        }
        return null;
    }
}
