/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.operator.utils.GMSSLSdfContentSignatureAlgorithm;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class GMSSLSdfContentSignerUtils {
    public static ContentSigner generateContentSignerByBC(GMSSLSdfContentSignatureAlgorithm signatureAlgorithm, PrivateKey privateKey) throws OperatorCreationException {
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(signatureAlgorithm.getId());
        return contentSignerBuilder.build(privateKey);
    }

    public static ContentSigner generateContentSignerByYunhsm(PrivateKey privateKey) throws OperatorCreationException {
        return GMSSLSdfContentSignerUtils.generateContentSignerBySDF(SdfCryptoType.YUNHSM, privateKey);
    }

    public static ContentSigner generateContentSignerByPcie(PrivateKey privateKey) throws OperatorCreationException {
        return GMSSLSdfContentSignerUtils.generateContentSignerBySDF(SdfCryptoType.PCIE, privateKey);
    }

    public static ContentSigner generateContentSignerBySDF(SdfCryptoType sdfCryptoType, PrivateKey privateKey) throws OperatorCreationException {
        if (!(privateKey instanceof SdfPrivateKey)) {
            throw new OperatorCreationException(" un support private key type " + privateKey.getClass());
        }
        return new SdfContentSigner(sdfCryptoType, (SdfPrivateKey)privateKey);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

