/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentVerifierProvider;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class GMSSLSdfContentVerifierProviderUtils {
    public ContentVerifierProvider generateContentVerifierByBC(PublicKey publicKey) throws OperatorCreationException {
        return this.generateContentVerifierByBC(SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()));
    }

    public ContentVerifierProvider generateContentVerifierByBC(SubjectPublicKeyInfo subjectPublicKeyInfo) throws OperatorCreationException {
        return new JcaContentVerifierProviderBuilder().setProvider("BC").build(subjectPublicKeyInfo);
    }

    public ContentVerifierProvider generateContentVerifierByYunHsm(PublicKey publicKey) {
        return this.generateContentVerifierBySdf(SdfCryptoType.YUNHSM, publicKey);
    }

    public ContentVerifierProvider generateContentVerifierByPcie(PublicKey publicKey) {
        return this.generateContentVerifierBySdf(SdfCryptoType.PCIE, publicKey);
    }

    public ContentVerifierProvider generateContentVerifierBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey) {
        return new SdfContentVerifierProvider(sdfCryptoType, publicKey);
    }
}

