/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.sdf.yunhsm.utils;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.yunhsm.YunhsmSdfSDK;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmInfoEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLYunHsmUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLYunHsmUtils.class);

    public static void resetYunHsm() throws IOException {
        String yunHsmPath = GMSSLYunHsmUtils.getYunHsmPath();
        GMSSLYunHsmUtils.resetYunHsm(yunHsmPath);
    }

    public static void resetYunHsm(String yunhsmPath) throws IOException {
        String bakPath = yunhsmPath + File.separator + "confBak" + File.separator;
        String sourcePath = yunhsmPath + File.separator + "conf" + File.separator;
        File bakfile = new File(bakPath);
        if (!bakfile.exists()) {
            logger.info("\u5bc6\u7801\u673a\u672a\u8fdb\u884c\u4efb\u4f55\u914d\u7f6e\uff0c\u65e0\u9700\u521d\u59cb\u5316");
            return;
        }
        GMSSLX509Utils.deleteDirectory((String)sourcePath);
        File file = new File(sourcePath);
        file.mkdir();
        GMSSLX509Utils.copyDir((String)bakPath, (String)sourcePath);
        GMSSLX509Utils.deleteDirectory((String)bakPath);
        logger.info("\u5bc6\u7801\u673a\u521d\u59cb\u5316\u6210\u529f");
    }

    public static YunHsmInfoEntry getYunHsmInfo() throws IOException {
        String yunHsmPath = GMSSLYunHsmUtils.getYunHsmPath();
        return GMSSLYunHsmUtils.getYunHsmInfo(yunHsmPath);
    }

    public static YunHsmInfoEntry getYunHsmInfo(String yunhsmPath) throws IOException {
        String confPath = yunhsmPath + File.separator + "conf" + File.separator + "yunhsmsdk.conf";
        YunHsmInfoEntry yunHsmInfoEntry = new YunHsmInfoEntry();
        File file = new File(confPath);
        String jsonString = FileUtils.readFileToString((File)file, (String)"UTF-8");
        JSONObject dataJson = JSONObject.parseObject((String)jsonString);
        JSONObject certificate = dataJson.getJSONObject("Certificate");
        JSONObject softCert = certificate.getJSONObject("SoftCert");
        JSONObject signatureCertificate = softCert.getJSONObject("SignatureCertificate");
        yunHsmInfoEntry.setSignCertPassword(signatureCertificate.getString("pin"));
        String signCertName = signatureCertificate.getString("file");
        yunHsmInfoEntry.setSignCertName(signCertName.substring(signCertName.indexOf("sign")));
        JSONObject encryptCertificate = softCert.getJSONObject("EncryptCertificate");
        yunHsmInfoEntry.setEncCertPassword(encryptCertificate.getString("pin"));
        String encCertName = encryptCertificate.getString("file");
        yunHsmInfoEntry.setEncCertName(encCertName.substring(encCertName.indexOf("enc")));
        JSONObject hsm = dataJson.getJSONObject("hsm");
        yunHsmInfoEntry.setServerIp(hsm.getString("ip"));
        yunHsmInfoEntry.setServerPort(Integer.valueOf(hsm.getString("port")));
        JSONObject ssl = dataJson.getJSONObject("ssl");
        String caCertName = ssl.getString("CertificatePath");
        yunHsmInfoEntry.setCaCertName(caCertName.substring(caCertName.indexOf("trust")));
        yunHsmInfoEntry.setYunHsmType("\u4fe1\u5927\u6377\u5b89\u670d\u52a1\u5668\u5bc6\u7801\u673a");
        return yunHsmInfoEntry;
    }

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String ip, int port, String signPfxPassword, String encPfxPassword, String signPfxPath, String encPfxPath, String trustP7bPath) throws Exception {
        String yunHsmPath = GMSSLYunHsmUtils.getYunHsmPath();
        return GMSSLYunHsmUtils.initYunHsmConfigAndTestConnect(yunHsmPath, ip, port, signPfxPassword, encPfxPassword, signPfxPath, encPfxPath, trustP7bPath);
    }

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String ip, int port, String signPfxPassword, String encPfxPassword, FileInputStream signPfxStream, FileInputStream encPfxStream, FileInputStream trustP7bStream) throws Exception {
        String yunHsmPath = GMSSLYunHsmUtils.getYunHsmPath();
        return GMSSLYunHsmUtils.initYunHsmConfigAndTestConnect1(yunHsmPath, ip, port, signPfxPassword, encPfxPassword, signPfxStream, encPfxStream, trustP7bStream);
    }

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect(String yunhsmPath, String ip, int port, String signPfxPassword, String encPfxPassword, String signPfxPath, String encPfxPath, String trustP7bPath) throws Exception {
        GMSSLYunHsmUtils.backUpConf(yunhsmPath);
        YunHsmExceptionEnum checkCert = GMSSLYunHsmUtils.storeCert(signPfxPassword, encPfxPassword, signPfxPath, encPfxPath, trustP7bPath, yunhsmPath);
        if (checkCert.id != YunHsmExceptionEnum.NORMAL.id) {
            return checkCert;
        }
        GMSSLYunHsmUtils.writeConf(yunhsmPath, ip, port, signPfxPassword, encPfxPassword);
        YunHsmExceptionEnum checkConnect = GMSSLYunHsmUtils.testConnect(ip, port);
        if (checkConnect.id != YunHsmExceptionEnum.NORMAL.id) {
            return checkConnect;
        }
        return YunHsmExceptionEnum.NORMAL;
    }

    public static YunHsmExceptionEnum initYunHsmConfigAndTestConnect1(String yunhsmPath, String ip, int port, String signPfxPassword, String encPfxPassword, FileInputStream signPfxStream, FileInputStream encPfxStream, FileInputStream trustP7bStream) throws Exception {
        GMSSLYunHsmUtils.backUpConf(yunhsmPath);
        YunHsmExceptionEnum checkCert = GMSSLYunHsmUtils.storeCert(signPfxPassword, encPfxPassword, signPfxStream, encPfxStream, trustP7bStream, yunhsmPath);
        if (checkCert.id != YunHsmExceptionEnum.NORMAL.id) {
            return checkCert;
        }
        GMSSLYunHsmUtils.writeConf(yunhsmPath, ip, port, signPfxPassword, encPfxPassword);
        YunHsmExceptionEnum checkConnect = GMSSLYunHsmUtils.testConnect(ip, port);
        if (checkConnect.id != YunHsmExceptionEnum.NORMAL.id) {
            return checkConnect;
        }
        return YunHsmExceptionEnum.NORMAL;
    }

    private static void deleteConDir(String yunHsmPath) {
        File confDir = new File(yunHsmPath + File.separator + "conf");
        if (confDir.exists()) {
            GMSSLX509Utils.deleteDirectory((String)(yunHsmPath + File.separator + "conf"));
        }
        confDir.mkdir();
    }

    private static String getYunHsmPath() {
        String os = System.getProperty("os.name");
        String yunhsmPath = os.startsWith("Windows") ? "C:\\Program Files (x86)\\yunhsmsdk" : "/usr/local/yunhsmsdk";
        return yunhsmPath;
    }

    private static void backUpConf(String path) throws IOException {
        String bakPath = path + File.separator + "confBak" + File.separator;
        File bakFile = new File(bakPath);
        if (bakFile.exists() && bakFile.isDirectory()) {
            return;
        }
        String sourcePath = path + File.separator + "conf" + File.separator;
        GMSSLX509Utils.copyDir((String)sourcePath, (String)bakPath);
        logger.info("\u5907\u4efd\u6210\u529f");
    }

    private static YunHsmExceptionEnum storeCert(String signPfxPassword, String encPfxPassword, FileInputStream signPfxStream, FileInputStream encPfxStream, FileInputStream trustP7bStream, String yunHsmPath) throws Exception {
        int i;
        List trustList;
        KeyStore encKse;
        KeyStore signKse;
        File signPfx;
        YunHsmInfoEntry yunHsmInfo = GMSSLYunHsmUtils.getYunHsmInfo(yunHsmPath);
        if (signPfxStream == null) {
            String signCertName = yunHsmInfo.getSignCertName();
            signPfx = new File(yunHsmPath + File.separator + "conf" + File.separator + signCertName);
            signPfxStream = new FileInputStream(signPfx);
        }
        if (encPfxStream == null) {
            String encCertName = yunHsmInfo.getEncCertName();
            signPfx = new File(yunHsmPath + File.separator + "conf" + File.separator + encCertName);
            encPfxStream = new FileInputStream(signPfx);
        }
        if (trustP7bStream == null) {
            String caCertName = yunHsmInfo.getCaCertName();
            File trustP7b = new File(yunHsmPath + File.separator + "conf" + File.separator + caCertName);
            trustP7bStream = new FileInputStream(trustP7b);
        }
        try {
            signKse = KeyStore.getInstance("pkcs12", "BC");
            signKse.load(signPfxStream, signPfxPassword.toCharArray());
            logger.info("\u7b7e\u540dPFX\u8bc1\u4e66\u89e3\u6790\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u8bc1\u4e66\u4fdd\u62a4\u53e3\u4ee4\u4e0d\u80fd\u6253\u5f00\u52a0\u5bc6\u8bc1\u4e66");
            return YunHsmExceptionEnum.SIGN_PASSWORD_IS_ERROR;
        }
        try {
            encKse = KeyStore.getInstance("pkcs12", "BC");
            encKse.load(encPfxStream, encPfxPassword.toCharArray());
            logger.info("\u52a0\u5bc6PFX\u8bc1\u4e66\u89e3\u6790\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u8bc1\u4e66\u4fdd\u62a4\u53e3\u4ee4\u4e0d\u80fd\u6253\u5f00\u52a0\u5bc6\u8bc1\u4e66");
            return YunHsmExceptionEnum.ENC_PASSWORD_IS_ERROR;
        }
        String debugPath = yunHsmPath + File.separator + "confDebug" + File.separator;
        File file = new File(debugPath);
        file.mkdir();
        GMSSLKeyStoreUtils.saveGMSSLPfx(signKse, signPfxPassword, debugPath, "sign_" + signPfxPassword);
        GMSSLKeyStoreUtils.saveGMSSLPfx(encKse, encPfxPassword, debugPath, "enc_" + encPfxPassword);
        GMSSLX509Utils.copyFile((FileInputStream)trustP7bStream, (String)(debugPath + "trust_chain.p7b"));
        try {
            trustList = GMSSLX509Utils.getCertsByCertChain((InputStream)new FileInputStream(new File(debugPath + "trust_chain.p7b")));
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5bc6\u7801\u673aCA\u8bc1\u4e66\u94fe\u5931\u8d25");
            return YunHsmExceptionEnum.OPEN_TRAIN_CERT_P7b_IS_ERROR;
        }
        List signList = GMSSLX509Utils.readCertificatesFromP12((String)(debugPath + "sign_" + signPfxPassword + ".pfx"), (char[])signPfxPassword.toCharArray());
        List encList = GMSSLX509Utils.readCertificatesFromP12((String)(debugPath + "enc_" + encPfxPassword + ".pfx"), (char[])encPfxPassword.toCharArray());
        for (i = 0; i < signList.size(); ++i) {
            if (GMSSLX509Utils.verifyCert((X509Certificate)((X509Certificate)signList.get(i)), (List)trustList)) continue;
            GMSSLX509Utils.deleteDirectory((String)debugPath);
            logger.error("\u7b2c " + (i + 1) + "\u4e2a\u7b7e\u540d\u8bc1\u4e66\u9a8c\u7b7e\u5931\u8d25");
            return YunHsmExceptionEnum.SIGN_CERT_VERIFY_IS_ERROR;
        }
        logger.info("\u7b7e\u540d\u8bc1\u4e66\u9a8c\u7b7e\u5168\u90e8\u901a\u8fc7");
        for (i = 0; i < encList.size(); ++i) {
            if (GMSSLX509Utils.verifyCert((X509Certificate)((X509Certificate)encList.get(i)), (List)trustList)) continue;
            GMSSLX509Utils.deleteDirectory((String)debugPath);
            logger.error("\u7b2c" + (i + 1) + "\u4e2a\u52a0\u5bc6\u8bc1\u4e66\u9a8c\u7b7e\u5931\u8d25");
            return YunHsmExceptionEnum.ENC_CERT_VERIFY_IS_ERROR;
        }
        logger.info("\u52a0\u5bc6\u8bc1\u4e66\u9a8c\u7b7e\u5168\u90e8\u901a\u8fc7");
        String path = yunHsmPath + File.separator + "conf" + File.separator;
        GMSSLYunHsmUtils.deleteConDir(yunHsmPath);
        GMSSLX509Utils.copyDir((String)debugPath, (String)path);
        GMSSLX509Utils.deleteDirectory((String)debugPath);
        logger.debug("\u8c03\u8bd5\u6587\u4ef6\u5939\u5220\u9664\u6210\u529f");
        logger.info("\u8bc1\u4e66\u66ff\u6362\u6210\u529f");
        return YunHsmExceptionEnum.NORMAL;
    }

    private static YunHsmExceptionEnum storeCert(String signPfxPassword, String encPfxPassword, String signPfxPath, String encPfxPath, String trustP7bPath, String yunHsmPath) throws Exception {
        File signPfx = new File(signPfxPath);
        FileInputStream signPfxStream = new FileInputStream(signPfx);
        File encPfx = new File(encPfxPath);
        FileInputStream encPfxStream = new FileInputStream(encPfx);
        File trustP7b = new File(trustP7bPath);
        FileInputStream trustP7bStream = new FileInputStream(trustP7b);
        return GMSSLYunHsmUtils.storeCert(signPfxPassword, encPfxPassword, signPfxStream, encPfxStream, trustP7bStream, yunHsmPath);
    }

    private static void writeConf(String yunhsmPath, String ip, int port, String signPfxPassword, String encPfxPassword) throws IOException {
        String os = System.getProperty("os.name");
        String resoucePath = yunhsmPath + File.separator + "confBak" + File.separator + "yunhsmsdk.conf";
        String confPath = yunhsmPath + File.separator + "conf" + File.separator + "yunhsmsdk.conf";
        BufferedReader br = new BufferedReader(new FileReader(resoucePath));
        File file = new File(resoucePath);
        String jsonString = FileUtils.readFileToString((File)file, (String)"UTF-8");
        JSONObject dataJson = JSONObject.parseObject((String)jsonString);
        JSONObject certificate = dataJson.getJSONObject("Certificate");
        JSONObject softCert = certificate.getJSONObject("SoftCert");
        JSONObject signatureCertificate = softCert.getJSONObject("SignatureCertificate");
        signatureCertificate.put("pin", (Object)signPfxPassword);
        JSONObject encryptCertificate = softCert.getJSONObject("EncryptCertificate");
        encryptCertificate.put("pin", (Object)encPfxPassword);
        JSONObject hsm = dataJson.getJSONObject("hsm");
        hsm.put("ip", (Object)ip);
        hsm.put("port", (Object)port);
        JSONObject ssl = dataJson.getJSONObject("ssl");
        if (os.startsWith("Windows")) {
            signatureCertificate.put("file", (Object)(yunhsmPath + "\\conf\\sign_" + signPfxPassword + ".pfx"));
            encryptCertificate.put("file", (Object)(yunhsmPath + "\\conf\\enc_" + encPfxPassword + ".pfx"));
            ssl.put("CertificatePath", (Object)(yunhsmPath + "\\conf\\trust_chain.p7b"));
        } else {
            signatureCertificate.put("file", (Object)(yunhsmPath + "/conf/sign_" + signPfxPassword + ".pfx"));
            encryptCertificate.put("file", (Object)(yunhsmPath + "/conf/enc_" + encPfxPassword + ".pfx"));
            ssl.put("CertificatePath", (Object)(yunhsmPath + "/conf/trust_chain.p7b"));
        }
        String ws = dataJson.toString();
        BufferedWriter bw = new BufferedWriter(new FileWriter(confPath));
        String s = GMSSLYunHsmUtils.formatJson(ws);
        bw.write(s);
        bw.flush();
        br.close();
        bw.close();
        logger.info("\u914d\u7f6e\u6587\u4ef6\u6539\u5199\u6210\u529f");
    }

    public static YunHsmExceptionEnum testConnect(String host, int port) {
        try {
            if (!GMSSLYunHsmUtils.isHostConnectable(host, port)) {
                return YunHsmExceptionEnum.TELNET_PORT_FAILURE;
            }
            YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
            sdfSDK.init();
            sdfSDK.getDeviceInfo();
            sdfSDK.release();
            logger.info("connect yunhsm is successful");
        }
        catch (SdfSDKException e) {
            logger.error("open device is failure");
            return YunHsmExceptionEnum.OPEN_DEVICE_IS_FAILURE;
        }
        return YunHsmExceptionEnum.NORMAL;
    }

    public static boolean testConnect() {
        try {
            YunhsmSdfSDK sdfSDK = new YunhsmSdfSDK();
            sdfSDK.init();
            sdfSDK.getDeviceInfo();
            sdfSDK.release();
            logger.info("connect yunhsm is successful");
            return true;
        }
        catch (SdfSDKException e) {
            logger.error("open device is failure");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isHostConnectable(String host, int port) {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port));
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private static String formatJson(String jsonStr) {
        if (null == jsonStr || "".equals(jsonStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char current = '\u0000';
        int indent = 0;
        block5: for (int i = 0; i < jsonStr.length(); ++i) {
            last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '[': 
                case '{': {
                    sb.append(current);
                    sb.append('\n');
                    GMSSLYunHsmUtils.addIndentBlank(sb, ++indent);
                    continue block5;
                }
                case ']': 
                case '}': {
                    sb.append('\n');
                    GMSSLYunHsmUtils.addIndentBlank(sb, --indent);
                    sb.append(current);
                    continue block5;
                }
                case ',': {
                    sb.append(current);
                    if (last == '\\') continue block5;
                    sb.append('\n');
                    GMSSLYunHsmUtils.addIndentBlank(sb, indent);
                    continue block5;
                }
                default: {
                    sb.append(current);
                }
            }
        }
        return sb.toString();
    }

    private static void addIndentBlank(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

