/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.tomcat.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.tomcat.utils.ServerXmlResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLTomcatUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLTomcatUtils.class);

    public static void openHttpsPortByBC(X509Certificate caCert, X509Certificate caServerSignCert, X509Certificate caServerEncCert, PrivateKey caServerSignPriKey, PrivateKey caServerEncPriKey, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        GMSSLTomcatUtils.saveKeyStore(caCert, caServerSignCert, caServerEncCert, caServerSignPriKey, caServerEncPriKey, tomcatPath, String.valueOf(port));
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, "GMSSLV1.1", port);
    }

    public static void openHttpsPortByYunHsm(X509Certificate caCert, X509Certificate caServerSignCert, X509Certificate caServerEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword.getBytes());
        GMSSLTomcatUtils.saveKeyStore(caCert, caServerSignCert, caServerEncCert, (PrivateKey)sdfPrivateKey, (PrivateKey)sdfPrivateKey, tomcatPath, String.valueOf(port));
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, "GMSSLSDFYUNHSMV1.1", port);
    }

    public static void openHttpsPortByPCIE(X509Certificate caCert, X509Certificate caServerSignCert, X509Certificate caServerEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword.getBytes());
        GMSSLTomcatUtils.saveKeyStore(caCert, caServerSignCert, caServerEncCert, (PrivateKey)sdfPrivateKey, (PrivateKey)sdfPrivateKey, tomcatPath, String.valueOf(port));
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, "GMSSLSDFPCIEV1.1", port);
    }

    public static void openHttpPort(String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpPort(tomcatPath, port);
    }

    public static void closeTomcatPort(String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.closeTomcatPort(tomcatPath, port);
    }

    public static boolean restartTomcat(String tomcatPath) {
        if (!GMSSLTomcatUtils.shutdownTomcat(tomcatPath)) {
            return false;
        }
        return GMSSLTomcatUtils.startupTomcat(tomcatPath);
    }

    public static boolean shutdownTomcat(String tomcatPath) {
        return GMSSLTomcatUtils.run(tomcatPath, "shutdown");
    }

    public static boolean startupTomcat(String tomcatPath) {
        return GMSSLTomcatUtils.run(tomcatPath, "startup");
    }

    private static void saveKeyStore(X509Certificate caCert, X509Certificate caServerSignCert, X509Certificate caServerEncCert, PrivateKey caServerSignPriKey, PrivateKey caServerEncPriKey, String path, String port) throws Exception {
        File pathf = new File(path = path + File.separator + "conf" + File.separator + "cert" + File.separator + port + File.separator);
        if (!pathf.exists()) {
            pathf.mkdirs();
        }
        String password = "password";
        String signAlias = "sign";
        String encAlias = "enc";
        KeyStore serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStore(password, caCert, signAlias, caServerSignPriKey, caServerSignCert, encAlias, caServerEncPriKey, caServerEncCert);
        KeyStore trustKeyStore = GMSSLKeyStoreUtils.generateGMSSLTrustStore(caCert);
        GMSSLX509Utils.writeCertificateToPem((String)path, (String)"ca", (X509Certificate)caCert);
        GMSSLX509Utils.writeObjectToPem((String)path, (String)"ca_public", (Object)caCert.getPublicKey());
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"ca", (X509Certificate)caCert);
        GMSSLX509Utils.writeCertificateToPem((String)path, (String)"sign", (X509Certificate)caServerSignCert);
        GMSSLX509Utils.writeObjectToPem((String)path, (String)"sign_public", (Object)caServerSignCert.getPublicKey());
        if (caServerSignPriKey instanceof SdfPrivateKey) {
            GMSSLX509Utils.writeSdfPrivateKey((String)path, (String)"ca_server_key", (PrivateKey)caServerSignPriKey);
        } else {
            GMSSLX509Utils.writeObjectToPem((String)path, (String)"sign_private", (Object)caServerSignPriKey);
            GMSSLX509Utils.writeObjectToPem((String)path, (String)"enc_private", (Object)caServerEncPriKey);
            GMSSLX509Utils.writeKeyStoreToP12((KeyStore)serverKeyStore, (char[])"password".toCharArray(), (String)path, (String)"sign");
            GMSSLX509Utils.writeKeyStoreToP12((KeyStore)serverKeyStore, (char[])"password".toCharArray(), (String)path, (String)"enc");
        }
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"sign", (X509Certificate)caServerSignCert);
        GMSSLX509Utils.writeCertificateToPem((String)path, (String)"enc", (X509Certificate)caServerEncCert);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"enc", (X509Certificate)caServerEncCert);
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(serverKeyStore, "password", path, "server");
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(trustKeyStore, "password", path, "trust");
        GMSSLX509Utils.writeKeyStoreToP12((KeyStore)trustKeyStore, (char[])"password".toCharArray(), (String)path, (String)"trust");
    }

    private static boolean run(String tomcatPath, String shName) {
        Runtime rt = Runtime.getRuntime();
        Process ps = null;
        try {
            String os = System.getProperty("os.name");
            ps = os.startsWith("Windows") ? rt.exec("cmd /c " + tomcatPath + File.separator + "bin" + File.separator + shName + ".bat", null, new File(tomcatPath)) : rt.exec("sh " + tomcatPath + File.separator + "bin" + File.separator + shName + ".sh", null, new File(tomcatPath));
            InputStream is = ps.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ps.waitFor();
            is.close();
            reader.close();
            ps.destroy();
            return true;
        }
        catch (Exception e) {
            logger.error(shName + " tomcat is error ", (Throwable)e);
            return false;
        }
    }
}

