/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.x509.utils;

import com.xdja.pki.gmssl.asn1.x509.SubjectInformationAccess;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.ReasonFlags;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLExtensionUtils {
    private static Logger logger = LoggerFactory.getLogger((String)GMSSLExtensionUtils.class.getName());

    public static Extension genAuthorityInfoAccessExtension(String ldapUrl) throws IOException {
        DEROctetString instance = new DEROctetString(ldapUrl.getBytes());
        AuthorityInformationAccess issueInfo = new AuthorityInformationAccess(new AccessDescription(AccessDescription.id_ad_caIssuers, new GeneralName(6, (ASN1Encodable)instance)));
        return new Extension(Extension.authorityInfoAccess, true, issueInfo.getEncoded());
    }

    public static Extension genSubjectInfoAccessExtension(String ldapUrl) throws IOException {
        DEROctetString instance = new DEROctetString(ldapUrl.getBytes());
        SubjectInformationAccess subjectInfo = new SubjectInformationAccess(new AccessDescription(SubjectInformationAccess.id_ad_caRepository, new GeneralName(6, (ASN1Encodable)instance)));
        return new Extension(Extension.subjectInfoAccess, true, subjectInfo.getEncoded());
    }

    public static Extension genRootCertKeyUsageExtension() throws IOException {
        KeyUsage keyUsage = new KeyUsage(6);
        return new Extension(Extension.keyUsage, true, keyUsage.getEncoded());
    }

    public static Extension genSignatureCertKeyUsageExtension() throws IOException {
        KeyUsage keyUsage = new KeyUsage(192);
        return new Extension(Extension.keyUsage, true, keyUsage.getEncoded());
    }

    public static Extension genOCSPCertExtendedKeyUsageExtension() throws IOException {
        return new Extension(Extension.extendedKeyUsage, true, new ExtendedKeyUsage(KeyPurposeId.id_kp_OCSPSigning).getEncoded());
    }

    public static Extension genEncryptCertKeyUsageExtension() throws IOException {
        KeyUsage keyUsage = new KeyUsage(56);
        return new Extension(Extension.keyUsage, true, keyUsage.getEncoded());
    }

    public static Extension genAuthorityKeyIdentifierExtension(X509Certificate rootCert) throws NoSuchAlgorithmException, CertificateEncodingException, IOException {
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        AuthorityKeyIdentifier authorityKeyIdentifier = extUtils.createAuthorityKeyIdentifier(rootCert);
        return new Extension(Extension.authorityKeyIdentifier, false, authorityKeyIdentifier.getEncoded());
    }

    public static Extension genSubjectKeyIdentifierExtension(PublicKey publicKey) throws IOException, NoSuchAlgorithmException {
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        SubjectKeyIdentifier subjectKeyIdentifier = extUtils.createSubjectKeyIdentifier(publicKey);
        return new Extension(Extension.subjectKeyIdentifier, false, subjectKeyIdentifier.getEncoded());
    }

    public static Extension genBasicConstraintsExtension(int pathLenConstraint) throws IOException {
        return new Extension(Extension.basicConstraints, true, new BasicConstraints(pathLenConstraint).getEncoded());
    }

    public static Extension genCRLDistributionPointsExtension(String crlLdapUrl) throws IOException {
        DistributionPointName dpn = GMSSLExtensionUtils.genDistributionPointName(crlLdapUrl);
        CRLDistPoint crlDistPoint = new CRLDistPoint(new DistributionPoint[]{new DistributionPoint(dpn, null, null)});
        return new Extension(Extension.cRLDistributionPoints, true, crlDistPoint.getEncoded());
    }

    public static Extension genFreshestCRL(String drlLdapUrl) throws IOException {
        DistributionPointName dpn = GMSSLExtensionUtils.genDistributionPointName(drlLdapUrl);
        CRLDistPoint crlDistPoint = new CRLDistPoint(new DistributionPoint[]{new DistributionPoint(dpn, null, null)});
        return new Extension(Extension.freshestCRL, true, crlDistPoint.getEncoded());
    }

    public static List<Extension> getCertificateExtensions(X509Certificate cert) throws CertificateEncodingException, IOException {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        X509CertificateHolder holder = new X509CertificateHolder(cert.getEncoded());
        List list = holder.getExtensionOIDs();
        for (Object e : list) {
            extensions.add(holder.getExtension((ASN1ObjectIdentifier)e));
        }
        return extensions;
    }

    public static Extension genSubjectDirectoryAttributesExtension(String title, boolean critical) throws IOException {
        Vector<Attribute> attributes = new Vector<Attribute>();
        if (title != null) {
            attributes.add(GMSSLExtensionUtils.makeAttribute(BCStyle.T, title));
        }
        attributes.add(GMSSLExtensionUtils.makeAttribute(BCStyle.COUNTRY_OF_CITIZENSHIP, "CN"));
        SubjectDirectoryAttributes subjectDirectoryAttributes = new SubjectDirectoryAttributes(attributes);
        return new Extension(Extension.subjectDirectoryAttributes, critical, subjectDirectoryAttributes.getEncoded());
    }

    public static Attribute makeAttribute(ASN1ObjectIdentifier oid, String value) {
        DERSet valueSet = new DERSet((ASN1Encodable)new DEROctetString(value.getBytes()));
        return new Attribute(oid, (ASN1Set)valueSet);
    }

    public static void parseAttribute(Attribute attribute, ASN1ObjectIdentifier oid, String valueName, StringBuilder sb) {
        if (oid.equals((Object)attribute.getAttrType())) {
            ASN1Set set = attribute.getAttrValues();
            ASN1OctetString valueInstance = DEROctetString.getInstance((Object)set.getObjectAt(0));
            String value = new String(valueInstance.getOctets());
            sb.append(valueName).append("=").append(value).append(",");
        }
    }

    public static String parseSubjectDirectoryAttributesExtensions(byte[] octets) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        SubjectDirectoryAttributes subjectDirectoryAttributes = SubjectDirectoryAttributes.getInstance((Object)octets);
        Vector attributes = subjectDirectoryAttributes.getAttributes();
        for (Object attr : attributes) {
            Attribute attribute = (Attribute)attr;
            GMSSLExtensionUtils.parseAttribute(attribute, BCStyle.T, "Title", sb);
            GMSSLExtensionUtils.parseAttribute(attribute, BCStyle.COUNTRY_OF_CITIZENSHIP, "CountryOfCitizenship", sb);
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    public static Extension genARLExtension(String arlLdapUrl) throws IOException {
        DistributionPointName dpn = GMSSLExtensionUtils.genDistributionPointName(arlLdapUrl);
        ReasonFlags reasonFlags = new ReasonFlags(32);
        IssuingDistributionPoint point = new IssuingDistributionPoint(dpn, false, true, reasonFlags, false, false);
        return new Extension(Extension.issuingDistributionPoint, true, point.getEncoded());
    }

    public static Extension genDRLExtension(int baseNumber) throws IOException {
        CRLNumber basecrlnum = new CRLNumber(BigInteger.valueOf(baseNumber));
        return new Extension(Extension.deltaCRLIndicator, true, basecrlnum.getEncoded());
    }

    public static DistributionPointName genDistributionPointName(String ldapUrl) {
        DEROctetString instance = new DEROctetString(ldapUrl.getBytes());
        GeneralName gn = new GeneralName(6, (ASN1Encodable)instance);
        GeneralNames gns = new GeneralNames(gn);
        return new DistributionPointName(0, (ASN1Encodable)gns);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

