package com.xdja.pki.gmssl.crypto.utils;


import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import org.bouncycastle.jce.provider.BouncyCastleProvider;


import java.security.Security;

public class GMSSLSM1CBCEncryptUtils {
    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    /**
     * 使用 加密机Yunhsm 进行加密 NoPadding填充  传入明文为16整数倍
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data   BASE64 编码 待加密消息 转换为byte[]数组后长度为16整数倍
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 密文消息
     */
    public static String encryptByYumhsmWithNoPadding(String base64Key, String base64Data, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    /**
     * 使用 加密机Yunhsm 进行加密 PKCS5Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data   BASE64 编码 待加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 密文消息
     */
    public static String encryptByYumhsmWithPKCS5Padding(String base64Key, String base64Data, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    /**
     * 使用 加密机Yunhsm 进行加密 PKCS7Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data   BASE64 编码 待加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 密文消息
     */
    public static String encryptByYumhsmWithPKCS7Padding(String base64Key, String base64Data, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    /**
     * 使用 加密机Yunhsm 进行加密 SSL3Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data   BASE64 编码 待加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 密文消息
     */
    public static String encryptByYumhsmWithSSL3Padding(String base64Key, String base64Data, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(true, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    /**
     * 使用 加密机Yunhsm 进行解密 NoPadding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息 转换为byte[]数组后长度为16整数倍
     * @return BASE64 编码 明文消息
     */
    public static String decryptByYumhsmWithNoPadding(String base64Key, String base64Cipher, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    /**
     * 使用 加密机Yunhsm 进行解密 PKCS5Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 明文消息
     */
    public static String decryptByYumhsmWithPKCS5Padding(String base64Key, String base64Cipher, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    /**
     * 使用 加密机Yunhsm 进行解密 PKCS7Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 明文消息
     */
    public static String decryptByYumhsmWithPKCS7Padding(String base64Key, String base64Cipher, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    /**
     * 使用 加密机Yunhsm 进行解密 SSL3Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 明文消息
     */
    public static String decryptByYumhsmWithSSL3Padding(String base64Key, String base64Cipher, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(false, SdfCryptoType.YUNHSM,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    /**
     * 使用 PCIE 进行加密 NoPadding填充  传入明文为16整数倍
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data   BASE64 编码 待加密消息 转换为byte[]数组后长度为16整数倍
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 密文消息
     */
    public static String encryptByPcieWithNoPadding(String base64Key, String base64Data, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    /**
     * 使用 PCIE 进行加密 PKCS5Padding
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data   BASE64 编码 待加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 密文消息
     */
    public static String encryptByPcieWithPKCS5Padding(String base64Key, String base64Data, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    /**
     * 使用 PCIE 进行加密 PKCS7Padding
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data   BASE64 编码 待加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 密文消息
     */
    public static String encryptByPcieWithPKCS7Padding(String base64Key, String base64Data, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    /**
     * 使用 PCIE 进行加密 SSL3Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Data   BASE64 编码 待加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 密文消息
     */
    public static String encryptByPcieWithSSL3Padding(String base64Key, String base64Data, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(true, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Data)));
    }

    /**
     * 使用 PCIE 进行解密  NoPadding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息 转换为byte[]数组后长度为16整数倍
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 明文消息
     */
    public static String decryptByPcieWithNoPadding(String base64Key, String base64Cipher, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.NoPadding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    /**
     * 使用 PCIE 进行解密 PKCS5Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 明文消息
     */
    public static String decryptByPcieWithPKCS5Padding(String base64Key, String base64Cipher, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS5Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    /**
     * 使用 PCIE 进行解密 PKCS7Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 明文消息
     */
    public static String decryptByPcieWithPKCS7Padding(String base64Key, String base64Cipher, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.PKCS7Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    /**
     * 使用 PCIE 进行解密 SSL3Padding填充
     *
     * @param base64Key    BASE64 编码 会话密钥 转换为byte[]数组后长度为16
     * @param base64Cipher BASE64 编码 加密消息
     * @param base64InitIv BASE64 编码 初始化向量 转换为byte[]数组后长度为16
     * @return BASE64 编码 明文消息
     */
    public static String decryptByPcieWithSSL3Padding(String base64Key, String base64Cipher, String base64InitIv) throws SdfSDKException {
        return GMSSLByteArrayUtils.base64Encode(sm1SymmetricSdfWithPadding(false, SdfCryptoType.PCIE,
                SdfSymmetricKeyParameters.PaddingType.SSL3Padding,
                GMSSLByteArrayUtils.base64Decode(base64Key),
                GMSSLByteArrayUtils.base64Decode(base64InitIv),
                GMSSLByteArrayUtils.base64Decode(base64Cipher)));
    }

    /**
     * 使用 padding模式填充的加解密公用类 YUNHSM
     *
     * @param forEncryption 是否为加密
     * @param paddingType   填充类型 NoPadding PKCS5Padding PKCS7Padding SSL3Padding
     * @param key           byte[] 会话密钥 长度为16
     * @param iv            byte[] 初始化向量长度为16
     * @param data          byte[] 数组 待加密消息或已加密消息
     * @return byte[] 编码 明文消息
     */
    public static byte[] sm1SymmetricWithPaddingByYunHsm(boolean forEncryption,
                                                         SdfSymmetricKeyParameters.PaddingType paddingType,
                                                         byte[] key, byte[] iv, byte[] data) throws SdfSDKException {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptBySdf(forEncryption, SdfCryptoType.YUNHSM,
                paddingType, key, SdfAlgIdSymmetric.SGD_SM1_CBC, iv, data);

    }

    /**
     * 使用 padding模式填充的加解密公用类 PCIE
     *
     * @param forEncryption 是否为加密
     * @param paddingType   填充类型 NoPadding PKCS5Padding PKCS7Padding SSL3Padding
     * @param key           byte[] 会话密钥 长度为16
     * @param iv            byte[] 初始化向量长度为16
     * @param data          byte[] 数组 待加密消息或已加密消息
     * @return byte[] 编码 明文消息
     */
    public static byte[] sm1SymmetricWithPaddingByPCIE(boolean forEncryption,
                                                       SdfSymmetricKeyParameters.PaddingType paddingType,
                                                       byte[] key, byte[] iv, byte[] data) throws SdfSDKException {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptBySdf(forEncryption, SdfCryptoType.PCIE,
                paddingType, key, SdfAlgIdSymmetric.SGD_SM1_CBC, iv, data);

    }

    /**
     * 使用 padding模式填充的加解密公用类
     *
     * @param forEncryption 是否为加密
     * @param sdfCryptoType 加密使用类型 包括加密机YumHsm和PCIE卡
     * @param paddingType   填充类型 NoPadding PKCS5Padding PKCS7Padding SSL3Padding
     * @param key           byte[] 会话密钥 长度为16
     * @param iv            byte[] 初始化向量长度为16
     * @param data          byte[] 数组 待加密消息或已加密消息
     * @return byte[] 编码 明文消息
     */
    public static byte[] sm1SymmetricSdfWithPadding(boolean forEncryption, SdfCryptoType sdfCryptoType,
                                                    SdfSymmetricKeyParameters.PaddingType paddingType,
                                                    byte[] key, byte[] iv, byte[] data) throws SdfSDKException {
        return GMSSLSymmetricEncryptUtils.symmetricCBCEncryptBySdf(forEncryption, sdfCryptoType,
                paddingType, key, SdfAlgIdSymmetric.SGD_SM1_CBC, iv, data);

    }
}
