package com.xdja.pki.gmssl.keystore.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import javax.crypto.SecretKey;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.*;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.*;
import java.util.concurrent.atomic.AtomicLong;

public class GMSSLKeyStoreUtils {

    public static final String KEYSTORE_TYPE = "BKS";

    public static KeyStore generateGMSSLKeyStore(
            String password, X509Certificate rootCert,
            String signAlias, PrivateKey signKey, X509Certificate signCert,
            String encAlias, PrivateKey encKey, X509Certificate encCert
    ) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE, BouncyCastleProvider.PROVIDER_NAME);
        keyStore.load(null, null);
        keyStore.setKeyEntry(signAlias, signKey, password.toCharArray(), new X509Certificate[]{signCert, rootCert});
        keyStore.setKeyEntry(encAlias, encKey, password.toCharArray(), new X509Certificate[]{encCert, rootCert});
        return keyStore;
    }

    public static KeyStore generateGMSSLTrustStore(X509Certificate rootCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE, BouncyCastleProvider.PROVIDER_NAME);
        keyStore.load(null, null);
        keyStore.setCertificateEntry("trust", rootCert);
        return keyStore;
    }

    public static void saveGMSSLKeyStore(
            KeyStore keyStore, String password, String path, String name
    ) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        FileOutputStream out = new FileOutputStream(path + "/" + name + ".keystore");
        keyStore.store(out, password.toCharArray());
        out.close();
    }

    public static void saveGMSSLPfx(
            KeyStore keyStore, String password, String path, String name
    ) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        FileOutputStream out = new FileOutputStream(path + "/" + name + ".pfx");
        keyStore.store(out, password.toCharArray());
        out.close();
    }
    public static void printGMSSLKeyStore(String file, String password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, NoSuchProviderException, CertificateException {
        FileInputStream in = new FileInputStream(file);
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE, BouncyCastleProvider.PROVIDER_NAME);
        keyStore.load(in, password.toCharArray());
        printGMSSLKeyStore(keyStore, password);
    }

    public static void printGMSSLKeyStore(KeyStore keyStore, String password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        System.out.println("Keystore type: " + keyStore.getType());
        System.out.println("Keystore provider: " + keyStore.getProvider());
        System.out.println();
        System.out.println("Your keystore contains " + keyStore.size() + " entries");
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            System.out.println();
            String alias = aliases.nextElement();
            System.out.println("Alias name: " + alias);
            System.out.println("Creation date: " + keyStore.getCreationDate(alias));
            if (keyStore.isKeyEntry(alias)) {
                System.out.println("Entry type: PrivateKeyEntry");
                Key key = keyStore.getKey(alias, password.toCharArray());
                System.out.println("Key Algorithm: " + key.getAlgorithm());
                if (key instanceof SecretKey) {
                    SdfPrivateKey sdfPrivateKey = SdfPrivateKey.getInstance(key);
                    System.out.println(sdfPrivateKey);
                } else {
                    System.out.println(key);
                }
                Certificate[] certificateChain = keyStore.getCertificateChain(alias);
                System.out.println("Certificate chain length: " + certificateChain.length);
                for (int i = 1; i <= certificateChain.length; i++) {
                    System.out.println("Certificate[" + i + "]: ");
                    System.out.println(certificateChain[i - 1]);
                }
            } else if (keyStore.isCertificateEntry(alias)) {
                System.out.println("Entry type: PrivateKeyEntry");
                Certificate certificate = keyStore.getCertificate(alias);
                System.out.println(certificate);
            } else {
                System.out.println("UnKnown type alias : " + alias);
            }
        }
    }
}
