package com.xdja.pki.gmssl.tomcat.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.File;


class ServerXmlResolver {

    private  NodeList childNodes;
    private  Element serviceItem;
    private  Document doc;
    private  File file;

    private  void resolveServerXml(String tomcatPath) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        //String path = "F:\\ldap\\CertBuilder\\src\\main\\resources\\server.xml";
        this.file = new File(tomcatPath + File.separator + "conf" + File.separator + "server.xml");
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.parse(this.file);
        //获取根root模块
        Element root = this.doc.getDocumentElement();
        NodeList service = root.getElementsByTagName("Service");

        //获取Service模块
        this.serviceItem = (Element) service.item(0);
        //获取Service子Nodes
        this.childNodes = this.serviceItem.getChildNodes();

    }

    private  void writeToXml() throws Exception {
        //将修改后的文件重新写入
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Source source = new DOMSource(this.doc);
        Result result = new StreamResult(this.file);
        transformer.transform(source, result);//将 XML==>Source 转换为 Result
    }

    public  void addTomcatHttpsPort(String tomcatPath, String sslProtocol, int port) throws Exception {
        resolveServerXml(tomcatPath);
        //遍历Service模块
        boolean flag = false;
        for (int i = 0; i < this.childNodes.getLength(); i++) {
            Node item = this.childNodes.item(i);
            String nodeName = this.childNodes.item(i).getNodeName();
            //当遍历到Service的Connector时
            if (nodeName.equalsIgnoreCase("Connector")) {
                Element element = (Element) item;
                if (element.getAttribute("port").equalsIgnoreCase(String.valueOf(port))) {
                    Element connect = this.doc.createElement("Connector");
                    Element node = createHttpsElement(connect, port, sslProtocol);
                    this.serviceItem.replaceChild(node, element);
                    //有与传入端口相同的端口开启，在配置文件中直接修改并设定标志为ture，该标志表示以及存在相同端口，避免再次添加
                    flag = true;
                }
            }
        }
        //没有与传入端口相同的端口开启，则在配置文件中直接添加
        if (!flag) {
            Element connect = this.doc.createElement("Connector");
            Element node = createHttpsElement(connect, port, sslProtocol);
            this.serviceItem.appendChild(node);
        }
        writeToXml();
    }

    public  void addTomcatHttpPort(String tomcatPath, int port) throws Exception {
        resolveServerXml(tomcatPath);
        //遍历Service模块
        boolean flag = false;
        for (int i = 0; i < this.childNodes.getLength(); i++) {
            Node item = this.childNodes.item(i);
            String nodeName = this.childNodes.item(i).getNodeName();
            //当遍历到Service的Connector时
            if (nodeName.equalsIgnoreCase("Connector")) {
                Element element = (Element) item;
                if (element.getAttribute("port").equalsIgnoreCase(String.valueOf(port))) {
                    Element connect = this.doc.createElement("Connector");
                    Element node = createHttpElement(connect, port);
                    this.serviceItem.replaceChild(node, element);
                    //有与传入端口相同的端口开启，在配置文件中直接修改并设定标志为ture，该标志表示以及存在相同端口，避免再次添加
                    flag = true;
                }
            }
        }
        //没有与传入端口相同的端口开启，则在配置文件中直接添加
        if (!flag) {
            Element connect = this.doc.createElement("Connector");
            Element node = createHttpElement(connect, port);
            this.serviceItem.appendChild(node);
        }
        writeToXml();
    }


    public  void closeTomcatPort(String tomcatPath, int port) throws Exception {
        resolveServerXml(tomcatPath);
        for (int i = 0; i < this.childNodes.getLength(); i++) {
            Node item = this.childNodes.item(i);
            String nodeName = this.childNodes.item(i).getNodeName();
            //当遍历到Service的Connector时
            if (nodeName.equalsIgnoreCase("Connector")) {
                Element element = (Element) item;
                if (String.valueOf(port).equalsIgnoreCase(element.getAttribute("port"))) {
                    //如果是https
                    if ("https".equalsIgnoreCase(element.getAttribute("scheme"))) {
                        String certPath = tomcatPath + File.separator + "conf" + File.separator + "cert" + File.separator + port;
                        GMSSLX509Utils.deleteDirectory(certPath);
                    }
                    this.serviceItem.removeChild(element);
                }
            }
        }
        writeToXml();
    }


    private  Element createHttpElement(Element connect, int port) {
        connect.setAttribute("port", String.valueOf(port));
        connect.setAttribute("protocol", "HTTP/1.1");
        connect.setAttribute("connectionTimeout", "20000");
        connect.setAttribute("redirectPort", "8443");
        return connect;
    }

    private  Element createHttpsElement(Element connect, int port, String sslProtocol) {
        connect.setAttribute("port", String.valueOf(port));
        connect.setAttribute("protocol", "org.apache.coyote.http11.Http11NioProtocol");
        connect.setAttribute("maxThreads", "150");
        connect.setAttribute("scheme", "https");
        connect.setAttribute("SSLEnabled", "true");
        connect.setAttribute("sslProtocol", sslProtocol);
        connect.setAttribute("secure", "true");
        connect.setAttribute("secure", "true");
        connect.setAttribute("sslImplementationName", "com.xdja.pki.gmssl.tomcat.plugin.XDJAJSSEImplementation");
        connect.setAttribute("keystoreFile", "conf/cert/" + port + "/server.keystore");
        connect.setAttribute("keystorePass", "password");
        connect.setAttribute("keystoreProvider", "BC");
        connect.setAttribute("keystoreType", "BKS");
        connect.setAttribute("truststoreFile", "conf/cert/" + port + "/trust.keystore");
        connect.setAttribute("truststorePass", "password");
        connect.setAttribute("truststoreProvider", "BC");
        connect.setAttribute("truststoreType", "BKS");
        return connect;
    }

}
