package com.xdja.pki.gmssl.x509.utils.bean;

public enum YunHsmExceptionEnum {

    NORMAL(0, "密码机服务正常"),

    TELNET_PORT_FAILURE(1, "密码机服务端口不通"),

    SIGN_PASSWORD_IS_ERROR(2, "签名证书保护口令不能打开签名证书"),

    ENC_PASSWORD_IS_ERROR(3, "加密证书保护口令不能打开加密证书"),

    SIGN_CERT_VERIFY_IS_ERROR(4, "签名证书验签不通过"),

    ENC_CERT_VERIFY_IS_ERROR(5, "加密证书验签不通过"),

    OPEN_DEVICE_IS_FAILURE(6, "获取设备信息失败"),

    OPEN_TRAIN_CERT_P7b_IS_ERROR(7, "解析密码机CA证书链失败");

    public int id;
    public String value;

    private YunHsmExceptionEnum(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public static String getValueFromId(int id) {
        for (YunHsmExceptionEnum t : YunHsmExceptionEnum.values()) {
            if (t.id == id) {
                return t.value;
            }
        }
        throw new IllegalArgumentException(String.format("YunHsmExceptionEnum 枚举转换异常[id=%d]", id));
    }
}
