/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfRandom;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLRandomUtils {
    public static String generateRandomByYunhsm(int len) throws SdfSDKException {
        return GMSSLRandomUtils.generateRandomBySdf(SdfCryptoType.YUNHSM, len);
    }

    public static String generateRandomByPcie(int len) throws SdfSDKException {
        return GMSSLRandomUtils.generateRandomBySdf(SdfCryptoType.PCIE, len);
    }

    public static String generateRandomBySdf(SdfCryptoType sdfCryptoType, int len) throws SdfSDKException {
        SdfRandom sdfRandom = new SdfRandom(sdfCryptoType);
        byte[] random = sdfRandom.generateRandom(len);
        return GMSSLByteArrayUtils.base64Encode((byte[])random);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

