/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.crypto.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Key;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GMSSLSM2KeyUtils {
    public static KeyPair generateSM2KeyPairByBC() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return GMSSLX509Utils.generateSM2KeyPair();
    }

    public static SdfPrivateKey genSdfPrivateKey(int index, String password) {
        return new SdfPrivateKey(index, password.getBytes());
    }

    public static PublicKey getSignPublicKeyByYunhsm(int index) throws SdfSDKException {
        SdfSM2Key sdfSM2Key = new SdfSM2Key(SdfCryptoType.YUNHSM);
        PublicKey publicKey = sdfSM2Key.exportSignPublicKey(index);
        sdfSM2Key.release();
        return publicKey;
    }

    public static PublicKey getSignPublicKeyByPcie(int index) throws SdfSDKException {
        SdfSM2Key sdfSM2Key = new SdfSM2Key(SdfCryptoType.PCIE);
        PublicKey publicKey = sdfSM2Key.exportSignPublicKey(index);
        sdfSM2Key.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByYunhsm(int index) throws SdfSDKException {
        SdfSM2Key sdfSM2Key = new SdfSM2Key(SdfCryptoType.YUNHSM);
        PublicKey publicKey = sdfSM2Key.exportEncryptPublicKey(index);
        sdfSM2Key.release();
        return publicKey;
    }

    public static PublicKey getEncryptPublicKeyByPcie(int index) throws SdfSDKException {
        SdfSM2Key sdfSM2Key = new SdfSM2Key(SdfCryptoType.PCIE);
        PublicKey publicKey = sdfSM2Key.exportEncryptPublicKey(index);
        sdfSM2Key.release();
        return publicKey;
    }

    public static boolean getPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return GMSSLSM2KeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.YUNHSM, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromYunHsm(int index, String password) {
        return GMSSLSM2KeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.YUNHSM, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromPCIE(int index, String password) {
        return GMSSLSM2KeyUtils.checkPrivateKeyAccessRightFromSdf(SdfCryptoType.PCIE, index, password);
    }

    public static boolean checkPrivateKeyAccessRightFromSdf(SdfCryptoType sdfCryptoType, int index, String password) {
        try {
            SdfSDK sdfSDK = sdfCryptoType.getSdfSDK();
            sdfSDK.init();
            boolean result = sdfSDK.checkPrivateKeyAccessRight(index, password.getBytes());
            sdfSDK.release();
            return result;
        }
        catch (SdfSDKException e) {
            return false;
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

