/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.keystore.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLKeyStoreUtils {
    public static final String KEYSTORE_TYPE = "BKS";
    private static Logger logger = LoggerFactory.getLogger(GMSSLExtensionUtils.class);

    public static KeyStore generateGMSSLKeyStore(String password, X509Certificate rootCert, String signAlias, PrivateKey signKey, X509Certificate signCert, String encAlias, PrivateKey encKey, X509Certificate encCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
        keyStore.load(null, null);
        keyStore.setKeyEntry(signAlias, signKey, password.toCharArray(), new X509Certificate[]{signCert, rootCert});
        keyStore.setKeyEntry(encAlias, encKey, password.toCharArray(), new X509Certificate[]{encCert, rootCert});
        return keyStore;
    }

    public static KeyStore generateGMSSLTrustStore(X509Certificate rootCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
        keyStore.load(null, null);
        keyStore.setCertificateEntry("trust", rootCert);
        return keyStore;
    }

    public static KeyStore generateGMSSLTrustStore(X509Certificate[] rootCerts) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
        keyStore.load(null, null);
        for (int i = 0; i < rootCerts.length; ++i) {
            keyStore.setCertificateEntry("trust-" + i, rootCerts[i]);
        }
        for (X509Certificate x509Certificate : rootCerts) {
        }
        return keyStore;
    }

    public static KeyStore generateGMSSLTrustStore(List<X509Certificate> rootCert) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
        keyStore.load(null, null);
        for (int i = 0; i < rootCert.size(); ++i) {
            keyStore.setCertificateEntry("trust-" + i, rootCert.get(i));
        }
        return keyStore;
    }

    public static void saveGMSSLKeyStore(KeyStore keyStore, String password, String path, String name) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        FileOutputStream out = new FileOutputStream(path + "/" + name + ".keystore");
        keyStore.store(out, password.toCharArray());
        out.close();
    }

    public static void saveGMSSLPfx(KeyStore keyStore, String password, String path, String name) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        FileOutputStream out = new FileOutputStream(path + "/" + name + ".pfx");
        keyStore.store(out, password.toCharArray());
        out.close();
    }

    public static void saveGMSSLKeyStoreEntry(String file, String password, String path) throws Exception {
        InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)file);
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
        keyStore.load(in, password.toCharArray());
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(keyStore, password, path);
    }

    public static void printGMSSLKeyStore(String file, String password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, NoSuchProviderException, CertificateException {
        InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)file);
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE, "BC");
        keyStore.load(in, password.toCharArray());
        GMSSLKeyStoreUtils.printGMSSLKeyStore(keyStore, password);
    }

    public static void printGMSSLKeyStore(KeyStore keyStore, String password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        System.out.println("Keystore type: " + keyStore.getType());
        System.out.println("Keystore provider: " + keyStore.getProvider());
        System.out.println();
        System.out.println("Your keystore contains " + keyStore.size() + " entries");
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            System.out.println();
            String alias = aliases.nextElement();
            System.out.println("Alias name: " + alias);
            System.out.println("Creation date: " + keyStore.getCreationDate(alias));
            if (keyStore.isKeyEntry(alias)) {
                System.out.println("Entry type: PrivateKeyEntry");
                Key key = keyStore.getKey(alias, password.toCharArray());
                System.out.println("Key Algorithm: " + key.getAlgorithm());
                if (key instanceof SecretKey) {
                    SdfPrivateKey sdfPrivateKey = SdfPrivateKey.getInstance((Object)key);
                    System.out.println(sdfPrivateKey);
                } else {
                    System.out.println(key);
                }
                Certificate[] certificateChain = keyStore.getCertificateChain(alias);
                System.out.println("Certificate chain length: " + certificateChain.length);
                for (int i = 1; i <= certificateChain.length; ++i) {
                    System.out.println("Certificate[" + i + "]: ");
                    System.out.println(certificateChain[i - 1]);
                    X509Certificate cert = (X509Certificate)certificateChain[i - 1];
                    byte[] signature = cert.getSignature();
                    GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)("Certificate[" + i + "]: sign"), (byte[])signature);
                }
                continue;
            }
            if (keyStore.isCertificateEntry(alias)) {
                System.out.println("Entry type: PrivateKeyEntry");
                Certificate certificate = keyStore.getCertificate(alias);
                System.out.println(certificate);
                continue;
            }
            System.out.println("UnKnown type alias : " + alias);
        }
    }

    public static void saveGMSSLKeyStore(KeyStore keyStore, String password, String path) throws Exception {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (keyStore.isKeyEntry(alias)) {
                Key key = keyStore.getKey(alias, password.toCharArray());
                String pri = alias + "_pri";
                if (key instanceof SecretKey) {
                    SdfPrivateKey sdfPrivateKey = SdfPrivateKey.getInstance((Object)key);
                    assert (sdfPrivateKey != null);
                    GMSSLX509Utils.writeSdfPrivateKey((String)path, (String)pri, (PrivateKey)sdfPrivateKey);
                } else {
                    GMSSLX509Utils.writePrivateKeyToPem((String)path, (String)pri, (PrivateKey)((PrivateKey)key));
                }
                Certificate[] certificateChain = keyStore.getCertificateChain(alias);
                for (int i = 1; i <= certificateChain.length; ++i) {
                    GMSSLX509Utils.writeCertificateToPem((String)path, (String)(alias + "_cert_" + i), (X509Certificate)((X509Certificate)certificateChain[i - 1]));
                }
                continue;
            }
            if (keyStore.isCertificateEntry(alias)) {
                Certificate certificate = keyStore.getCertificate(alias);
                GMSSLX509Utils.writeCertificateToPem((String)path, (String)(alias + "_cert"), (X509Certificate)((X509Certificate)certificate));
                continue;
            }
            logger.error("UnKnown type alias : " + alias);
        }
    }
}

