/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class GMSSLContentSignerUtils {
    public static ContentSigner generateContentSignerByBC(GMSSLSignatureAlgorithm signatureAlgorithm, PrivateKey privateKey) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerByBC(signatureAlgorithm.getSigAlgName(), privateKey);
    }

    public static ContentSigner generateContentSignerByBC(String signAlgName, PrivateKey privateKey) throws OperatorCreationException {
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(signAlgName);
        return contentSignerBuilder.build(privateKey);
    }

    public static ContentSigner generateContentSignerByYunhsm(String signAlgName, PrivateKey privateKey) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerBySDF(SdfCryptoType.YUNHSM, signAlgName, privateKey);
    }

    public static ContentSigner generateContentSignerByPcie(String signAlgName, PrivateKey privateKey) throws OperatorCreationException {
        return GMSSLContentSignerUtils.generateContentSignerBySDF(SdfCryptoType.PCIE, signAlgName, privateKey);
    }

    public static ContentSigner generateContentSignerBySDF(SdfCryptoType sdfCryptoType, String signAlgName, PrivateKey privateKey) throws OperatorCreationException {
        if (!(privateKey instanceof SdfPrivateKey)) {
            throw new OperatorCreationException(" un support private key type " + privateKey.getClass());
        }
        return new SdfContentSigner(sdfCryptoType, (SdfPrivateKey)privateKey);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

