/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.operator.utils;

import com.xdja.pki.gmssl.crypto.sdf.SdfContentVerifier;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class GMSSLContentVerifierUtils {
    public static ContentVerifier generateContentVerifierByBC(GMSSLSignatureAlgorithm signatureAlgorithm, PublicKey publicKey) throws OperatorCreationException {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
        return verifierProvider.get(signatureAlgorithm.convertAlgorithmIdentifier());
    }

    public static ContentVerifier generateContentVerifierByBC(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) throws OperatorCreationException {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
        return verifierProvider.get(algorithmIdentifier);
    }

    public static ContentVerifier generateContentVerifierByYunhsm(PublicKey publicKey) throws OperatorCreationException {
        return GMSSLContentVerifierUtils.generateContentVerifierBySdf(SdfCryptoType.YUNHSM, publicKey);
    }

    public static ContentVerifier generateContentVerifierByPcie(PublicKey publicKey) throws OperatorCreationException {
        return GMSSLContentVerifierUtils.generateContentVerifierBySdf(SdfCryptoType.PCIE, publicKey);
    }

    public static ContentVerifier generateContentVerifierBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey) throws OperatorCreationException {
        return new SdfContentVerifier(sdfCryptoType, (ECPublicKey)publicKey);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

