/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.tomcat.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.tomcat.utils.ServerXmlResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLTomcatUtils {
    private static Logger logger = LoggerFactory.getLogger(GMSSLTomcatUtils.class);

    public static void openHttpsPortByBC(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        GMSSLTomcatUtils.saveKeyStore(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, String.valueOf(port));
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, "GMSSLV1.1", port);
    }

    public static void openHttpsPortByBC(List<X509Certificate> trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        GMSSLTomcatUtils.saveKeyStore(trustCert, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, tomcatPath, String.valueOf(port));
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, "GMSSLV1.1", port);
    }

    public static void openHttpsPortByYunHsm(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword.getBytes());
        GMSSLTomcatUtils.saveKeyStore(trustCert, serveSignCert, serverEncCert, (PrivateKey)sdfPrivateKey, (PrivateKey)sdfPrivateKey, tomcatPath, String.valueOf(port));
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, "GMSSLSDFYUNHSMV1.1", port);
    }

    public static void openHttpsPortByYunHsm(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword.getBytes());
        GMSSLTomcatUtils.saveKeyStore(trustCerts, serveSignCert, serverEncCert, (PrivateKey)sdfPrivateKey, (PrivateKey)sdfPrivateKey, tomcatPath, String.valueOf(port));
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, "GMSSLSDFYUNHSMV1.1", port);
    }

    public static void openHttpsPortByPCIE(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword.getBytes());
        GMSSLTomcatUtils.saveKeyStore(trustCert, serveSignCert, serverEncCert, (PrivateKey)sdfPrivateKey, (PrivateKey)sdfPrivateKey, tomcatPath, String.valueOf(port));
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, "GMSSLSDFPCIEV1.1", port);
    }

    public static void openHttpsPortByPCIE(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, int caServerPrivateKeyIndex, String caServerPrivateKeyPassword, String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        SdfPrivateKey sdfPrivateKey = new SdfPrivateKey(caServerPrivateKeyIndex, caServerPrivateKeyPassword.getBytes());
        GMSSLTomcatUtils.saveKeyStore(trustCerts, serveSignCert, serverEncCert, (PrivateKey)sdfPrivateKey, (PrivateKey)sdfPrivateKey, tomcatPath, String.valueOf(port));
        serverXmlResolver.addTomcatHttpsPort(tomcatPath, "GMSSLSDFPCIEV1.1", port);
    }

    public static void openHttpPort(String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.addTomcatHttpPort(tomcatPath, port);
    }

    public static void closeTomcatPort(String tomcatPath, int port) throws Exception {
        ServerXmlResolver serverXmlResolver = new ServerXmlResolver();
        serverXmlResolver.closeTomcatPort(tomcatPath, port);
    }

    public static boolean restartTomcat(String tomcatPath) {
        if (!GMSSLTomcatUtils.shutdownTomcat(tomcatPath)) {
            return false;
        }
        return GMSSLTomcatUtils.startupTomcat(tomcatPath);
    }

    public static boolean restartTomcat(String tomcatPath, String shutdownShellPath) {
        if (!GMSSLTomcatUtils.run(tomcatPath, "shutdown.sh " + tomcatPath, true, shutdownShellPath)) {
            return false;
        }
        return GMSSLTomcatUtils.startupTomcat(tomcatPath);
    }

    public static boolean shutdownTomcat(String tomcatPath) {
        return GMSSLTomcatUtils.run(tomcatPath, "shutdown", false, new String[0]);
    }

    public static boolean startupTomcat(String tomcatPath) {
        return GMSSLTomcatUtils.run(tomcatPath, "startup", false, new String[0]);
    }

    private static void saveKeyStore(X509Certificate trustCert, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String path, String port) throws Exception {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(trustCert);
        GMSSLTomcatUtils.saveKeyStore(certs, serveSignCert, serverEncCert, serverSignPriKey, serverEncPriKey, path, port);
    }

    private static void saveKeyStore(List<X509Certificate> trustCerts, X509Certificate serveSignCert, X509Certificate serverEncCert, PrivateKey serverSignPriKey, PrivateKey serverEncPriKey, String path, String port) throws Exception {
        File pathf = new File(path = path + File.separator + "conf" + File.separator + "cert" + File.separator + port + File.separator);
        if (!pathf.exists()) {
            pathf.mkdirs();
        }
        String password = "password";
        String signAlias = "sign";
        String encAlias = "enc";
        KeyStore serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStore(password, trustCerts.get(0), signAlias, serverSignPriKey, serveSignCert, encAlias, serverEncPriKey, serverEncCert);
        for (int i = 0; i < trustCerts.size(); ++i) {
            if (GMSSLX509Utils.verifyCert((X509Certificate)serveSignCert, (PublicKey)trustCerts.get(i).getPublicKey())) {
                serverKeyStore = GMSSLKeyStoreUtils.generateGMSSLKeyStore(password, trustCerts.get(i), signAlias, serverSignPriKey, serveSignCert, encAlias, serverEncPriKey, serverEncCert);
            }
            GMSSLX509Utils.writeCertificateToPem((String)path, (String)("ca_" + i), (X509Certificate)trustCerts.get(i));
            GMSSLX509Utils.writeObjectToPem((String)path, (String)("ca_public_" + i), (Object)trustCerts.get(i).getPublicKey());
            GMSSLX509Utils.writeCertificateToCer((String)path, (String)("ca_" + i), (X509Certificate)trustCerts.get(i));
        }
        KeyStore trustKeyStore = GMSSLKeyStoreUtils.generateGMSSLTrustStore(trustCerts);
        GMSSLX509Utils.writeCertificateToPem((String)path, (String)"sign", (X509Certificate)serveSignCert);
        GMSSLX509Utils.writeObjectToPem((String)path, (String)"sign_public", (Object)serveSignCert.getPublicKey());
        if (serverSignPriKey instanceof SdfPrivateKey) {
            GMSSLX509Utils.writeSdfPrivateKey((String)path, (String)"ca_server_key", (PrivateKey)serverSignPriKey);
        } else {
            GMSSLX509Utils.writeObjectToPem((String)path, (String)"sign_private", (Object)serverSignPriKey);
            GMSSLX509Utils.writeObjectToPem((String)path, (String)"enc_private", (Object)serverEncPriKey);
            GMSSLX509Utils.writeKeyStoreToP12((KeyStore)serverKeyStore, (char[])"password".toCharArray(), (String)path, (String)"sign");
            GMSSLX509Utils.writeKeyStoreToP12((KeyStore)serverKeyStore, (char[])"password".toCharArray(), (String)path, (String)"enc");
            GMSSLX509Utils.writeKeyStoreToP12((KeyStore)trustKeyStore, (char[])"password".toCharArray(), (String)path, (String)"trust");
        }
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"sign", (X509Certificate)serveSignCert);
        GMSSLX509Utils.writeCertificateToPem((String)path, (String)"enc", (X509Certificate)serverEncCert);
        GMSSLX509Utils.writeCertificateToCer((String)path, (String)"enc", (X509Certificate)serverEncCert);
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(serverKeyStore, "password", path, "server");
        GMSSLKeyStoreUtils.saveGMSSLKeyStore(trustKeyStore, "password", path, "trust");
    }

    private static boolean run(String tomcatPath, String shName, boolean isUseShutdownSh, String ... shPath) {
        Runtime rt = Runtime.getRuntime();
        Process ps = null;
        try {
            String os = System.getProperty("os.name");
            if (shName.contains("shut")) {
                logger.info("=================\u5f00\u59cb\u5173\u95edTomcat=================");
            } else {
                logger.info("=================\u5f00\u59cb\u542f\u52a8Tomcat=================");
            }
            ps = os.startsWith("Windows") ? rt.exec("cmd /c " + tomcatPath + File.separator + "bin" + File.separator + shName + ".bat", null, new File(tomcatPath)) : (isUseShutdownSh ? rt.exec("sh " + shPath[0] + File.separator + shName, null, new File(shPath[0])) : rt.exec("sh " + tomcatPath + File.separator + "bin" + File.separator + shName + ".sh", null, new File(tomcatPath)));
            InputStream is = ps.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ps.waitFor();
            is.close();
            reader.close();
            ps.destroy();
            logger.info("=================\u5b8c\u6210=================");
            return true;
        }
        catch (Exception e) {
            logger.error(shName + " tomcat is error ", (Throwable)e);
            return false;
        }
    }
}

