/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.tomcat.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ServerXmlResolver {
    private NodeList childNodes;
    private Element serviceItem;
    private Document doc;
    private File file;

    ServerXmlResolver() {
    }

    private void resolveServerXml(String tomcatPath) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        this.file = new File(tomcatPath + File.separator + "conf" + File.separator + "server.xml");
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.parse(this.file);
        Element root = this.doc.getDocumentElement();
        NodeList service = root.getElementsByTagName("Service");
        this.serviceItem = (Element)service.item(0);
        this.childNodes = this.serviceItem.getChildNodes();
    }

    private void writeToXml() throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(this.file);
        transformer.transform(source, result);
    }

    public void addTomcatHttpsPort(String tomcatPath, String sslProtocol, int port) throws Exception {
        this.resolveServerXml(tomcatPath);
        boolean flag = false;
        for (int i = 0; i < this.childNodes.getLength(); ++i) {
            Element element;
            Node item = this.childNodes.item(i);
            String nodeName = this.childNodes.item(i).getNodeName();
            if (!nodeName.equalsIgnoreCase("Connector") || !(element = (Element)item).getAttribute("port").equalsIgnoreCase(String.valueOf(port))) continue;
            Element connect = this.doc.createElement("Connector");
            Element node = this.createHttpsElement(connect, port, sslProtocol);
            this.serviceItem.replaceChild(node, element);
            flag = true;
        }
        if (!flag) {
            Element connect = this.doc.createElement("Connector");
            Element node = this.createHttpsElement(connect, port, sslProtocol);
            this.serviceItem.appendChild(node);
        }
        this.writeToXml();
    }

    public void addTomcatHttpPort(String tomcatPath, int port) throws Exception {
        this.resolveServerXml(tomcatPath);
        boolean flag = false;
        for (int i = 0; i < this.childNodes.getLength(); ++i) {
            Element element;
            Node item = this.childNodes.item(i);
            String nodeName = this.childNodes.item(i).getNodeName();
            if (!nodeName.equalsIgnoreCase("Connector") || !(element = (Element)item).getAttribute("port").equalsIgnoreCase(String.valueOf(port))) continue;
            Element connect = this.doc.createElement("Connector");
            Element node = this.createHttpElement(connect, port);
            this.serviceItem.replaceChild(node, element);
            flag = true;
        }
        if (!flag) {
            Element connect = this.doc.createElement("Connector");
            Element node = this.createHttpElement(connect, port);
            this.serviceItem.appendChild(node);
        }
        this.writeToXml();
    }

    public void closeTomcatPort(String tomcatPath, int port) throws Exception {
        this.resolveServerXml(tomcatPath);
        for (int i = 0; i < this.childNodes.getLength(); ++i) {
            Node item = this.childNodes.item(i);
            String nodeName = this.childNodes.item(i).getNodeName();
            if (!nodeName.equalsIgnoreCase("Connector")) continue;
            Element element = (Element)item;
            if (!String.valueOf(port).equalsIgnoreCase(element.getAttribute("port"))) continue;
            if ("https".equalsIgnoreCase(element.getAttribute("scheme"))) {
                String certPath = tomcatPath + File.separator + "conf" + File.separator + "cert" + File.separator + port;
                GMSSLX509Utils.deleteDirectory((String)certPath);
            }
            this.serviceItem.removeChild(element);
        }
        this.writeToXml();
    }

    private Element createHttpElement(Element connect, int port) {
        connect.setAttribute("port", String.valueOf(port));
        connect.setAttribute("protocol", "HTTP/1.1");
        connect.setAttribute("connectionTimeout", "20000");
        connect.setAttribute("redirectPort", "8443");
        return connect;
    }

    private Element createHttpsElement(Element connect, int port, String sslProtocol) {
        connect.setAttribute("port", String.valueOf(port));
        connect.setAttribute("protocol", "org.apache.coyote.http11.Http11NioProtocol");
        connect.setAttribute("maxThreads", "150");
        connect.setAttribute("scheme", "https");
        connect.setAttribute("SSLEnabled", "true");
        connect.setAttribute("sslProtocol", sslProtocol);
        connect.setAttribute("secure", "true");
        connect.setAttribute("secure", "true");
        connect.setAttribute("sslImplementationName", "com.xdja.pki.gmssl.tomcat.plugin.XDJAJSSEImplementation");
        connect.setAttribute("keystoreFile", "conf/cert/" + port + "/server.keystore");
        connect.setAttribute("keystorePass", "password");
        connect.setAttribute("keystoreProvider", "BC");
        connect.setAttribute("keystoreType", "BKS");
        connect.setAttribute("truststoreFile", "conf/cert/" + port + "/trust.keystore");
        connect.setAttribute("truststorePass", "password");
        connect.setAttribute("truststoreProvider", "BC");
        connect.setAttribute("truststoreType", "BKS");
        return connect;
    }
}

