/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.x509.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.sdf.SdfContentVerifierProvider;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.operator.utils.GMSSLContentSignerUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class GMSSLCertUtils {
    public static X509Certificate generateCertByBC(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String sigAlgName, List<Extension> extensions) throws CertIOException, OperatorCreationException, CertificateException {
        return GMSSLCertUtils.generateCertByBC(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, issuerKey, subjectKey, sigAlgName, extensions);
    }

    public static X509Certificate generateCertByBC(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey issuerKey, PublicKey subjectKey, String sigAlgName, List<Extension> extensions) throws CertIOException, OperatorCreationException, CertificateException {
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByBC(sigAlgName, issuerKey);
        return GMSSLCertUtils.generateCert(issuer, subject, serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static X509Certificate generateCertByYunhsm(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, int issuerKeyIndex, String issuerKeyPassword, PublicKey subjectKey, String sigAlgName, List<Extension> extensions) throws CertIOException, OperatorCreationException, CertificateException {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(issuerKeyIndex, issuerKeyPassword);
        return GMSSLCertUtils.generateCertByYunhsm(issuer, subject, serial, notBefore, notAfter, (PrivateKey)sdfPrivateKey, subjectKey, sigAlgName, extensions);
    }

    public static X509Certificate generateCertByYunhsm(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PrivateKey sdfPrivateKey, PublicKey subjectKey, String sigAlgName, List<Extension> extensions) throws CertIOException, OperatorCreationException, CertificateException {
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByYunhsm(sigAlgName, sdfPrivateKey);
        return GMSSLCertUtils.generateCert(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static X509Certificate generateCertByPcie(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, int issuerKeyIndex, String issuerKeyPassword, PublicKey subjectKey, String sigAlgName, List<Extension> extensions) throws CertIOException, OperatorCreationException, CertificateException {
        SdfPrivateKey sdfPrivateKey = GMSSLSM2KeyUtils.genSdfPrivateKey(issuerKeyIndex, issuerKeyPassword);
        ContentSigner contentSigner = GMSSLContentSignerUtils.generateContentSignerByPcie(sigAlgName, (PrivateKey)sdfPrivateKey);
        return GMSSLCertUtils.generateCert(new X500Name(RFC4519Style.INSTANCE, issuer), new X500Name(RFC4519Style.INSTANCE, subject), serial, notBefore, notAfter, subjectKey, contentSigner, extensions);
    }

    public static X509Certificate generateCert(X500Name issuer, X500Name subject, BigInteger serial, Date notBefore, Date notAfter, PublicKey subjectKey, ContentSigner contentSigner, List<Extension> extensions) throws CertIOException, CertificateException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = GMSSLX509Utils.convertSubjectPublicKeyInfo((PublicKey)subjectKey);
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, subjectPublicKeyInfo);
        if (extensions != null) {
            for (Extension extension : extensions) {
                builder.addExtension(extension);
            }
        }
        X509CertificateHolder holder = builder.build(contentSigner);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(holder);
    }

    public static X509Certificate decodeCertByBC(PublicKey publicKey, byte[] certEncode) throws OperatorCreationException, CertificateException, IOException, CertException {
        ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
        return GMSSLCertUtils.decodeCert(contentVerifierProvider, certEncode);
    }

    public static X509Certificate decodeCertByYunhsm(PublicKey publicKey, byte[] certEncode) throws CertificateException, IOException, CertException {
        SdfContentVerifierProvider contentVerifierProvider = new SdfContentVerifierProvider(SdfCryptoType.YUNHSM, publicKey);
        return GMSSLCertUtils.decodeCert((ContentVerifierProvider)contentVerifierProvider, certEncode);
    }

    public static X509Certificate decodeCertByPcie(PublicKey publicKey, byte[] certEncode) throws CertificateException, IOException, CertException {
        SdfContentVerifierProvider contentVerifierProvider = new SdfContentVerifierProvider(SdfCryptoType.PCIE, publicKey);
        return GMSSLCertUtils.decodeCert((ContentVerifierProvider)contentVerifierProvider, certEncode);
    }

    public static X509Certificate decodeCertBySdf(SdfCryptoType sdfCryptoType, PublicKey publicKey, byte[] certEncode) throws CertificateException, IOException, CertException {
        SdfContentVerifierProvider contentVerifierProvider = new SdfContentVerifierProvider(sdfCryptoType, publicKey);
        return GMSSLCertUtils.decodeCert((ContentVerifierProvider)contentVerifierProvider, certEncode);
    }

    public static X509Certificate decodeCert(ContentVerifierProvider contentVerifierProvider, byte[] certEncode) throws IOException, CertException, CertificateException {
        X509CertificateHolder holder = new X509CertificateHolder(certEncode);
        holder.isSignatureValid(contentVerifierProvider);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(holder);
    }

    public static boolean verifyCertByBC(PublicKey publicKey, X509Certificate cert) throws Exception {
        ContentVerifierProvider contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
        return GMSSLCertUtils.verifyCert(contentVerifierProvider, cert);
    }

    public static boolean verifyCertByYunHsm(PublicKey publicKey, X509Certificate cert) throws Exception {
        SdfContentVerifierProvider contentVerifierProvider = new SdfContentVerifierProvider(SdfCryptoType.YUNHSM, publicKey);
        return GMSSLCertUtils.verifyCert((ContentVerifierProvider)contentVerifierProvider, cert);
    }

    public static boolean verifyCertByPCIE(PublicKey publicKey, X509Certificate cert) throws Exception {
        SdfContentVerifierProvider contentVerifierProvider = new SdfContentVerifierProvider(SdfCryptoType.PCIE, publicKey);
        return GMSSLCertUtils.verifyCert((ContentVerifierProvider)contentVerifierProvider, cert);
    }

    public static boolean verifyCert(ContentVerifierProvider verifierProvider, X509Certificate cert) throws Exception {
        return GMSSLCertUtils.verifyCert(verifierProvider, cert.getEncoded());
    }

    public static boolean verifyCert(ContentVerifierProvider verifierProvider, byte[] cert) throws Exception {
        X509CertificateHolder holder = new X509CertificateHolder(cert);
        return holder.isSignatureValid(verifierProvider);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

