/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.x509.utils.bean;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public enum GMSSLSignatureAlgorithm {
    SM3_WITH_SM2(GMObjectIdentifiers.sm2sign_with_sm3, "SM3withSM2"),
    SHA1_WITH_RSA(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1WITHRSA"),
    SHA256_WITH_RSA(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256WITHRSA"),
    SHA512_WITH_RSA(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512WITHRSA");

    private ASN1ObjectIdentifier aid;
    private String sigAlgName;

    public ASN1ObjectIdentifier getAid() {
        return this.aid;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    private GMSSLSignatureAlgorithm(ASN1ObjectIdentifier aid, String sigAlgName) {
        this.aid = aid;
        this.sigAlgName = sigAlgName;
    }

    public AlgorithmIdentifier convertAlgorithmIdentifier() {
        return new DefaultSignatureAlgorithmIdentifierFinder().find(this.sigAlgName);
    }

    public static GMSSLSignatureAlgorithm convertContentSignatureAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
        return GMSSLSignatureAlgorithm.convertContentSignatureAlgorithm(algorithm);
    }

    public static GMSSLSignatureAlgorithm convertContentSignatureAlgorithm(ASN1ObjectIdentifier aid) {
        if (aid == GMObjectIdentifiers.sm2sign_with_sm3) {
            return SM3_WITH_SM2;
        }
        if (aid == PKCSObjectIdentifiers.sha1WithRSAEncryption) {
            return SHA1_WITH_RSA;
        }
        if (aid == PKCSObjectIdentifiers.sha256WithRSAEncryption) {
            return SHA256_WITH_RSA;
        }
        if (aid == PKCSObjectIdentifiers.sha512WithRSAEncryption) {
            return SHA512_WITH_RSA;
        }
        return null;
    }
}

